<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Notify\V1\Service;

use Twilio\ListResource;
use Twilio\Options;
use Twilio\Page;
use Twilio\Serialize;
use Twilio\Stream;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
class BindingList extends ListResource {
    /**
     * Construct the BindingList
     * 
     * @param Version $version Version that contains the resource
     * @param string $serviceSid The service_sid
     * @return BindingList
     */
    public function __construct(Version $version, $serviceSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = array('serviceSid' => $serviceSid, );

        $this->uri = '/Services/' . rawurlencode($serviceSid) . '/Bindings';
    }

    /**
     * Create a new BindingInstance
     * 
     * @param string $identity The Identity to which this Binding belongs to.
     * @param string $bindingType The type of the Binding.
     * @param string $address The address specific to the channel.
     * @param array|Options $options Optional Arguments
     * @return BindingInstance Newly created BindingInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create($identity, $bindingType, $address, $options = array()) {
        $options = new Values($options);

        $data = Values::of(array(
            'Identity' => $identity,
            'BindingType' => $bindingType,
            'Address' => $address,
            'Tag' => Serialize::map($options['tag'], function($e) { return $e; }),
            'NotificationProtocolVersion' => $options['notificationProtocolVersion'],
            'CredentialSid' => $options['credentialSid'],
            'Endpoint' => $options['endpoint'],
        ));

        $payload = $this->version->create(
            'POST',
            $this->uri,
            array(),
            $data
        );

        return new BindingInstance($this->version, $payload, $this->solution['serviceSid']);
    }

    /**
     * Reads BindingInstance records from the API as a list.
     * Unlike stream(), this operation is eager and will load `limit` records into
     * memory before returning.
     *
     * @param array|Options $options Optional Arguments
     * @param int $limit Upper limit for the number of records to return. read()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, read()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return BindingInstance[] Array of results
     */
    public function read($options = array(), $limit = null, $pageSize = null) {
        return iterator_to_array($this->stream($options, $limit, $pageSize), false);
    }

    /**
     * Streams BindingInstance records from the API as a generator stream.
     * This operation lazily loads records as efficiently as possible until the
     * limit
     * is reached.
     * The results are returned as a generator, so this operation is memory
     * efficient.
     *
     * @param array|Options $options Optional Arguments
     * @param int $limit Upper limit for the number of records to return. stream()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, stream()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return Stream stream of results
     */
    public function stream($options = array(), $limit = null, $pageSize = null) {
        $limits = $this->version->readLimits($limit, $pageSize);

        $page = $this->page($options, $limits['pageSize']);

        return $this->version->stream($page, $limits['limit'], $limits['pageLimit']);
    }

    /**
     * Retrieve a single page of BindingInstance records from the API.
     * Request is executed immediately
     * 
     * @param array|Options $options Optional Arguments
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return Page Page of BindingInstance
     */
    public function page($options = array(), $pageSize = Values::NONE, $pageToken = Values::NONE, $pageNumber = Values::NONE) {
        $options = new Values($options);
        $params = Values::of(array(
            'StartDate' => Serialize::iso8601Date($options['startDate']),
            'EndDate' => Serialize::iso8601Date($options['endDate']),
            'Identity' => Serialize::map($options['identity'], function($e) { return $e; }),
            'Tag' => Serialize::map($options['tag'], function($e) { return $e; }),
            'PageToken' => $pageToken,
            'Page' => $pageNumber,
            'PageSize' => $pageSize,
        ));

        $response = $this->version->page(
            'GET',
            $this->uri,
            $params
        );

        return new BindingPage($this->version, $response, $this->solution);
    }

    /**
     * Retrieve a specific page of BindingInstance records from the API.
     * Request is executed immediately
     * 
     * @param string $targetUrl API-generated URL for the requested results page
     * @return Page Page of BindingInstance
     */
    public function getPage($targetUrl) {
        $response = $this->version->getDomain()->getClient()->request(
            'GET',
            $targetUrl
        );

        return new BindingPage($this->version, $response, $this->solution);
    }

    /**
     * Constructs a BindingContext
     * 
     * @param string $sid The sid
     * @return BindingContext
     */
    public function getContext($sid) {
        return new BindingContext($this->version, $this->solution['serviceSid'], $sid);
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        return '[Twilio.Notify.V1.BindingList]';
    }
}