/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-08-31 04:19:19 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=793 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=4061 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1556 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_digits_auth_devices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uniqid` text DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `device_name` text DEFAULT NULL,
  `device_type` text DEFAULT NULL,
  `device_info` text DEFAULT NULL,
  `key_id` text DEFAULT NULL,
  `cred_source` longtext DEFAULT NULL,
  `is_mobile` tinyint(4) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `last_used` datetime NOT NULL DEFAULT current_timestamp(),
  `time` datetime NOT NULL DEFAULT current_timestamp(),
  `ip` varchar(200) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_digits_failed_login_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `ip_address` varchar(200) NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `login_type` varchar(255) DEFAULT NULL,
  `failure_reason` varchar(255) DEFAULT NULL,
  `is_blocked` tinyint(1) DEFAULT 0,
  `attempt_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_until` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ip_address_idx` (`ip_address`),
  KEY `attempt_time_idx` (`attempt_time`),
  KEY `locked_until_idx` (`locked_until`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_digits_login_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `login_steps` varchar(100) DEFAULT NULL,
  `login_methods` varchar(100) DEFAULT NULL,
  `request_source` varchar(100) DEFAULT NULL,
  `request_type` varchar(100) DEFAULT NULL,
  `user_token` longtext DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `password_less` tinyint(4) DEFAULT NULL,
  `time` datetime NOT NULL DEFAULT current_timestamp(),
  `ip` varchar(200) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_request_source` (`request_source`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_digits_mobile_otp` (
  `countrycode` mediumint(8) NOT NULL,
  `mobileno` varchar(20) NOT NULL,
  `otp` varchar(32) NOT NULL,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  UNIQUE KEY `ID` (`mobileno`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_digits_otp` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `ref_id` bigint(20) DEFAULT NULL,
  `step_no` tinyint(4) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `countrycode` varchar(30) DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `otp` varchar(255) NOT NULL,
  `time` datetime NOT NULL DEFAULT current_timestamp(),
  `action_type` varchar(32) DEFAULT NULL,
  `ip` varchar(200) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_email` (`email`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_phone` (`countrycode`,`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_digits_request_logs` (
  `request_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(40) NOT NULL,
  `email` varchar(100) NOT NULL,
  `mode` varchar(100) NOT NULL,
  `request_type` varchar(100) NOT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `ip` varchar(200) NOT NULL,
  `time` datetime NOT NULL DEFAULT current_timestamp(),
  `message` text DEFAULT NULL,
  `gateway_id` varchar(255) DEFAULT NULL,
  `sub_gateway` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`request_id`),
  KEY `idx_phone` (`phone`),
  KEY `idx_email` (`email`),
  KEY `idx_ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_digits_user_session` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `identifier_id` varchar(255) NOT NULL,
  `session_token` text NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `data_key` longtext NOT NULL,
  `data_value` longtext NOT NULL,
  `session_expiry` datetime NOT NULL DEFAULT current_timestamp(),
  `time` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`session_id`),
  KEY `idx_identifier_id` (`identifier_id`(250))
) ENGINE=MyISAM AUTO_INCREMENT=138 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) NOT NULL,
  `cache_tags` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint(4) NOT NULL COMMENT 'mobile=1',
  `webp` tinyint(4) NOT NULL COMMENT 'webp=1',
  `expired` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=15359 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9388 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=869 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_sliders7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_slides7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  `static` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=302 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=158 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7048 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=172 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=191 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woodmart_wishlist_products` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(255) NOT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_woodmart_wishlists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("465", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-04-27 07:58:41", "2023-04-27 07:58:41", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1682582321;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1682582321;}", "5", "1", "2023-04-27 07:58:43", "2023-04-27 07:58:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("479", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-06-06 06:29:00", "2023-06-06 06:29:00", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1686032940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1686032940;}", "5", "1", "2023-06-06 06:29:03", "2023-06-06 06:29:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("491", "woocommerce_cleanup_draft_orders", "complete", "2023-11-28 06:48:09", "2023-11-28 05:48:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1701154089;s:18:\"\0*\0first_timestamp\";i:1655526941;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1701154089;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-22 20:04:13", "2025-08-22 20:04:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("496", "woocommerce_cleanup_draft_orders", "complete", "2025-08-23 20:04:13", "2025-08-23 20:04:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755979453;s:18:\"\0*\0first_timestamp\";i:1655526941;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755979453;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-24 03:04:08", "2025-08-24 03:04:08", "3862", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("497", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-22 20:12:54", "2025-08-22 20:12:54", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755893574;s:18:\"\0*\0first_timestamp\";i:1755893574;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755893574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-08-22 20:12:58", "2025-08-22 20:12:58", "3572", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("498", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-08-22 20:12:54", "2025-08-22 20:12:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893574;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893574;}", "5", "1", "2025-08-22 20:12:58", "2025-08-22 20:12:58", "3572", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("499", "woocommerce_run_update_callback", "complete", "2025-08-22 20:12:54", "2025-08-22 20:12:54", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893574;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893574;}", "2", "1", "2025-08-22 20:12:58", "2025-08-22 20:12:58", "3572", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("500", "woocommerce_run_update_callback", "complete", "2025-08-22 20:12:55", "2025-08-22 20:12:55", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893575;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893575;}", "2", "1", "2025-08-22 20:12:58", "2025-08-22 20:12:58", "3572", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("501", "woocommerce_run_update_callback", "complete", "2025-08-22 20:12:56", "2025-08-22 20:12:56", "{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893576;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893576;}", "2", "1", "2025-08-22 20:12:58", "2025-08-22 20:12:58", "3572", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("502", "woocommerce_run_update_callback", "complete", "2025-08-22 20:12:57", "2025-08-22 20:12:57", "{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893577;}", "2", "1", "2025-08-22 20:12:58", "2025-08-22 20:12:58", "3572", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("503", "woocommerce_run_update_callback", "complete", "2025-08-22 20:12:58", "2025-08-22 20:12:58", "{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893578;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893578;}", "2", "1", "2025-08-22 20:12:58", "2025-08-22 20:12:58", "3572", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("504", "woocommerce_run_update_callback", "complete", "2025-08-22 20:12:59", "2025-08-22 20:12:59", "{\"update_callback\":\"wc_update_910_add_launch_your_store_tour_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893579;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893579;}", "2", "1", "2025-08-22 20:13:06", "2025-08-22 20:13:06", "3574", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("505", "woocommerce_run_update_callback", "complete", "2025-08-22 20:13:00", "2025-08-22 20:13:00", "{\"update_callback\":\"wc_update_910_remove_obsolete_user_meta\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893580;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893580;}", "2", "1", "2025-08-22 20:13:07", "2025-08-22 20:13:07", "3574", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("506", "woocommerce_run_update_callback", "complete", "2025-08-22 20:13:01", "2025-08-22 20:13:01", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893581;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893581;}", "2", "1", "2025-08-22 20:13:07", "2025-08-22 20:13:07", "3574", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("507", "woocommerce_run_update_callback", "complete", "2025-08-22 20:13:02", "2025-08-22 20:13:02", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893582;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893582;}", "2", "1", "2025-08-22 20:13:07", "2025-08-22 20:13:07", "3574", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("508", "woocommerce_run_update_callback", "complete", "2025-08-22 20:13:03", "2025-08-22 20:13:03", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893583;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893583;}", "2", "1", "2025-08-22 20:13:07", "2025-08-22 20:13:07", "3574", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("509", "woocommerce_run_update_callback", "complete", "2025-08-22 20:13:04", "2025-08-22 20:13:04", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893584;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893584;}", "2", "1", "2025-08-22 20:13:07", "2025-08-22 20:13:07", "3574", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("510", "woocommerce_run_update_callback", "complete", "2025-08-22 20:13:05", "2025-08-22 20:13:05", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893585;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893585;}", "2", "1", "2025-08-22 20:13:07", "2025-08-22 20:13:07", "3574", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("511", "woocommerce_run_update_callback", "complete", "2025-08-22 20:13:06", "2025-08-22 20:13:06", "{\"update_callback\":\"wc_update_950_tracking_option_autoload\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893586;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893586;}", "2", "1", "2025-08-22 20:13:07", "2025-08-22 20:13:07", "3574", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("512", "woocommerce_run_update_callback", "complete", "2025-08-22 20:13:07", "2025-08-22 20:13:07", "{\"update_callback\":\"wc_update_961_migrate_default_email_base_color\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893587;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893587;}", "2", "1", "2025-08-22 20:13:07", "2025-08-22 20:13:07", "3575", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("513", "woocommerce_run_update_callback", "complete", "2025-08-22 20:13:08", "2025-08-22 20:13:08", "{\"update_callback\":\"wc_update_980_remove_order_attribution_install_banner_dismissed_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893588;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893588;}", "2", "1", "2025-08-22 20:13:24", "2025-08-22 20:13:24", "3577", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("514", "woocommerce_run_update_callback", "complete", "2025-08-22 20:13:09", "2025-08-22 20:13:09", "{\"update_callback\":\"wc_update_985_enable_new_payments_settings_page_feature\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893589;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893589;}", "2", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3577", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("515", "woocommerce_run_update_callback", "complete", "2025-08-22 20:13:10", "2025-08-22 20:13:10", "{\"update_callback\":\"wc_update_990_remove_wc_count_comments_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893590;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893590;}", "2", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3577", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("516", "woocommerce_run_update_callback", "complete", "2025-08-22 20:13:11", "2025-08-22 20:13:11", "{\"update_callback\":\"wc_update_990_remove_email_notes\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893591;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893591;}", "2", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3577", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("517", "woocommerce_run_update_callback", "complete", "2025-08-22 20:13:12", "2025-08-22 20:13:12", "{\"update_callback\":\"wc_update_1000_multisite_visibility_setting\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893592;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893592;}", "2", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3577", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("518", "woocommerce_run_update_callback", "complete", "2025-08-22 20:13:13", "2025-08-22 20:13:13", "{\"update_callback\":\"wc_update_1000_remove_patterns_toolkit_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893593;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893593;}", "2", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3577", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("519", "woocommerce_update_db_to_current_version", "complete", "2025-08-22 20:13:14", "2025-08-22 20:13:14", "{\"version\":\"10.1.1\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893594;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893594;}", "2", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3577", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("520", "woocommerce_scheduled_sales", "complete", "2025-08-23 00:00:00", "2025-08-23 00:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755907200;s:18:\"\0*\0first_timestamp\";i:1755907200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755907200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-23 03:45:46", "2025-08-23 03:45:46", "3689", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("521", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-22 21:12:58", "2025-08-22 21:12:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755897178;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755897178;}", "8", "1", "2025-08-22 21:14:14", "2025-08-22 21:14:14", "3667", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("522", "woocommerce_cleanup_personal_data", "complete", "2025-08-22 20:13:08", "2025-08-22 20:13:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755893588;s:18:\"\0*\0first_timestamp\";i:1755893588;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755893588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3577", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("523", "woocommerce_cleanup_logs", "complete", "2025-08-22 23:12:58", "2025-08-22 23:12:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755904378;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755904378;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-23 03:45:46", "2025-08-23 03:45:46", "3689", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("524", "woocommerce_cleanup_sessions", "complete", "2025-08-23 02:12:58", "2025-08-23 02:12:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755915178;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755915178;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-23 03:45:46", "2025-08-23 03:45:46", "3689", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("525", "woocommerce_geoip_updater", "complete", "2025-08-22 20:13:58", "2025-08-22 20:13:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755893638;s:18:\"\0*\0first_timestamp\";i:1755893638;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755893638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "8", "1", "2025-08-22 20:14:30", "2025-08-22 20:14:30", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("526", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-08-22 23:12:58", "2025-08-22 23:12:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755904378;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755904378;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-23 03:45:46", "2025-08-23 03:45:46", "3689", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("527", "wc_admin_daily_wrapper", "complete", "2025-08-22 20:12:58", "2025-08-22 20:12:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755893578;s:18:\"\0*\0first_timestamp\";i:1755893578;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755893578;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-22 20:13:06", "2025-08-22 20:13:06", "3573", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("528", "generate_category_lookup_table_wrapper", "complete", "2025-08-22 20:13:08", "2025-08-22 20:13:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893588;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893588;}", "8", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3577", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("529", "woocommerce_refresh_order_count_cache", "complete", "2025-08-23 08:12:58", "2025-08-23 08:12:58", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755936778;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755936778;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-23 08:13:01", "2025-08-23 08:13:01", "3806", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("530", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-23 20:12:58", "2025-08-23 20:12:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755979978;s:18:\"\0*\0first_timestamp\";i:1755893574;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755979978;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-08-24 03:04:20", "2025-08-24 03:04:20", "3862", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("531", "wc_admin_daily_wrapper", "complete", "2025-08-23 20:13:06", "2025-08-23 20:13:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755979986;s:18:\"\0*\0first_timestamp\";i:1755893578;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755979986;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-24 03:04:19", "2025-08-24 03:04:19", "3862", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("532", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "[190,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893605;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893605;}", "2", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3578", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("533", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "[180,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893605;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893605;}", "2", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3578", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("534", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "[179,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893605;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893605;}", "2", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3578", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("535", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "[178,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893605;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893605;}", "2", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3578", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("536", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "[176,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893605;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893605;}", "2", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3578", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("537", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "[156,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893605;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893605;}", "2", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3578", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("538", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "[152,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893605;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893605;}", "2", "1", "2025-08-22 20:13:25", "2025-08-22 20:13:25", "3578", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("539", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:26", "2025-08-22 20:13:26", "[147,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893606;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893606;}", "2", "1", "2025-08-22 20:13:31", "2025-08-22 20:13:31", "3580", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("540", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:26", "2025-08-22 20:13:26", "[82,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893606;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893606;}", "2", "1", "2025-08-22 20:13:31", "2025-08-22 20:13:31", "3580", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("541", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:26", "2025-08-22 20:13:26", "[81,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893606;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893606;}", "2", "1", "2025-08-22 20:13:31", "2025-08-22 20:13:31", "3580", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("542", "woocommerce_cleanup_personal_data", "complete", "2025-08-23 20:13:25", "2025-08-23 20:13:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755980005;s:18:\"\0*\0first_timestamp\";i:1755893588;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755980005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-24 03:04:20", "2025-08-24 03:04:20", "3862", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("543", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:26", "2025-08-22 20:13:26", "[76,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893606;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893606;}", "2", "1", "2025-08-22 20:13:31", "2025-08-22 20:13:31", "3580", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("544", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:26", "2025-08-22 20:13:26", "[65,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893606;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893606;}", "2", "1", "2025-08-22 20:13:31", "2025-08-22 20:13:31", "3580", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("545", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:26", "2025-08-22 20:13:26", "[64,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893606;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893606;}", "2", "1", "2025-08-22 20:13:31", "2025-08-22 20:13:31", "3580", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("546", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:26", "2025-08-22 20:13:26", "[30,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893606;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893606;}", "2", "1", "2025-08-22 20:13:31", "2025-08-22 20:13:31", "3580", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("547", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:52", "2025-08-22 20:13:52", "[639,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893632;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893632;}", "2", "1", "2025-08-22 20:14:27", "2025-08-22 20:14:27", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("548", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:52", "2025-08-22 20:13:52", "[640,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893632;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893632;}", "2", "1", "2025-08-22 20:14:27", "2025-08-22 20:14:27", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("549", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:52", "2025-08-22 20:13:52", "[641,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893632;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893632;}", "2", "1", "2025-08-22 20:14:27", "2025-08-22 20:14:27", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("550", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:53", "2025-08-22 20:13:53", "[642,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893633;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893633;}", "2", "1", "2025-08-22 20:14:27", "2025-08-22 20:14:27", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("551", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:53", "2025-08-22 20:13:53", "[643,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893633;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893633;}", "2", "1", "2025-08-22 20:14:27", "2025-08-22 20:14:27", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("552", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:53", "2025-08-22 20:13:53", "[644,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893633;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893633;}", "2", "1", "2025-08-22 20:14:27", "2025-08-22 20:14:27", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("553", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:54", "2025-08-22 20:13:54", "[645,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893634;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893634;}", "2", "1", "2025-08-22 20:14:28", "2025-08-22 20:14:28", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("554", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:54", "2025-08-22 20:13:54", "[646,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893634;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893634;}", "2", "1", "2025-08-22 20:14:28", "2025-08-22 20:14:28", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("555", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:54", "2025-08-22 20:13:54", "[647,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893634;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893634;}", "2", "1", "2025-08-22 20:14:28", "2025-08-22 20:14:28", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("556", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:55", "2025-08-22 20:13:55", "[648,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893635;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893635;}", "2", "1", "2025-08-22 20:14:29", "2025-08-22 20:14:29", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("557", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:55", "2025-08-22 20:13:55", "[649,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893635;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893635;}", "2", "1", "2025-08-22 20:14:29", "2025-08-22 20:14:29", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("558", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:55", "2025-08-22 20:13:55", "[650,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893635;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893635;}", "2", "1", "2025-08-22 20:14:29", "2025-08-22 20:14:29", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("559", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:55", "2025-08-22 20:13:55", "[651,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893635;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893635;}", "2", "1", "2025-08-22 20:14:29", "2025-08-22 20:14:29", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("560", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:56", "2025-08-22 20:13:56", "[652,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893636;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893636;}", "2", "1", "2025-08-22 20:14:29", "2025-08-22 20:14:29", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("561", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:56", "2025-08-22 20:13:56", "[653,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893636;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893636;}", "2", "1", "2025-08-22 20:14:29", "2025-08-22 20:14:29", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("562", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:56", "2025-08-22 20:13:56", "[654,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893636;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893636;}", "2", "1", "2025-08-22 20:14:29", "2025-08-22 20:14:29", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("563", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:57", "2025-08-22 20:13:57", "[655,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893637;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893637;}", "2", "1", "2025-08-22 20:14:29", "2025-08-22 20:14:29", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("564", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:57", "2025-08-22 20:13:57", "[656,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893637;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893637;}", "2", "1", "2025-08-22 20:14:30", "2025-08-22 20:14:30", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("565", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:13:57", "2025-08-22 20:13:57", "[657,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893637;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893637;}", "2", "1", "2025-08-22 20:14:30", "2025-08-22 20:14:30", "3582", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("566", "woocommerce_geoip_updater", "pending", "2025-09-06 20:14:30", "2025-09-06 20:14:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757189670;s:18:\"\0*\0first_timestamp\";i:1755893638;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757189670;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("567", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:14:35", "2025-08-22 20:14:35", "[648,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893675;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893675;}", "2", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("568", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:14:35", "2025-08-22 20:14:35", "[647,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893675;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893675;}", "2", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("569", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:14:35", "2025-08-22 20:14:35", "[646,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893675;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893675;}", "2", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("570", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:14:35", "2025-08-22 20:14:35", "[645,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893675;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893675;}", "2", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("571", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:14:36", "2025-08-22 20:14:36", "[644,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893676;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893676;}", "2", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("572", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:14:36", "2025-08-22 20:14:36", "[643,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893676;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893676;}", "2", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("573", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:14:36", "2025-08-22 20:14:36", "[642,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893676;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893676;}", "2", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("574", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:14:37", "2025-08-22 20:14:37", "[641,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893677;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893677;}", "2", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("575", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:14:37", "2025-08-22 20:14:37", "[640,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893677;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893677;}", "2", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("576", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:14:37", "2025-08-22 20:14:37", "[639,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893677;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893677;}", "2", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("577", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:42", "2025-08-22 20:14:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893682;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893682;}", "10", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("578", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:43", "2025-08-22 20:14:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893683;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893683;}", "10", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("579", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:43", "2025-08-22 20:14:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893683;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893683;}", "10", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("580", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:43", "2025-08-22 20:14:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893683;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893683;}", "10", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("581", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:43", "2025-08-22 20:14:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893683;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893683;}", "10", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("582", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:44", "2025-08-22 20:14:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893684;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893684;}", "10", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("583", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:44", "2025-08-22 20:14:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893684;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893684;}", "10", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("584", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:44", "2025-08-22 20:14:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893684;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893684;}", "10", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("585", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:44", "2025-08-22 20:14:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893684;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893684;}", "10", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("586", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:45", "2025-08-22 20:14:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893685;}", "10", "1", "2025-08-22 20:15:24", "2025-08-22 20:15:24", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("587", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:45", "2025-08-22 20:14:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893685;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("588", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:45", "2025-08-22 20:14:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893685;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("589", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:45", "2025-08-22 20:14:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893685;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("590", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:45", "2025-08-22 20:14:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893685;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("591", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:45", "2025-08-22 20:14:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893685;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3584", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("592", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:45", "2025-08-22 20:14:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893685;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("593", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:46", "2025-08-22 20:14:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893686;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("594", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:46", "2025-08-22 20:14:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893686;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("595", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:46", "2025-08-22 20:14:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893686;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("596", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:53", "2025-08-22 20:14:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893693;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("597", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:53", "2025-08-22 20:14:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893693;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("598", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:53", "2025-08-22 20:14:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893693;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("599", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:53", "2025-08-22 20:14:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893693;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("600", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:53", "2025-08-22 20:14:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893693;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("601", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:53", "2025-08-22 20:14:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893693;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("602", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:53", "2025-08-22 20:14:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893693;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("603", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:54", "2025-08-22 20:14:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893694;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("604", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:54", "2025-08-22 20:14:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893694;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("605", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:54", "2025-08-22 20:14:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893694;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("606", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:54", "2025-08-22 20:14:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893694;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("607", "wc_schedule_update_product_default_cat", "complete", "2025-08-22 20:14:54", "2025-08-22 20:14:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893694;}", "10", "1", "2025-08-22 20:15:25", "2025-08-22 20:15:25", "3585", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("608", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:15:33", "2025-08-22 20:15:33", "[652,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893733;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893733;}", "2", "1", "2025-08-22 20:15:45", "2025-08-22 20:15:45", "3587", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("609", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:15:35", "2025-08-22 20:15:35", "[653,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893735;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893735;}", "2", "1", "2025-08-22 20:15:46", "2025-08-22 20:15:46", "3587", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("610", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:15:39", "2025-08-22 20:15:39", "[654,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893739;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893739;}", "2", "1", "2025-08-22 20:15:46", "2025-08-22 20:15:46", "3587", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("611", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:15:41", "2025-08-22 20:15:41", "[655,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893741;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893741;}", "2", "1", "2025-08-22 20:15:46", "2025-08-22 20:15:46", "3587", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("612", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:09", "2025-08-22 20:16:09", "[656,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893769;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893769;}", "2", "1", "2025-08-22 20:16:21", "2025-08-22 20:16:21", "3589", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("613", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:09", "2025-08-22 20:16:09", "[657,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893769;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893769;}", "2", "1", "2025-08-22 20:16:21", "2025-08-22 20:16:21", "3589", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("614", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:10", "2025-08-22 20:16:10", "[652,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893770;}", "2", "1", "2025-08-22 20:16:21", "2025-08-22 20:16:21", "3589", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("615", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:10", "2025-08-22 20:16:10", "[653,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893770;}", "2", "1", "2025-08-22 20:16:21", "2025-08-22 20:16:21", "3589", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("616", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:10", "2025-08-22 20:16:10", "[654,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893770;}", "2", "1", "2025-08-22 20:16:21", "2025-08-22 20:16:21", "3589", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("617", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:10", "2025-08-22 20:16:10", "[655,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893770;}", "2", "1", "2025-08-22 20:16:21", "2025-08-22 20:16:21", "3589", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("618", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:10", "2025-08-22 20:16:10", "[649,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893770;}", "2", "1", "2025-08-22 20:16:21", "2025-08-22 20:16:21", "3589", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("619", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:11", "2025-08-22 20:16:11", "[650,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893771;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893771;}", "2", "1", "2025-08-22 20:16:21", "2025-08-22 20:16:21", "3589", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("620", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:11", "2025-08-22 20:16:11", "[651,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893771;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893771;}", "2", "1", "2025-08-22 20:16:21", "2025-08-22 20:16:21", "3589", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("621", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:38", "2025-08-22 20:16:38", "[156,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893798;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893798;}", "2", "1", "2025-08-22 20:16:49", "2025-08-22 20:16:49", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("622", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:38", "2025-08-22 20:16:38", "[147,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893798;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893798;}", "2", "1", "2025-08-22 20:16:49", "2025-08-22 20:16:49", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("623", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:39", "2025-08-22 20:16:39", "[152,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893799;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893799;}", "2", "1", "2025-08-22 20:16:49", "2025-08-22 20:16:49", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("624", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:39", "2025-08-22 20:16:39", "[657,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893799;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893799;}", "2", "1", "2025-08-22 20:16:49", "2025-08-22 20:16:49", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("625", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:39", "2025-08-22 20:16:39", "[650,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893799;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893799;}", "2", "1", "2025-08-22 20:16:49", "2025-08-22 20:16:49", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("626", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:40", "2025-08-22 20:16:40", "[651,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893800;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893800;}", "2", "1", "2025-08-22 20:16:49", "2025-08-22 20:16:49", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("627", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:40", "2025-08-22 20:16:40", "[649,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893800;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893800;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("628", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:41", "2025-08-22 20:16:41", "[180,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893801;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893801;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("629", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:41", "2025-08-22 20:16:41", "[179,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893801;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893801;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("630", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:41", "2025-08-22 20:16:41", "[178,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893801;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893801;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("631", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:41", "2025-08-22 20:16:41", "[176,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893801;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893801;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("632", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:41", "2025-08-22 20:16:41", "[652,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893801;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893801;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("633", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:41", "2025-08-22 20:16:41", "[648,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893801;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893801;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("634", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:42", "2025-08-22 20:16:42", "[646,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893802;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893802;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("635", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:42", "2025-08-22 20:16:42", "[645,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893802;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893802;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("636", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:42", "2025-08-22 20:16:42", "[656,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893802;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893802;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("637", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:43", "2025-08-22 20:16:43", "[647,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893803;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893803;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("638", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:43", "2025-08-22 20:16:43", "[643,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893803;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893803;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("639", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:43", "2025-08-22 20:16:43", "[642,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893803;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893803;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("640", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:44", "2025-08-22 20:16:44", "[641,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893804;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893804;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("641", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:44", "2025-08-22 20:16:44", "[76,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893804;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893804;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("642", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:44", "2025-08-22 20:16:44", "[65,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893804;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893804;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("643", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:45", "2025-08-22 20:16:45", "[640,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893805;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893805;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("644", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:45", "2025-08-22 20:16:45", "[81,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893805;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893805;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("645", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:46", "2025-08-22 20:16:46", "[64,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893806;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893806;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3591", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("646", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:47", "2025-08-22 20:16:47", "[82,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893807;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893807;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3592", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("647", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:47", "2025-08-22 20:16:47", "[30,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893807;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893807;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3592", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("648", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:47", "2025-08-22 20:16:47", "[639,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893807;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893807;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3592", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("649", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:48", "2025-08-22 20:16:48", "[190,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893808;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893808;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3592", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("650", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:48", "2025-08-22 20:16:48", "[655,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893808;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893808;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3592", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("651", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:49", "2025-08-22 20:16:49", "[654,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893809;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3592", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("652", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:49", "2025-08-22 20:16:49", "[653,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893809;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3592", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("653", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:16:49", "2025-08-22 20:16:49", "[644,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893809;}", "2", "1", "2025-08-22 20:16:50", "2025-08-22 20:16:50", "3592", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("654", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:16", "2025-08-22 20:17:16", "[700,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893836;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893836;}", "2", "1", "2025-08-22 20:17:22", "2025-08-22 20:17:22", "3594", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("655", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:49", "2025-08-22 20:17:49", "[702,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893869;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893869;}", "2", "1", "2025-08-22 20:18:05", "2025-08-22 20:18:05", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("656", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:49", "2025-08-22 20:17:49", "[703,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893869;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893869;}", "2", "1", "2025-08-22 20:18:05", "2025-08-22 20:18:05", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("657", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:49", "2025-08-22 20:17:49", "[704,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893869;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893869;}", "2", "1", "2025-08-22 20:18:05", "2025-08-22 20:18:05", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("658", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:50", "2025-08-22 20:17:50", "[705,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893870;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893870;}", "2", "1", "2025-08-22 20:18:05", "2025-08-22 20:18:05", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("659", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:50", "2025-08-22 20:17:50", "[706,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893870;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893870;}", "2", "1", "2025-08-22 20:18:05", "2025-08-22 20:18:05", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("660", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:50", "2025-08-22 20:17:50", "[707,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893870;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893870;}", "2", "1", "2025-08-22 20:18:05", "2025-08-22 20:18:05", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("661", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:51", "2025-08-22 20:17:51", "[708,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893871;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893871;}", "2", "1", "2025-08-22 20:18:06", "2025-08-22 20:18:06", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("662", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:51", "2025-08-22 20:17:51", "[709,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893871;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893871;}", "2", "1", "2025-08-22 20:18:06", "2025-08-22 20:18:06", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("663", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:51", "2025-08-22 20:17:51", "[710,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893871;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893871;}", "2", "1", "2025-08-22 20:18:06", "2025-08-22 20:18:06", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("664", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:51", "2025-08-22 20:17:51", "[711,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893871;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893871;}", "2", "1", "2025-08-22 20:18:06", "2025-08-22 20:18:06", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("665", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:52", "2025-08-22 20:17:52", "[712,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893872;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893872;}", "2", "1", "2025-08-22 20:18:06", "2025-08-22 20:18:06", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("666", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:52", "2025-08-22 20:17:52", "[713,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893872;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893872;}", "2", "1", "2025-08-22 20:18:06", "2025-08-22 20:18:06", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("667", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:52", "2025-08-22 20:17:52", "[714,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893872;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893872;}", "2", "1", "2025-08-22 20:18:06", "2025-08-22 20:18:06", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("668", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:53", "2025-08-22 20:17:53", "[715,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893873;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893873;}", "2", "1", "2025-08-22 20:18:06", "2025-08-22 20:18:06", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("669", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:53", "2025-08-22 20:17:53", "[716,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893873;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893873;}", "2", "1", "2025-08-22 20:18:06", "2025-08-22 20:18:06", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("670", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:53", "2025-08-22 20:17:53", "[717,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893873;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893873;}", "2", "1", "2025-08-22 20:18:06", "2025-08-22 20:18:06", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("671", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:53", "2025-08-22 20:17:53", "[718,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893873;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893873;}", "2", "1", "2025-08-22 20:18:06", "2025-08-22 20:18:06", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("672", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:54", "2025-08-22 20:17:54", "[719,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893874;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893874;}", "2", "1", "2025-08-22 20:18:06", "2025-08-22 20:18:06", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("673", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:17:54", "2025-08-22 20:17:54", "[720,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755893874;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755893874;}", "2", "1", "2025-08-22 20:18:06", "2025-08-22 20:18:06", "3596", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("674", "action_scheduler/migration_hook", "complete", "2025-08-22 20:22:59", "2025-08-22 20:22:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755894179;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755894179;}", "1", "1", "2025-08-22 20:23:29", "2025-08-22 20:23:29", "3603", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("675", "action_scheduler/migration_hook", "failed", "2025-08-22 20:24:30", "2025-08-22 20:24:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755894270;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755894270;}", "1", "1", "2025-08-22 20:24:32", "2025-08-22 20:24:32", "3607", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("676", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:35:43", "2025-08-22 20:35:43", "[705,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755894943;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755894943;}", "2", "1", "2025-08-22 20:36:25", "2025-08-22 20:36:25", "3620", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("677", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:35:58", "2025-08-22 20:35:58", "[706,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755894958;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755894958;}", "2", "1", "2025-08-22 20:36:25", "2025-08-22 20:36:25", "3620", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("678", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:36:09", "2025-08-22 20:36:09", "[708,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755894969;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755894969;}", "2", "1", "2025-08-22 20:36:25", "2025-08-22 20:36:25", "3620", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("679", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:36:26", "2025-08-22 20:36:26", "[709,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755894986;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755894986;}", "2", "1", "2025-08-22 20:36:36", "2025-08-22 20:36:36", "3622", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("680", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:36:39", "2025-08-22 20:36:39", "[710,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755894999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755894999;}", "2", "1", "2025-08-22 20:36:44", "2025-08-22 20:36:44", "3624", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("681", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:37:11", "2025-08-22 20:37:11", "[704,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755895031;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755895031;}", "2", "1", "2025-08-22 20:37:22", "2025-08-22 20:37:22", "3626", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("682", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:37:19", "2025-08-22 20:37:19", "[719,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755895039;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755895039;}", "2", "1", "2025-08-22 20:37:22", "2025-08-22 20:37:22", "3626", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("683", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:39:36", "2025-08-22 20:39:36", "[715,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755895176;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755895176;}", "2", "1", "2025-08-22 20:40:02", "2025-08-22 20:40:02", "3630", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("684", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:39:50", "2025-08-22 20:39:50", "[711,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755895190;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755895190;}", "2", "1", "2025-08-22 20:40:02", "2025-08-22 20:40:02", "3630", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("685", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-22 20:46:32", "2025-08-22 20:46:32", "[702,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755895592;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755895592;}", "2", "1", "2025-08-22 20:47:37", "2025-08-22 20:47:37", "3639", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("686", "action_scheduler/migration_hook", "complete", "2025-08-22 21:21:40", "2025-08-22 21:21:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755897700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755897700;}", "1", "1", "2025-08-22 21:22:00", "2025-08-22 21:22:00", "3675", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("687", "action_scheduler/migration_hook", "failed", "2025-08-22 21:23:00", "2025-08-22 21:23:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755897780;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755897780;}", "1", "1", "2025-08-22 21:23:04", "2025-08-22 21:23:04", "3680", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("688", "woocommerce_cleanup_logs", "complete", "2025-08-24 03:45:46", "2025-08-24 03:45:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756007146;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756007146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-24 04:37:04", "2025-08-24 04:37:04", "3864", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("689", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-08-24 03:45:46", "2025-08-24 03:45:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756007146;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756007146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-24 04:37:04", "2025-08-24 04:37:04", "3864", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("690", "woocommerce_scheduled_sales", "complete", "2025-08-24 03:45:46", "2025-08-24 03:45:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756007146;s:18:\"\0*\0first_timestamp\";i:1755907200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756007146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-24 04:37:04", "2025-08-24 04:37:04", "3864", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("691", "woocommerce_cleanup_sessions", "complete", "2025-08-23 15:45:46", "2025-08-23 15:45:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755963946;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755963946;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-23 16:53:12", "2025-08-23 16:53:12", "3857", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("692", "action_scheduler/migration_hook", "complete", "2025-08-23 04:24:23", "2025-08-23 04:24:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755923063;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755923063;}", "1", "1", "2025-08-23 04:25:22", "2025-08-23 04:25:22", "3728", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("693", "action_scheduler/migration_hook", "failed", "2025-08-23 04:26:22", "2025-08-23 04:26:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755923182;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755923182;}", "1", "1", "2025-08-23 04:26:25", "2025-08-23 04:26:25", "3731", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("694", "wc-admin_import_orders", "complete", "2025-08-23 04:27:18", "2025-08-23 04:27:18", "[834]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755923238;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755923238;}", "4", "1", "2025-08-23 04:27:31", "2025-08-23 04:27:31", "3733", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("695", "wc-admin_import_orders", "complete", "2025-08-23 04:28:44", "2025-08-23 04:28:44", "[834]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755923324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755923324;}", "4", "1", "2025-08-23 04:30:37", "2025-08-23 04:30:37", "3737", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("696", "wc-admin_import_orders", "complete", "2025-08-23 07:58:35", "2025-08-23 07:58:35", "[841]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755935915;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755935915;}", "4", "1", "2025-08-23 07:59:44", "2025-08-23 07:59:44", "3796", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("697", "woocommerce_refresh_order_count_cache", "complete", "2025-08-23 20:13:01", "2025-08-23 20:13:01", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755979981;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755979981;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-24 03:04:08", "2025-08-24 03:04:08", "3862", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("698", "woocommerce_cleanup_sessions", "complete", "2025-08-24 04:53:12", "2025-08-24 04:53:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756011192;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756011192;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-24 07:12:08", "2025-08-24 07:12:08", "3869", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("699", "woocommerce_cleanup_draft_orders", "complete", "2025-08-25 03:04:08", "2025-08-25 03:04:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756091048;s:18:\"\0*\0first_timestamp\";i:1655526941;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756091048;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-25 03:14:22", "2025-08-25 03:14:22", "3898", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("700", "woocommerce_refresh_order_count_cache", "complete", "2025-08-24 15:04:08", "2025-08-24 15:04:08", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756047848;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756047848;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-24 15:18:14", "2025-08-24 15:18:14", "3878", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("701", "wc_admin_daily_wrapper", "complete", "2025-08-25 03:04:19", "2025-08-25 03:04:19", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756091059;s:18:\"\0*\0first_timestamp\";i:1755893578;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756091059;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-25 03:14:30", "2025-08-25 03:14:30", "3898", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("702", "woocommerce_cleanup_personal_data", "complete", "2025-08-25 03:04:20", "2025-08-25 03:04:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756091060;s:18:\"\0*\0first_timestamp\";i:1755893588;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756091060;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-25 03:14:31", "2025-08-25 03:14:31", "3898", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("703", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-24 04:04:20", "2025-08-24 04:04:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756008260;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756008260;}", "8", "1", "2025-08-24 04:37:05", "2025-08-24 04:37:05", "3864", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("704", "generate_category_lookup_table_wrapper", "complete", "2025-08-24 03:04:30", "2025-08-24 03:04:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756004670;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756004670;}", "8", "1", "2025-08-24 04:37:04", "2025-08-24 04:37:04", "3864", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("705", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-25 03:04:20", "2025-08-25 03:04:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756091060;s:18:\"\0*\0first_timestamp\";i:1755893574;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756091060;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-08-25 03:14:31", "2025-08-25 03:14:31", "3898", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("706", "woocommerce_cleanup_logs", "complete", "2025-08-25 04:37:04", "2025-08-25 04:37:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756096624;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756096624;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-25 06:53:29", "2025-08-25 06:53:29", "3900", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("707", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-08-25 04:37:04", "2025-08-25 04:37:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756096624;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756096624;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-25 06:53:29", "2025-08-25 06:53:29", "3900", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("708", "woocommerce_scheduled_sales", "complete", "2025-08-25 04:37:04", "2025-08-25 04:37:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756096624;s:18:\"\0*\0first_timestamp\";i:1755907200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756096624;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-25 06:53:29", "2025-08-25 06:53:29", "3900", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("709", "wc-admin_import_orders", "complete", "2025-08-24 04:37:10", "2025-08-24 04:37:10", "[834]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756010230;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756010230;}", "4", "1", "2025-08-24 04:37:26", "2025-08-24 04:37:26", "3866", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("710", "wc-admin_import_orders", "complete", "2025-08-24 04:37:10", "2025-08-24 04:37:10", "[841]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756010230;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756010230;}", "4", "1", "2025-08-24 04:37:26", "2025-08-24 04:37:26", "3866", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("711", "woocommerce_cleanup_sessions", "complete", "2025-08-24 19:12:08", "2025-08-24 19:12:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756062728;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756062728;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-24 19:15:45", "2025-08-24 19:15:45", "3894", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("712", "woocommerce_refresh_order_count_cache", "complete", "2025-08-25 03:18:14", "2025-08-25 03:18:14", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756091894;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756091894;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-25 06:53:29", "2025-08-25 06:53:29", "3900", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("713", "woocommerce_cleanup_sessions", "complete", "2025-08-25 07:15:45", "2025-08-25 07:15:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756106145;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756106145;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-25 08:21:26", "2025-08-25 08:21:26", "3902", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("714", "woocommerce_cleanup_draft_orders", "complete", "2025-08-26 03:14:22", "2025-08-26 03:14:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756178062;s:18:\"\0*\0first_timestamp\";i:1655526941;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756178062;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-26 03:15:05", "2025-08-26 03:15:05", "3910", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("715", "wc_admin_daily_wrapper", "complete", "2025-08-26 03:14:30", "2025-08-26 03:14:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756178070;s:18:\"\0*\0first_timestamp\";i:1755893578;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756178070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-26 03:15:13", "2025-08-26 03:15:13", "3910", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("716", "woocommerce_cleanup_personal_data", "complete", "2025-08-26 03:14:31", "2025-08-26 03:14:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756178071;s:18:\"\0*\0first_timestamp\";i:1755893588;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756178071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-26 03:15:14", "2025-08-26 03:15:14", "3910", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("717", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-25 04:14:31", "2025-08-25 04:14:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756095271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756095271;}", "8", "1", "2025-08-25 06:53:29", "2025-08-25 06:53:29", "3900", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("718", "generate_category_lookup_table_wrapper", "complete", "2025-08-25 03:14:41", "2025-08-25 03:14:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756091681;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756091681;}", "8", "1", "2025-08-25 06:53:29", "2025-08-25 06:53:29", "3900", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("719", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-26 03:14:31", "2025-08-26 03:14:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756178071;s:18:\"\0*\0first_timestamp\";i:1755893574;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756178071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-08-26 03:15:14", "2025-08-26 03:15:14", "3910", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("720", "woocommerce_refresh_order_count_cache", "complete", "2025-08-25 18:53:29", "2025-08-25 18:53:29", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756148009;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756148009;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-25 20:43:25", "2025-08-25 20:43:25", "3908", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("721", "woocommerce_cleanup_logs", "complete", "2025-08-26 06:53:29", "2025-08-26 06:53:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756191209;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756191209;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-26 07:49:06", "2025-08-26 07:49:06", "3915", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("722", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-08-26 06:53:29", "2025-08-26 06:53:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756191209;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756191209;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-26 07:49:06", "2025-08-26 07:49:06", "3915", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("723", "woocommerce_scheduled_sales", "complete", "2025-08-26 06:53:29", "2025-08-26 06:53:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756191209;s:18:\"\0*\0first_timestamp\";i:1755907200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756191209;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-26 07:49:06", "2025-08-26 07:49:06", "3915", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("724", "woocommerce_cleanup_sessions", "complete", "2025-08-25 20:21:26", "2025-08-25 20:21:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756153286;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756153286;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-25 20:43:25", "2025-08-25 20:43:25", "3908", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("725", "woocommerce_refresh_order_count_cache", "complete", "2025-08-26 08:43:25", "2025-08-26 08:43:25", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756197805;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756197805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-26 09:08:55", "2025-08-26 09:08:55", "3918", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("726", "woocommerce_cleanup_sessions", "complete", "2025-08-26 08:43:25", "2025-08-26 08:43:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756197805;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756197805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-26 09:08:55", "2025-08-26 09:08:55", "3918", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("727", "woocommerce_cleanup_draft_orders", "complete", "2025-08-27 03:15:05", "2025-08-27 03:15:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756264505;s:18:\"\0*\0first_timestamp\";i:1655526941;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756264505;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-27 05:54:09", "2025-08-27 05:54:09", "3936", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("728", "wc_admin_daily_wrapper", "complete", "2025-08-27 03:15:13", "2025-08-27 03:15:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756264513;s:18:\"\0*\0first_timestamp\";i:1755893578;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756264513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-27 05:54:19", "2025-08-27 05:54:19", "3936", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("729", "woocommerce_cleanup_personal_data", "complete", "2025-08-27 03:15:14", "2025-08-27 03:15:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756264514;s:18:\"\0*\0first_timestamp\";i:1755893588;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756264514;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-27 05:54:20", "2025-08-27 05:54:20", "3936", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("730", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-26 04:15:14", "2025-08-26 04:15:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756181714;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756181714;}", "8", "1", "2025-08-26 05:40:39", "2025-08-26 05:40:39", "3912", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("731", "generate_category_lookup_table_wrapper", "complete", "2025-08-26 03:15:24", "2025-08-26 03:15:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756178124;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756178124;}", "8", "1", "2025-08-26 05:40:39", "2025-08-26 05:40:39", "3912", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("732", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-27 03:15:14", "2025-08-27 03:15:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756264514;s:18:\"\0*\0first_timestamp\";i:1755893574;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756264514;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-08-27 05:54:20", "2025-08-27 05:54:20", "3936", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("733", "woocommerce_cleanup_logs", "complete", "2025-08-27 07:49:06", "2025-08-27 07:49:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756280946;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756280946;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-27 07:57:03", "2025-08-27 07:57:03", "3942", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("734", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-08-27 07:49:06", "2025-08-27 07:49:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756280946;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756280946;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-27 07:57:03", "2025-08-27 07:57:03", "3942", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("735", "woocommerce_scheduled_sales", "complete", "2025-08-27 07:49:06", "2025-08-27 07:49:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756280946;s:18:\"\0*\0first_timestamp\";i:1755907200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756280946;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-27 07:57:03", "2025-08-27 07:57:03", "3942", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("736", "woocommerce_refresh_order_count_cache", "complete", "2025-08-26 21:08:55", "2025-08-26 21:08:55", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756242535;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756242535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-26 21:23:10", "2025-08-26 21:23:10", "3929", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("737", "woocommerce_cleanup_sessions", "complete", "2025-08-26 21:08:55", "2025-08-26 21:08:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756242535;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756242535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-26 21:23:10", "2025-08-26 21:23:10", "3929", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("738", "woocommerce_refresh_order_count_cache", "complete", "2025-08-27 09:23:10", "2025-08-27 09:23:10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756286590;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756286590;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-27 11:15:08", "2025-08-27 11:15:08", "3947", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("739", "woocommerce_cleanup_sessions", "complete", "2025-08-27 09:23:10", "2025-08-27 09:23:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756286590;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756286590;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-27 11:15:08", "2025-08-27 11:15:08", "3947", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("740", "woocommerce_cleanup_draft_orders", "complete", "2025-08-28 05:54:09", "2025-08-28 05:54:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756360449;s:18:\"\0*\0first_timestamp\";i:1655526941;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756360449;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-28 09:40:22", "2025-08-28 09:40:22", "3956", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("741", "wc_admin_daily_wrapper", "complete", "2025-08-28 05:54:19", "2025-08-28 05:54:19", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756360459;s:18:\"\0*\0first_timestamp\";i:1755893578;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756360459;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-28 09:40:30", "2025-08-28 09:40:30", "3956", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("742", "woocommerce_cleanup_personal_data", "complete", "2025-08-28 05:54:20", "2025-08-28 05:54:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756360460;s:18:\"\0*\0first_timestamp\";i:1755893588;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756360460;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-28 09:40:31", "2025-08-28 09:40:31", "3956", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("743", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-27 06:54:20", "2025-08-27 06:54:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756277660;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756277660;}", "8", "1", "2025-08-27 07:08:32", "2025-08-27 07:08:32", "3940", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("744", "generate_category_lookup_table_wrapper", "complete", "2025-08-27 05:54:30", "2025-08-27 05:54:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756274070;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756274070;}", "8", "1", "2025-08-27 06:35:25", "2025-08-27 06:35:25", "3938", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("745", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-28 05:54:20", "2025-08-28 05:54:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756360460;s:18:\"\0*\0first_timestamp\";i:1755893574;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756360460;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-08-28 09:40:32", "2025-08-28 09:40:32", "3956", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("746", "woocommerce_cleanup_logs", "complete", "2025-08-28 07:57:03", "2025-08-28 07:57:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756367823;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756367823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-28 09:40:32", "2025-08-28 09:40:32", "3956", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("747", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-08-28 07:57:03", "2025-08-28 07:57:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756367823;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756367823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-28 09:40:32", "2025-08-28 09:40:32", "3956", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("748", "woocommerce_scheduled_sales", "complete", "2025-08-28 07:57:03", "2025-08-28 07:57:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756367823;s:18:\"\0*\0first_timestamp\";i:1755907200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756367823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-28 09:40:32", "2025-08-28 09:40:32", "3956", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("749", "woocommerce_refresh_order_count_cache", "complete", "2025-08-27 23:15:08", "2025-08-27 23:15:08", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756336508;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756336508;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-27 23:39:14", "2025-08-27 23:39:14", "3952", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("750", "woocommerce_cleanup_sessions", "complete", "2025-08-27 23:15:08", "2025-08-27 23:15:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756336508;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756336508;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-27 23:39:14", "2025-08-27 23:39:14", "3952", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("751", "woocommerce_refresh_order_count_cache", "complete", "2025-08-28 11:39:14", "2025-08-28 11:39:14", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756381154;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756381154;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-28 12:19:33", "2025-08-28 12:19:33", "3958", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("752", "woocommerce_cleanup_sessions", "complete", "2025-08-28 11:39:14", "2025-08-28 11:39:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756381154;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756381154;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-28 12:19:33", "2025-08-28 12:19:33", "3958", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("753", "woocommerce_cleanup_draft_orders", "complete", "2025-08-29 09:40:22", "2025-08-29 09:40:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756460422;s:18:\"\0*\0first_timestamp\";i:1655526941;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756460422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-29 10:43:37", "2025-08-29 10:43:37", "3977", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("754", "wc_admin_daily_wrapper", "complete", "2025-08-29 09:40:30", "2025-08-29 09:40:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756460430;s:18:\"\0*\0first_timestamp\";i:1755893578;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756460430;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-29 10:43:45", "2025-08-29 10:43:45", "3977", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("755", "woocommerce_cleanup_personal_data", "complete", "2025-08-29 09:40:32", "2025-08-29 09:40:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756460432;s:18:\"\0*\0first_timestamp\";i:1755893588;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756460432;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-29 10:43:46", "2025-08-29 10:43:46", "3977", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("756", "woocommerce_cleanup_logs", "complete", "2025-08-29 09:40:32", "2025-08-29 09:40:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756460432;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756460432;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-29 10:43:46", "2025-08-29 10:43:46", "3977", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("757", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-08-29 09:40:32", "2025-08-29 09:40:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756460432;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756460432;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-29 10:43:46", "2025-08-29 10:43:46", "3977", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("758", "woocommerce_scheduled_sales", "complete", "2025-08-29 09:40:32", "2025-08-29 09:40:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756460432;s:18:\"\0*\0first_timestamp\";i:1755907200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756460432;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-29 10:43:46", "2025-08-29 10:43:46", "3977", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("759", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-28 10:40:32", "2025-08-28 10:40:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756377632;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756377632;}", "8", "1", "2025-08-28 12:19:33", "2025-08-28 12:19:33", "3958", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("760", "generate_category_lookup_table_wrapper", "complete", "2025-08-28 09:40:42", "2025-08-28 09:40:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756374042;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756374042;}", "8", "1", "2025-08-28 12:19:33", "2025-08-28 12:19:33", "3958", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("761", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-29 09:40:32", "2025-08-29 09:40:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756460432;s:18:\"\0*\0first_timestamp\";i:1755893574;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756460432;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-08-29 10:43:46", "2025-08-29 10:43:46", "3977", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("762", "woocommerce_refresh_order_count_cache", "complete", "2025-08-29 00:19:33", "2025-08-29 00:19:33", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756426773;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756426773;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-29 03:31:08", "2025-08-29 03:31:08", "3967", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("763", "woocommerce_cleanup_sessions", "complete", "2025-08-29 00:19:33", "2025-08-29 00:19:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756426773;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756426773;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-29 03:31:08", "2025-08-29 03:31:08", "3967", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("764", "woocommerce_refresh_order_count_cache", "complete", "2025-08-29 15:31:08", "2025-08-29 15:31:08", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756481468;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756481468;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-29 20:23:27", "2025-08-29 20:23:27", "3979", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("765", "woocommerce_cleanup_sessions", "complete", "2025-08-29 15:31:08", "2025-08-29 15:31:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756481468;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756481468;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-29 20:23:27", "2025-08-29 20:23:27", "3979", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("766", "woocommerce_cleanup_draft_orders", "complete", "2025-08-30 10:43:37", "2025-08-30 10:43:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756550617;s:18:\"\0*\0first_timestamp\";i:1655526941;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756550617;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-30 11:03:22", "2025-08-30 11:03:22", "4009", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("767", "wc_admin_daily_wrapper", "complete", "2025-08-30 10:43:45", "2025-08-30 10:43:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756550625;s:18:\"\0*\0first_timestamp\";i:1755893578;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756550625;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-30 11:03:30", "2025-08-30 11:03:30", "4009", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("768", "woocommerce_cleanup_personal_data", "complete", "2025-08-30 10:43:46", "2025-08-30 10:43:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756550626;s:18:\"\0*\0first_timestamp\";i:1755893588;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756550626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-30 11:03:31", "2025-08-30 11:03:31", "4009", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("769", "woocommerce_cleanup_logs", "complete", "2025-08-30 10:43:46", "2025-08-30 10:43:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756550626;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756550626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-30 11:03:31", "2025-08-30 11:03:31", "4009", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("770", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-08-30 10:43:46", "2025-08-30 10:43:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756550626;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756550626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-30 11:03:31", "2025-08-30 11:03:31", "4009", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("771", "woocommerce_scheduled_sales", "complete", "2025-08-30 10:43:46", "2025-08-30 10:43:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756550626;s:18:\"\0*\0first_timestamp\";i:1755907200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756550626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-30 11:03:31", "2025-08-30 11:03:31", "4009", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("772", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-29 11:43:46", "2025-08-29 11:43:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756467826;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756467826;}", "8", "1", "2025-08-29 20:23:27", "2025-08-29 20:23:27", "3979", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("773", "generate_category_lookup_table_wrapper", "complete", "2025-08-29 10:43:56", "2025-08-29 10:43:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756464236;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756464236;}", "8", "1", "2025-08-29 20:23:27", "2025-08-29 20:23:27", "3979", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("774", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-30 10:43:46", "2025-08-30 10:43:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756550626;s:18:\"\0*\0first_timestamp\";i:1755893574;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756550626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-08-30 11:03:31", "2025-08-30 11:03:31", "4009", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("775", "woocommerce_refresh_order_count_cache", "complete", "2025-08-30 08:23:27", "2025-08-30 08:23:27", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756542207;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756542207;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-30 11:03:22", "2025-08-30 11:03:22", "4009", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("776", "woocommerce_cleanup_sessions", "complete", "2025-08-30 08:23:27", "2025-08-30 08:23:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756542207;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756542207;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-30 11:03:22", "2025-08-30 11:03:22", "4009", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("777", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-29 20:23:38", "2025-08-29 20:23:38", "[700,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756499018;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756499018;}", "2", "1", "2025-08-30 05:46:39", "2025-08-30 05:46:39", "3981", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("778", "woocommerce_refresh_order_count_cache", "complete", "2025-08-30 23:03:22", "2025-08-30 23:03:22", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756595002;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756595002;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-31 01:33:05", "2025-08-31 01:33:05", "4043", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("779", "woocommerce_cleanup_sessions", "complete", "2025-08-30 23:03:22", "2025-08-30 23:03:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756595002;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756595002;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "1", "2025-08-31 01:33:05", "2025-08-31 01:33:05", "4043", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("780", "woocommerce_cleanup_draft_orders", "pending", "2025-08-31 11:03:22", "2025-08-31 11:03:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756638202;s:18:\"\0*\0first_timestamp\";i:1655526941;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756638202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("781", "wc_admin_daily_wrapper", "pending", "2025-08-31 11:03:30", "2025-08-31 11:03:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756638210;s:18:\"\0*\0first_timestamp\";i:1755893578;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756638210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("782", "woocommerce_cleanup_personal_data", "pending", "2025-08-31 11:03:31", "2025-08-31 11:03:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756638211;s:18:\"\0*\0first_timestamp\";i:1755893588;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756638211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("783", "woocommerce_cleanup_logs", "pending", "2025-08-31 11:03:31", "2025-08-31 11:03:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756638211;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756638211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("784", "woocommerce_cleanup_rate_limits_wrapper", "pending", "2025-08-31 11:03:31", "2025-08-31 11:03:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756638211;s:18:\"\0*\0first_timestamp\";i:1755904378;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756638211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("785", "woocommerce_scheduled_sales", "pending", "2025-08-31 11:03:31", "2025-08-31 11:03:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756638211;s:18:\"\0*\0first_timestamp\";i:1755907200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756638211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("786", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 12:03:31", "2025-08-30 12:03:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756555411;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756555411;}", "8", "1", "2025-08-30 12:17:30", "2025-08-30 12:17:30", "4011", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("787", "generate_category_lookup_table_wrapper", "complete", "2025-08-30 11:03:41", "2025-08-30 11:03:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756551821;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756551821;}", "8", "1", "2025-08-30 12:17:30", "2025-08-30 12:17:30", "4011", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("788", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-08-31 11:03:31", "2025-08-31 11:03:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756638211;s:18:\"\0*\0first_timestamp\";i:1755893574;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756638211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("789", "woocommerce_refresh_order_count_cache", "pending", "2025-08-31 13:33:05", "2025-08-31 13:33:05", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756647185;s:18:\"\0*\0first_timestamp\";i:1755936778;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756647185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("790", "woocommerce_cleanup_sessions", "pending", "2025-08-31 13:33:05", "2025-08-31 13:33:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756647185;s:18:\"\0*\0first_timestamp\";i:1755915178;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756647185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("791", "fetch_patterns", "complete", "2025-08-31 04:14:10", "2025-08-31 04:14:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756613650;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756613650;}", "6", "1", "2025-08-31 04:14:35", "2025-08-31 04:14:35", "4054", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("792", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-08-31 04:14:32", "2025-08-31 04:14:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756613672;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756613672;}", "5", "1", "2025-08-31 04:14:36", "2025-08-31 04:14:36", "4054", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wc_update_product_lookup_tables");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "ActionScheduler");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "woocommerce");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "count");
INSERT INTO `wp_actionscheduler_groups` VALUES("10", "wc_update_product_default_cat");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("590", "465", "ایجاد فعالیت", "2023-04-27 07:58:41", "2023-04-27 07:58:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("591", "465", "عملیات توسط WP Cron شروع شد", "2023-04-27 07:58:43", "2023-04-27 07:58:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("592", "465", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-04-27 07:58:43", "2023-04-27 07:58:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("632", "479", "ایجاد فعالیت", "2023-06-06 06:29:00", "2023-06-06 06:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("633", "479", "عملیات توسط WP Cron شروع شد", "2023-06-06 06:29:03", "2023-06-06 06:29:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("634", "479", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-06-06 06:29:03", "2023-06-06 06:29:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("670", "491", "ایجاد فعالیت", "2023-11-27 06:48:09", "2023-11-27 05:48:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("683", "491", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:04:13", "2025-08-22 20:04:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("684", "491", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:04:13", "2025-08-22 20:04:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("685", "496", "ایجاد فعالیت", "2025-08-22 20:04:13", "2025-08-22 20:04:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("686", "497", "ایجاد فعالیت", "2025-08-22 20:12:54", "2025-08-22 20:12:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("687", "498", "ایجاد فعالیت", "2025-08-22 20:12:54", "2025-08-22 20:12:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("688", "499", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("689", "500", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("690", "501", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("691", "502", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("692", "503", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("693", "504", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("694", "505", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("695", "506", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("696", "507", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("697", "508", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("698", "509", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("699", "510", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("700", "511", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("701", "512", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("702", "513", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("703", "514", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("704", "515", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("705", "516", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("706", "517", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("707", "518", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("708", "519", "ایجاد فعالیت", "2025-08-22 20:12:55", "2025-08-22 20:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("709", "498", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("710", "498", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("711", "499", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("712", "499", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("713", "500", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("714", "500", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("715", "501", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("716", "501", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("717", "502", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("718", "502", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("719", "503", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("720", "503", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("721", "497", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("722", "520", "ایجاد فعالیت", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("723", "521", "ایجاد فعالیت", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("724", "522", "ایجاد فعالیت", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("725", "523", "ایجاد فعالیت", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("726", "524", "ایجاد فعالیت", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("727", "525", "ایجاد فعالیت", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("728", "526", "ایجاد فعالیت", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("729", "527", "ایجاد فعالیت", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("730", "528", "ایجاد فعالیت", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("731", "529", "ایجاد فعالیت", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("732", "497", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("733", "530", "ایجاد فعالیت", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("734", "527", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:12:58", "2025-08-22 20:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("735", "527", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:06", "2025-08-22 20:13:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("736", "531", "ایجاد فعالیت", "2025-08-22 20:13:06", "2025-08-22 20:13:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("737", "504", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:06", "2025-08-22 20:13:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("738", "504", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:06", "2025-08-22 20:13:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("739", "505", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:06", "2025-08-22 20:13:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("740", "505", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("741", "506", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("742", "506", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("743", "507", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("744", "507", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("745", "508", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("746", "508", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("747", "509", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("748", "509", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("749", "510", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("750", "510", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("751", "511", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("752", "511", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("753", "512", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("754", "512", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:07", "2025-08-22 20:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("755", "532", "ایجاد فعالیت", "2025-08-22 20:13:24", "2025-08-22 20:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("756", "513", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:24", "2025-08-22 20:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("757", "513", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:24", "2025-08-22 20:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("758", "522", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:24", "2025-08-22 20:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("759", "533", "ایجاد فعالیت", "2025-08-22 20:13:24", "2025-08-22 20:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("760", "534", "ایجاد فعالیت", "2025-08-22 20:13:24", "2025-08-22 20:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("761", "535", "ایجاد فعالیت", "2025-08-22 20:13:24", "2025-08-22 20:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("762", "536", "ایجاد فعالیت", "2025-08-22 20:13:24", "2025-08-22 20:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("763", "537", "ایجاد فعالیت", "2025-08-22 20:13:24", "2025-08-22 20:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("764", "538", "ایجاد فعالیت", "2025-08-22 20:13:24", "2025-08-22 20:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("765", "539", "ایجاد فعالیت", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("766", "540", "ایجاد فعالیت", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("767", "541", "ایجاد فعالیت", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("768", "522", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("769", "542", "ایجاد فعالیت", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("770", "528", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("771", "528", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("772", "514", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("773", "514", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("774", "515", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("775", "543", "ایجاد فعالیت", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("776", "515", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("777", "516", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("778", "516", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("779", "517", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("780", "517", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("781", "518", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("782", "518", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("783", "519", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("784", "519", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("785", "532", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("786", "532", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("787", "544", "ایجاد فعالیت", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("788", "533", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("789", "533", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("790", "534", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("791", "534", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("792", "535", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("793", "535", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("794", "536", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("795", "536", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("796", "537", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("797", "545", "ایجاد فعالیت", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("798", "537", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("799", "538", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("800", "538", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("801", "546", "ایجاد فعالیت", "2025-08-22 20:13:25", "2025-08-22 20:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("802", "539", "عملیات توسط Async Request شروع شد", "2025-08-22 20:13:31", "2025-08-22 20:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("803", "539", "عملیات توسط Async Request کامل شد", "2025-08-22 20:13:31", "2025-08-22 20:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("804", "540", "عملیات توسط Async Request شروع شد", "2025-08-22 20:13:31", "2025-08-22 20:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("805", "540", "عملیات توسط Async Request کامل شد", "2025-08-22 20:13:31", "2025-08-22 20:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("806", "541", "عملیات توسط Async Request شروع شد", "2025-08-22 20:13:31", "2025-08-22 20:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("807", "541", "عملیات توسط Async Request کامل شد", "2025-08-22 20:13:31", "2025-08-22 20:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("808", "543", "عملیات توسط Async Request شروع شد", "2025-08-22 20:13:31", "2025-08-22 20:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("809", "543", "عملیات توسط Async Request کامل شد", "2025-08-22 20:13:31", "2025-08-22 20:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("810", "544", "عملیات توسط Async Request شروع شد", "2025-08-22 20:13:31", "2025-08-22 20:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("811", "544", "عملیات توسط Async Request کامل شد", "2025-08-22 20:13:31", "2025-08-22 20:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("812", "545", "عملیات توسط Async Request شروع شد", "2025-08-22 20:13:31", "2025-08-22 20:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("813", "545", "عملیات توسط Async Request کامل شد", "2025-08-22 20:13:31", "2025-08-22 20:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("814", "546", "عملیات توسط Async Request شروع شد", "2025-08-22 20:13:31", "2025-08-22 20:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("815", "546", "عملیات توسط Async Request کامل شد", "2025-08-22 20:13:31", "2025-08-22 20:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("816", "547", "ایجاد فعالیت", "2025-08-22 20:13:51", "2025-08-22 20:13:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("817", "548", "ایجاد فعالیت", "2025-08-22 20:13:51", "2025-08-22 20:13:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("818", "549", "ایجاد فعالیت", "2025-08-22 20:13:51", "2025-08-22 20:13:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("819", "550", "ایجاد فعالیت", "2025-08-22 20:13:52", "2025-08-22 20:13:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("820", "551", "ایجاد فعالیت", "2025-08-22 20:13:52", "2025-08-22 20:13:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("821", "552", "ایجاد فعالیت", "2025-08-22 20:13:52", "2025-08-22 20:13:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("822", "553", "ایجاد فعالیت", "2025-08-22 20:13:53", "2025-08-22 20:13:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("823", "554", "ایجاد فعالیت", "2025-08-22 20:13:53", "2025-08-22 20:13:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("824", "555", "ایجاد فعالیت", "2025-08-22 20:13:53", "2025-08-22 20:13:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("825", "556", "ایجاد فعالیت", "2025-08-22 20:13:54", "2025-08-22 20:13:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("826", "557", "ایجاد فعالیت", "2025-08-22 20:13:54", "2025-08-22 20:13:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("827", "558", "ایجاد فعالیت", "2025-08-22 20:13:54", "2025-08-22 20:13:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("828", "559", "ایجاد فعالیت", "2025-08-22 20:13:54", "2025-08-22 20:13:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("829", "560", "ایجاد فعالیت", "2025-08-22 20:13:55", "2025-08-22 20:13:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("830", "561", "ایجاد فعالیت", "2025-08-22 20:13:55", "2025-08-22 20:13:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("831", "562", "ایجاد فعالیت", "2025-08-22 20:13:55", "2025-08-22 20:13:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("832", "563", "ایجاد فعالیت", "2025-08-22 20:13:56", "2025-08-22 20:13:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("833", "564", "ایجاد فعالیت", "2025-08-22 20:13:56", "2025-08-22 20:13:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("834", "565", "ایجاد فعالیت", "2025-08-22 20:13:56", "2025-08-22 20:13:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("835", "547", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:27", "2025-08-22 20:14:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("836", "547", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:27", "2025-08-22 20:14:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("837", "548", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:27", "2025-08-22 20:14:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("838", "548", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:27", "2025-08-22 20:14:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("839", "549", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:27", "2025-08-22 20:14:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("840", "549", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:27", "2025-08-22 20:14:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("841", "550", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:27", "2025-08-22 20:14:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("842", "550", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:27", "2025-08-22 20:14:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("843", "551", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:27", "2025-08-22 20:14:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("844", "551", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:27", "2025-08-22 20:14:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("845", "552", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:27", "2025-08-22 20:14:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("846", "552", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:27", "2025-08-22 20:14:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("847", "553", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:27", "2025-08-22 20:14:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("848", "553", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:28", "2025-08-22 20:14:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("849", "554", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:28", "2025-08-22 20:14:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("850", "554", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:28", "2025-08-22 20:14:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("851", "555", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:28", "2025-08-22 20:14:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("852", "555", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:28", "2025-08-22 20:14:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("853", "556", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:28", "2025-08-22 20:14:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("854", "556", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("855", "557", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("856", "557", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("857", "558", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("858", "558", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("859", "559", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("860", "559", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("861", "560", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("862", "560", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("863", "561", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("864", "561", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("865", "562", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("866", "562", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("867", "563", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("868", "563", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("869", "564", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:29", "2025-08-22 20:14:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("870", "564", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:30", "2025-08-22 20:14:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("871", "565", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:30", "2025-08-22 20:14:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("872", "565", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:30", "2025-08-22 20:14:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("873", "525", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:14:30", "2025-08-22 20:14:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("874", "525", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:14:30", "2025-08-22 20:14:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("875", "566", "ایجاد فعالیت", "2025-08-22 20:14:30", "2025-08-22 20:14:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("876", "567", "ایجاد فعالیت", "2025-08-22 20:14:34", "2025-08-22 20:14:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("877", "568", "ایجاد فعالیت", "2025-08-22 20:14:34", "2025-08-22 20:14:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("878", "569", "ایجاد فعالیت", "2025-08-22 20:14:34", "2025-08-22 20:14:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("879", "570", "ایجاد فعالیت", "2025-08-22 20:14:34", "2025-08-22 20:14:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("880", "571", "ایجاد فعالیت", "2025-08-22 20:14:35", "2025-08-22 20:14:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("881", "572", "ایجاد فعالیت", "2025-08-22 20:14:35", "2025-08-22 20:14:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("882", "573", "ایجاد فعالیت", "2025-08-22 20:14:35", "2025-08-22 20:14:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("883", "574", "ایجاد فعالیت", "2025-08-22 20:14:36", "2025-08-22 20:14:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("884", "575", "ایجاد فعالیت", "2025-08-22 20:14:36", "2025-08-22 20:14:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("885", "576", "ایجاد فعالیت", "2025-08-22 20:14:36", "2025-08-22 20:14:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("886", "577", "ایجاد فعالیت", "2025-08-22 20:14:42", "2025-08-22 20:14:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("887", "578", "ایجاد فعالیت", "2025-08-22 20:14:43", "2025-08-22 20:14:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("888", "579", "ایجاد فعالیت", "2025-08-22 20:14:43", "2025-08-22 20:14:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("889", "580", "ایجاد فعالیت", "2025-08-22 20:14:43", "2025-08-22 20:14:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("890", "581", "ایجاد فعالیت", "2025-08-22 20:14:43", "2025-08-22 20:14:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("891", "582", "ایجاد فعالیت", "2025-08-22 20:14:44", "2025-08-22 20:14:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("892", "583", "ایجاد فعالیت", "2025-08-22 20:14:44", "2025-08-22 20:14:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("893", "584", "ایجاد فعالیت", "2025-08-22 20:14:44", "2025-08-22 20:14:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("894", "585", "ایجاد فعالیت", "2025-08-22 20:14:44", "2025-08-22 20:14:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("895", "586", "ایجاد فعالیت", "2025-08-22 20:14:45", "2025-08-22 20:14:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("896", "587", "ایجاد فعالیت", "2025-08-22 20:14:45", "2025-08-22 20:14:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("897", "588", "ایجاد فعالیت", "2025-08-22 20:14:45", "2025-08-22 20:14:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("898", "589", "ایجاد فعالیت", "2025-08-22 20:14:45", "2025-08-22 20:14:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("899", "590", "ایجاد فعالیت", "2025-08-22 20:14:45", "2025-08-22 20:14:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("900", "591", "ایجاد فعالیت", "2025-08-22 20:14:45", "2025-08-22 20:14:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("901", "592", "ایجاد فعالیت", "2025-08-22 20:14:45", "2025-08-22 20:14:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("902", "593", "ایجاد فعالیت", "2025-08-22 20:14:46", "2025-08-22 20:14:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("903", "594", "ایجاد فعالیت", "2025-08-22 20:14:46", "2025-08-22 20:14:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("904", "595", "ایجاد فعالیت", "2025-08-22 20:14:46", "2025-08-22 20:14:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("905", "596", "ایجاد فعالیت", "2025-08-22 20:14:53", "2025-08-22 20:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("906", "597", "ایجاد فعالیت", "2025-08-22 20:14:53", "2025-08-22 20:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("907", "598", "ایجاد فعالیت", "2025-08-22 20:14:53", "2025-08-22 20:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("908", "599", "ایجاد فعالیت", "2025-08-22 20:14:53", "2025-08-22 20:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("909", "600", "ایجاد فعالیت", "2025-08-22 20:14:53", "2025-08-22 20:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("910", "601", "ایجاد فعالیت", "2025-08-22 20:14:53", "2025-08-22 20:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("911", "602", "ایجاد فعالیت", "2025-08-22 20:14:53", "2025-08-22 20:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("912", "603", "ایجاد فعالیت", "2025-08-22 20:14:54", "2025-08-22 20:14:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("913", "604", "ایجاد فعالیت", "2025-08-22 20:14:54", "2025-08-22 20:14:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("914", "605", "ایجاد فعالیت", "2025-08-22 20:14:54", "2025-08-22 20:14:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("915", "606", "ایجاد فعالیت", "2025-08-22 20:14:54", "2025-08-22 20:14:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("916", "607", "ایجاد فعالیت", "2025-08-22 20:14:54", "2025-08-22 20:14:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("917", "567", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("918", "567", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("919", "568", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("920", "568", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("921", "569", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("922", "569", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("923", "570", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("924", "570", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("925", "571", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("926", "571", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("927", "572", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("928", "572", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("929", "573", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("930", "573", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("931", "574", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("932", "574", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("933", "575", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("934", "575", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("935", "576", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("936", "576", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("937", "577", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("938", "577", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("939", "578", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("940", "578", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("941", "579", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("942", "579", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("943", "580", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("944", "580", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("945", "581", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("946", "581", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("947", "582", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("948", "582", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("949", "583", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("950", "583", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("951", "584", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("952", "584", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("953", "585", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("954", "585", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("955", "586", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("956", "586", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:24", "2025-08-22 20:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("957", "587", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("958", "587", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("959", "588", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("960", "588", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("961", "589", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("962", "589", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("963", "590", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("964", "590", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("965", "591", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("966", "591", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("967", "592", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("968", "592", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("969", "593", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("970", "593", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("971", "594", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("972", "594", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("973", "595", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("974", "595", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("975", "596", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("976", "596", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("977", "597", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("978", "597", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("979", "598", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("980", "598", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("981", "599", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("982", "599", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("983", "600", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("984", "600", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("985", "601", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("986", "601", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("987", "602", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("988", "602", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("989", "603", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("990", "603", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("991", "604", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("992", "604", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("993", "605", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("994", "605", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("995", "606", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("996", "606", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("997", "607", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("998", "607", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:15:25", "2025-08-22 20:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("999", "608", "ایجاد فعالیت", "2025-08-22 20:15:32", "2025-08-22 20:15:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1000", "609", "ایجاد فعالیت", "2025-08-22 20:15:34", "2025-08-22 20:15:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1001", "610", "ایجاد فعالیت", "2025-08-22 20:15:38", "2025-08-22 20:15:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1002", "611", "ایجاد فعالیت", "2025-08-22 20:15:40", "2025-08-22 20:15:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1003", "608", "عملیات توسط Async Request شروع شد", "2025-08-22 20:15:45", "2025-08-22 20:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1004", "608", "عملیات توسط Async Request کامل شد", "2025-08-22 20:15:45", "2025-08-22 20:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1005", "609", "عملیات توسط Async Request شروع شد", "2025-08-22 20:15:45", "2025-08-22 20:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1006", "609", "عملیات توسط Async Request کامل شد", "2025-08-22 20:15:46", "2025-08-22 20:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1007", "610", "عملیات توسط Async Request شروع شد", "2025-08-22 20:15:46", "2025-08-22 20:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1008", "610", "عملیات توسط Async Request کامل شد", "2025-08-22 20:15:46", "2025-08-22 20:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1009", "611", "عملیات توسط Async Request شروع شد", "2025-08-22 20:15:46", "2025-08-22 20:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1010", "611", "عملیات توسط Async Request کامل شد", "2025-08-22 20:15:46", "2025-08-22 20:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1011", "612", "ایجاد فعالیت", "2025-08-22 20:16:08", "2025-08-22 20:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1012", "613", "ایجاد فعالیت", "2025-08-22 20:16:08", "2025-08-22 20:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1013", "614", "ایجاد فعالیت", "2025-08-22 20:16:09", "2025-08-22 20:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1014", "615", "ایجاد فعالیت", "2025-08-22 20:16:09", "2025-08-22 20:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1015", "616", "ایجاد فعالیت", "2025-08-22 20:16:09", "2025-08-22 20:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1016", "617", "ایجاد فعالیت", "2025-08-22 20:16:09", "2025-08-22 20:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1017", "618", "ایجاد فعالیت", "2025-08-22 20:16:09", "2025-08-22 20:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1018", "619", "ایجاد فعالیت", "2025-08-22 20:16:10", "2025-08-22 20:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1019", "620", "ایجاد فعالیت", "2025-08-22 20:16:10", "2025-08-22 20:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1020", "612", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1021", "612", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1022", "613", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1023", "613", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1024", "614", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1025", "614", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1026", "615", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1027", "615", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1028", "616", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1029", "616", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1030", "617", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1031", "617", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1032", "618", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1033", "618", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1034", "619", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1035", "619", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1036", "620", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1037", "620", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:16:21", "2025-08-22 20:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1038", "621", "ایجاد فعالیت", "2025-08-22 20:16:37", "2025-08-22 20:16:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1039", "622", "ایجاد فعالیت", "2025-08-22 20:16:37", "2025-08-22 20:16:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1040", "623", "ایجاد فعالیت", "2025-08-22 20:16:38", "2025-08-22 20:16:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1041", "624", "ایجاد فعالیت", "2025-08-22 20:16:38", "2025-08-22 20:16:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1042", "625", "ایجاد فعالیت", "2025-08-22 20:16:38", "2025-08-22 20:16:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1043", "626", "ایجاد فعالیت", "2025-08-22 20:16:39", "2025-08-22 20:16:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1044", "627", "ایجاد فعالیت", "2025-08-22 20:16:39", "2025-08-22 20:16:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1045", "628", "ایجاد فعالیت", "2025-08-22 20:16:40", "2025-08-22 20:16:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1046", "629", "ایجاد فعالیت", "2025-08-22 20:16:40", "2025-08-22 20:16:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1047", "630", "ایجاد فعالیت", "2025-08-22 20:16:40", "2025-08-22 20:16:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1048", "631", "ایجاد فعالیت", "2025-08-22 20:16:40", "2025-08-22 20:16:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1049", "632", "ایجاد فعالیت", "2025-08-22 20:16:40", "2025-08-22 20:16:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1050", "633", "ایجاد فعالیت", "2025-08-22 20:16:40", "2025-08-22 20:16:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1051", "634", "ایجاد فعالیت", "2025-08-22 20:16:41", "2025-08-22 20:16:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1052", "635", "ایجاد فعالیت", "2025-08-22 20:16:41", "2025-08-22 20:16:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1053", "636", "ایجاد فعالیت", "2025-08-22 20:16:41", "2025-08-22 20:16:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1054", "637", "ایجاد فعالیت", "2025-08-22 20:16:42", "2025-08-22 20:16:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1055", "638", "ایجاد فعالیت", "2025-08-22 20:16:42", "2025-08-22 20:16:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1056", "639", "ایجاد فعالیت", "2025-08-22 20:16:42", "2025-08-22 20:16:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1057", "640", "ایجاد فعالیت", "2025-08-22 20:16:43", "2025-08-22 20:16:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1058", "641", "ایجاد فعالیت", "2025-08-22 20:16:43", "2025-08-22 20:16:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1059", "642", "ایجاد فعالیت", "2025-08-22 20:16:43", "2025-08-22 20:16:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1060", "643", "ایجاد فعالیت", "2025-08-22 20:16:44", "2025-08-22 20:16:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1061", "644", "ایجاد فعالیت", "2025-08-22 20:16:44", "2025-08-22 20:16:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1062", "645", "ایجاد فعالیت", "2025-08-22 20:16:45", "2025-08-22 20:16:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1063", "646", "ایجاد فعالیت", "2025-08-22 20:16:46", "2025-08-22 20:16:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1064", "647", "ایجاد فعالیت", "2025-08-22 20:16:46", "2025-08-22 20:16:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1065", "648", "ایجاد فعالیت", "2025-08-22 20:16:46", "2025-08-22 20:16:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1066", "649", "ایجاد فعالیت", "2025-08-22 20:16:47", "2025-08-22 20:16:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("1067", "650", "ایجاد فعالیت", "2025-08-22 20:16:47", "2025-08-22 20:16:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("1068", "651", "ایجاد فعالیت", "2025-08-22 20:16:48", "2025-08-22 20:16:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1069", "652", "ایجاد فعالیت", "2025-08-22 20:16:48", "2025-08-22 20:16:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1070", "653", "ایجاد فعالیت", "2025-08-22 20:16:48", "2025-08-22 20:16:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1071", "621", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:49", "2025-08-22 20:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1072", "621", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:49", "2025-08-22 20:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1073", "622", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:49", "2025-08-22 20:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1074", "622", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:49", "2025-08-22 20:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1075", "623", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:49", "2025-08-22 20:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1076", "623", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:49", "2025-08-22 20:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1077", "624", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:49", "2025-08-22 20:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1078", "624", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:49", "2025-08-22 20:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1079", "625", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:49", "2025-08-22 20:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1080", "625", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:49", "2025-08-22 20:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1081", "626", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:49", "2025-08-22 20:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1082", "626", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:49", "2025-08-22 20:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1083", "627", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:49", "2025-08-22 20:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1084", "627", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1085", "628", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1086", "628", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1087", "629", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1088", "629", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1089", "630", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1090", "630", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1091", "631", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1092", "631", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1093", "632", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1094", "632", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1095", "633", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1096", "633", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1097", "634", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1098", "634", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1099", "635", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1100", "635", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1101", "636", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1102", "636", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1103", "637", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1104", "637", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1105", "638", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1106", "638", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1107", "639", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1108", "639", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1109", "640", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1110", "640", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1111", "641", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1112", "641", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1113", "642", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1114", "642", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1115", "643", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1116", "643", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1117", "644", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1118", "644", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1119", "645", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1120", "645", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1121", "646", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1122", "646", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1123", "647", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1124", "647", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1125", "648", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1126", "648", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1127", "649", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1128", "649", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1129", "650", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1130", "650", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1131", "651", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1132", "651", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1133", "652", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1134", "652", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1135", "653", "عملیات توسط Async Request شروع شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1136", "653", "عملیات توسط Async Request کامل شد", "2025-08-22 20:16:50", "2025-08-22 20:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1137", "654", "ایجاد فعالیت", "2025-08-22 20:17:15", "2025-08-22 20:17:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1138", "654", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:17:22", "2025-08-22 20:17:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1139", "654", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:17:22", "2025-08-22 20:17:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1140", "655", "ایجاد فعالیت", "2025-08-22 20:17:48", "2025-08-22 20:17:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1141", "656", "ایجاد فعالیت", "2025-08-22 20:17:48", "2025-08-22 20:17:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1142", "657", "ایجاد فعالیت", "2025-08-22 20:17:48", "2025-08-22 20:17:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1143", "658", "ایجاد فعالیت", "2025-08-22 20:17:49", "2025-08-22 20:17:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1144", "659", "ایجاد فعالیت", "2025-08-22 20:17:49", "2025-08-22 20:17:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1145", "660", "ایجاد فعالیت", "2025-08-22 20:17:49", "2025-08-22 20:17:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1146", "661", "ایجاد فعالیت", "2025-08-22 20:17:50", "2025-08-22 20:17:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1147", "662", "ایجاد فعالیت", "2025-08-22 20:17:50", "2025-08-22 20:17:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1148", "663", "ایجاد فعالیت", "2025-08-22 20:17:50", "2025-08-22 20:17:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1149", "664", "ایجاد فعالیت", "2025-08-22 20:17:50", "2025-08-22 20:17:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1150", "665", "ایجاد فعالیت", "2025-08-22 20:17:51", "2025-08-22 20:17:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1151", "666", "ایجاد فعالیت", "2025-08-22 20:17:51", "2025-08-22 20:17:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1152", "667", "ایجاد فعالیت", "2025-08-22 20:17:51", "2025-08-22 20:17:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1153", "668", "ایجاد فعالیت", "2025-08-22 20:17:52", "2025-08-22 20:17:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1154", "669", "ایجاد فعالیت", "2025-08-22 20:17:52", "2025-08-22 20:17:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1155", "670", "ایجاد فعالیت", "2025-08-22 20:17:52", "2025-08-22 20:17:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1156", "671", "ایجاد فعالیت", "2025-08-22 20:17:52", "2025-08-22 20:17:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1157", "672", "ایجاد فعالیت", "2025-08-22 20:17:53", "2025-08-22 20:17:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1158", "673", "ایجاد فعالیت", "2025-08-22 20:17:53", "2025-08-22 20:17:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1159", "655", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:05", "2025-08-22 20:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1160", "655", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:05", "2025-08-22 20:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1161", "656", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:05", "2025-08-22 20:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1162", "656", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:05", "2025-08-22 20:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1163", "657", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:05", "2025-08-22 20:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1164", "657", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:05", "2025-08-22 20:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1165", "658", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:05", "2025-08-22 20:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1166", "658", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:05", "2025-08-22 20:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1167", "659", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:05", "2025-08-22 20:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1168", "659", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:05", "2025-08-22 20:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1169", "660", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:05", "2025-08-22 20:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1170", "660", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:05", "2025-08-22 20:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1171", "661", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:05", "2025-08-22 20:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1172", "661", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1173", "662", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1174", "662", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1175", "663", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1176", "663", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1177", "664", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1178", "664", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1179", "665", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1180", "665", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1181", "666", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1182", "666", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1183", "667", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1184", "667", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1185", "668", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1186", "668", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1187", "669", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1188", "669", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1189", "670", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1190", "670", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1191", "671", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1192", "671", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1193", "672", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1194", "672", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1195", "673", "عملیات توسط Async Request شروع شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1196", "673", "عملیات توسط Async Request کامل شد", "2025-08-22 20:18:06", "2025-08-22 20:18:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1197", "674", "ایجاد فعالیت", "2025-08-22 20:21:59", "2025-08-22 20:21:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1198", "674", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:23:29", "2025-08-22 20:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1199", "674", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:23:29", "2025-08-22 20:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1200", "675", "ایجاد فعالیت", "2025-08-22 20:23:30", "2025-08-22 20:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1201", "675", "عملیات توسط Async Request شروع شد", "2025-08-22 20:24:32", "2025-08-22 20:24:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1202", "675", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-08-22 20:24:32", "2025-08-22 20:24:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1203", "676", "ایجاد فعالیت", "2025-08-22 20:35:42", "2025-08-22 20:35:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1204", "677", "ایجاد فعالیت", "2025-08-22 20:35:57", "2025-08-22 20:35:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1205", "678", "ایجاد فعالیت", "2025-08-22 20:36:08", "2025-08-22 20:36:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1206", "679", "ایجاد فعالیت", "2025-08-22 20:36:25", "2025-08-22 20:36:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1207", "676", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:36:25", "2025-08-22 20:36:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1208", "676", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:36:25", "2025-08-22 20:36:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1209", "677", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:36:25", "2025-08-22 20:36:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1210", "677", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:36:25", "2025-08-22 20:36:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1211", "678", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:36:25", "2025-08-22 20:36:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1212", "678", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:36:25", "2025-08-22 20:36:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1213", "679", "عملیات توسط Async Request شروع شد", "2025-08-22 20:36:36", "2025-08-22 20:36:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("1214", "679", "عملیات توسط Async Request کامل شد", "2025-08-22 20:36:36", "2025-08-22 20:36:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("1215", "680", "ایجاد فعالیت", "2025-08-22 20:36:38", "2025-08-22 20:36:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1216", "680", "عملیات توسط Async Request شروع شد", "2025-08-22 20:36:44", "2025-08-22 20:36:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1217", "680", "عملیات توسط Async Request کامل شد", "2025-08-22 20:36:44", "2025-08-22 20:36:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1218", "681", "ایجاد فعالیت", "2025-08-22 20:37:10", "2025-08-22 20:37:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1219", "682", "ایجاد فعالیت", "2025-08-22 20:37:18", "2025-08-22 20:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1220", "681", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:37:21", "2025-08-22 20:37:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1221", "681", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:37:21", "2025-08-22 20:37:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1222", "682", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:37:22", "2025-08-22 20:37:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1223", "682", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:37:22", "2025-08-22 20:37:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1224", "683", "ایجاد فعالیت", "2025-08-22 20:39:35", "2025-08-22 20:39:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1225", "684", "ایجاد فعالیت", "2025-08-22 20:39:49", "2025-08-22 20:39:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1226", "683", "عملیات توسط Async Request شروع شد", "2025-08-22 20:40:01", "2025-08-22 20:40:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1227", "683", "عملیات توسط Async Request کامل شد", "2025-08-22 20:40:02", "2025-08-22 20:40:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1228", "684", "عملیات توسط Async Request شروع شد", "2025-08-22 20:40:02", "2025-08-22 20:40:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1229", "684", "عملیات توسط Async Request کامل شد", "2025-08-22 20:40:02", "2025-08-22 20:40:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1230", "685", "ایجاد فعالیت", "2025-08-22 20:46:31", "2025-08-22 20:46:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1231", "685", "عملیات توسط WP Cron شروع شد", "2025-08-22 20:47:37", "2025-08-22 20:47:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1232", "685", "عملیات توسط WP Cron کامل شد", "2025-08-22 20:47:37", "2025-08-22 20:47:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1233", "521", "عملیات توسط WP Cron شروع شد", "2025-08-22 21:14:14", "2025-08-22 21:14:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1234", "521", "عملیات توسط WP Cron کامل شد", "2025-08-22 21:14:14", "2025-08-22 21:14:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1235", "686", "ایجاد فعالیت", "2025-08-22 21:20:40", "2025-08-22 21:20:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1236", "686", "عملیات توسط WP Cron شروع شد", "2025-08-22 21:22:00", "2025-08-22 21:22:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1237", "686", "عملیات توسط WP Cron کامل شد", "2025-08-22 21:22:00", "2025-08-22 21:22:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1238", "687", "ایجاد فعالیت", "2025-08-22 21:22:00", "2025-08-22 21:22:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1239", "687", "عملیات توسط Async Request شروع شد", "2025-08-22 21:23:04", "2025-08-22 21:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1240", "687", "اقدام از طریق Async Request انجام نشد: اقدام زمان‌بندی‌شده برای action_scheduler/migration_hook اجرا نخواهد شد زیرا هیچ فراخوانی برگشتی ثبت نشده است.", "2025-08-22 21:23:04", "2025-08-22 21:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1241", "523", "عملیات توسط WP Cron شروع شد", "2025-08-23 03:45:46", "2025-08-23 03:45:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1242", "523", "عملیات توسط WP Cron کامل شد", "2025-08-23 03:45:46", "2025-08-23 03:45:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1243", "688", "ایجاد فعالیت", "2025-08-23 03:45:46", "2025-08-23 03:45:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1244", "526", "عملیات توسط WP Cron شروع شد", "2025-08-23 03:45:46", "2025-08-23 03:45:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1245", "526", "عملیات توسط WP Cron کامل شد", "2025-08-23 03:45:46", "2025-08-23 03:45:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1246", "689", "ایجاد فعالیت", "2025-08-23 03:45:46", "2025-08-23 03:45:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1247", "520", "عملیات توسط WP Cron شروع شد", "2025-08-23 03:45:46", "2025-08-23 03:45:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1248", "520", "عملیات توسط WP Cron کامل شد", "2025-08-23 03:45:46", "2025-08-23 03:45:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1249", "690", "ایجاد فعالیت", "2025-08-23 03:45:46", "2025-08-23 03:45:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1250", "524", "عملیات توسط WP Cron شروع شد", "2025-08-23 03:45:46", "2025-08-23 03:45:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1251", "524", "عملیات توسط WP Cron کامل شد", "2025-08-23 03:45:46", "2025-08-23 03:45:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1252", "691", "ایجاد فعالیت", "2025-08-23 03:45:46", "2025-08-23 03:45:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1253", "692", "ایجاد فعالیت", "2025-08-23 04:23:23", "2025-08-23 04:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1254", "692", "عملیات توسط WP Cron شروع شد", "2025-08-23 04:25:22", "2025-08-23 04:25:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1255", "692", "عملیات توسط WP Cron کامل شد", "2025-08-23 04:25:22", "2025-08-23 04:25:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1256", "693", "ایجاد فعالیت", "2025-08-23 04:25:22", "2025-08-23 04:25:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1257", "693", "عملیات توسط WP Cron شروع شد", "2025-08-23 04:26:25", "2025-08-23 04:26:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1258", "693", "اقدام از طریق WP Cron انجام نشد: اقدام زمان‌بندی‌شده برای action_scheduler/migration_hook اجرا نخواهد شد زیرا هیچ فراخوانی برگشتی ثبت نشده است.", "2025-08-23 04:26:25", "2025-08-23 04:26:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1259", "694", "ایجاد فعالیت", "2025-08-23 04:27:13", "2025-08-23 04:27:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1260", "694", "عملیات توسط WP Cron شروع شد", "2025-08-23 04:27:31", "2025-08-23 04:27:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1261", "694", "عملیات توسط WP Cron کامل شد", "2025-08-23 04:27:31", "2025-08-23 04:27:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1262", "695", "ایجاد فعالیت", "2025-08-23 04:28:39", "2025-08-23 04:28:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1263", "695", "عملیات توسط WP Cron شروع شد", "2025-08-23 04:30:37", "2025-08-23 04:30:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1264", "695", "عملیات توسط WP Cron کامل شد", "2025-08-23 04:30:37", "2025-08-23 04:30:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1265", "696", "ایجاد فعالیت", "2025-08-23 07:58:30", "2025-08-23 07:58:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1266", "696", "عملیات توسط WP Cron شروع شد", "2025-08-23 07:59:43", "2025-08-23 07:59:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1267", "696", "عملیات توسط WP Cron کامل شد", "2025-08-23 07:59:44", "2025-08-23 07:59:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1268", "529", "عملیات توسط WP Cron شروع شد", "2025-08-23 08:13:01", "2025-08-23 08:13:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1269", "529", "عملیات توسط WP Cron کامل شد", "2025-08-23 08:13:01", "2025-08-23 08:13:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1270", "697", "ایجاد فعالیت", "2025-08-23 08:13:01", "2025-08-23 08:13:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1271", "691", "عملیات توسط WP Cron شروع شد", "2025-08-23 16:53:11", "2025-08-23 16:53:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1272", "691", "عملیات توسط WP Cron کامل شد", "2025-08-23 16:53:12", "2025-08-23 16:53:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1273", "698", "ایجاد فعالیت", "2025-08-23 16:53:12", "2025-08-23 16:53:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1274", "496", "عملیات توسط WP Cron شروع شد", "2025-08-24 03:04:08", "2025-08-24 03:04:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1275", "496", "عملیات توسط WP Cron کامل شد", "2025-08-24 03:04:08", "2025-08-24 03:04:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1276", "699", "ایجاد فعالیت", "2025-08-24 03:04:08", "2025-08-24 03:04:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1277", "697", "عملیات توسط WP Cron شروع شد", "2025-08-24 03:04:08", "2025-08-24 03:04:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1278", "697", "عملیات توسط WP Cron کامل شد", "2025-08-24 03:04:08", "2025-08-24 03:04:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1279", "700", "ایجاد فعالیت", "2025-08-24 03:04:08", "2025-08-24 03:04:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1280", "531", "عملیات توسط WP Cron شروع شد", "2025-08-24 03:04:08", "2025-08-24 03:04:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1281", "531", "عملیات توسط WP Cron کامل شد", "2025-08-24 03:04:19", "2025-08-24 03:04:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1282", "701", "ایجاد فعالیت", "2025-08-24 03:04:19", "2025-08-24 03:04:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1283", "542", "عملیات توسط WP Cron شروع شد", "2025-08-24 03:04:19", "2025-08-24 03:04:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1284", "542", "عملیات توسط WP Cron کامل شد", "2025-08-24 03:04:20", "2025-08-24 03:04:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1285", "702", "ایجاد فعالیت", "2025-08-24 03:04:20", "2025-08-24 03:04:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1286", "530", "عملیات توسط WP Cron شروع شد", "2025-08-24 03:04:20", "2025-08-24 03:04:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1287", "703", "ایجاد فعالیت", "2025-08-24 03:04:20", "2025-08-24 03:04:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1288", "704", "ایجاد فعالیت", "2025-08-24 03:04:20", "2025-08-24 03:04:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1289", "530", "عملیات توسط WP Cron کامل شد", "2025-08-24 03:04:20", "2025-08-24 03:04:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1290", "705", "ایجاد فعالیت", "2025-08-24 03:04:20", "2025-08-24 03:04:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1291", "704", "عملیات توسط WP Cron شروع شد", "2025-08-24 04:37:04", "2025-08-24 04:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1292", "704", "عملیات توسط WP Cron کامل شد", "2025-08-24 04:37:04", "2025-08-24 04:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1293", "688", "عملیات توسط WP Cron شروع شد", "2025-08-24 04:37:04", "2025-08-24 04:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1294", "688", "عملیات توسط WP Cron کامل شد", "2025-08-24 04:37:04", "2025-08-24 04:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1295", "706", "ایجاد فعالیت", "2025-08-24 04:37:04", "2025-08-24 04:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1296", "689", "عملیات توسط WP Cron شروع شد", "2025-08-24 04:37:04", "2025-08-24 04:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1297", "689", "عملیات توسط WP Cron کامل شد", "2025-08-24 04:37:04", "2025-08-24 04:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1298", "707", "ایجاد فعالیت", "2025-08-24 04:37:04", "2025-08-24 04:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1299", "690", "عملیات توسط WP Cron شروع شد", "2025-08-24 04:37:04", "2025-08-24 04:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1300", "690", "عملیات توسط WP Cron کامل شد", "2025-08-24 04:37:04", "2025-08-24 04:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1301", "708", "ایجاد فعالیت", "2025-08-24 04:37:04", "2025-08-24 04:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1302", "703", "عملیات توسط WP Cron شروع شد", "2025-08-24 04:37:04", "2025-08-24 04:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1303", "709", "ایجاد فعالیت", "2025-08-24 04:37:05", "2025-08-24 04:37:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1304", "710", "ایجاد فعالیت", "2025-08-24 04:37:05", "2025-08-24 04:37:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1305", "703", "عملیات توسط WP Cron کامل شد", "2025-08-24 04:37:05", "2025-08-24 04:37:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1306", "709", "عملیات توسط WP Cron شروع شد", "2025-08-24 04:37:25", "2025-08-24 04:37:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1307", "709", "عملیات توسط WP Cron کامل شد", "2025-08-24 04:37:26", "2025-08-24 04:37:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1308", "710", "عملیات توسط WP Cron شروع شد", "2025-08-24 04:37:26", "2025-08-24 04:37:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1309", "710", "عملیات توسط WP Cron کامل شد", "2025-08-24 04:37:26", "2025-08-24 04:37:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1310", "698", "عملیات توسط WP Cron شروع شد", "2025-08-24 07:12:08", "2025-08-24 07:12:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1311", "698", "عملیات توسط WP Cron کامل شد", "2025-08-24 07:12:08", "2025-08-24 07:12:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1312", "711", "ایجاد فعالیت", "2025-08-24 07:12:08", "2025-08-24 07:12:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1313", "700", "عملیات توسط WP Cron شروع شد", "2025-08-24 15:18:14", "2025-08-24 15:18:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1314", "700", "عملیات توسط WP Cron کامل شد", "2025-08-24 15:18:14", "2025-08-24 15:18:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1315", "712", "ایجاد فعالیت", "2025-08-24 15:18:14", "2025-08-24 15:18:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1316", "711", "عملیات توسط WP Cron شروع شد", "2025-08-24 19:15:45", "2025-08-24 19:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1317", "711", "عملیات توسط WP Cron کامل شد", "2025-08-24 19:15:45", "2025-08-24 19:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1318", "713", "ایجاد فعالیت", "2025-08-24 19:15:45", "2025-08-24 19:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1319", "699", "عملیات توسط WP Cron شروع شد", "2025-08-25 03:14:22", "2025-08-25 03:14:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1320", "699", "عملیات توسط WP Cron کامل شد", "2025-08-25 03:14:22", "2025-08-25 03:14:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1321", "714", "ایجاد فعالیت", "2025-08-25 03:14:22", "2025-08-25 03:14:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1322", "701", "عملیات توسط WP Cron شروع شد", "2025-08-25 03:14:22", "2025-08-25 03:14:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1323", "701", "عملیات توسط WP Cron کامل شد", "2025-08-25 03:14:30", "2025-08-25 03:14:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1324", "715", "ایجاد فعالیت", "2025-08-25 03:14:30", "2025-08-25 03:14:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1325", "702", "عملیات توسط WP Cron شروع شد", "2025-08-25 03:14:30", "2025-08-25 03:14:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1326", "702", "عملیات توسط WP Cron کامل شد", "2025-08-25 03:14:31", "2025-08-25 03:14:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1327", "716", "ایجاد فعالیت", "2025-08-25 03:14:31", "2025-08-25 03:14:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1328", "705", "عملیات توسط WP Cron شروع شد", "2025-08-25 03:14:31", "2025-08-25 03:14:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1329", "717", "ایجاد فعالیت", "2025-08-25 03:14:31", "2025-08-25 03:14:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1330", "718", "ایجاد فعالیت", "2025-08-25 03:14:31", "2025-08-25 03:14:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1331", "705", "عملیات توسط WP Cron کامل شد", "2025-08-25 03:14:31", "2025-08-25 03:14:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1332", "719", "ایجاد فعالیت", "2025-08-25 03:14:31", "2025-08-25 03:14:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1333", "718", "عملیات توسط WP Cron شروع شد", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1334", "718", "عملیات توسط WP Cron کامل شد", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1335", "712", "عملیات توسط WP Cron شروع شد", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1336", "712", "عملیات توسط WP Cron کامل شد", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1337", "720", "ایجاد فعالیت", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1338", "717", "عملیات توسط WP Cron شروع شد", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1339", "717", "عملیات توسط WP Cron کامل شد", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1340", "706", "عملیات توسط WP Cron شروع شد", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1341", "706", "عملیات توسط WP Cron کامل شد", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1342", "721", "ایجاد فعالیت", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1343", "707", "عملیات توسط WP Cron شروع شد", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1344", "707", "عملیات توسط WP Cron کامل شد", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1345", "722", "ایجاد فعالیت", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1346", "708", "عملیات توسط WP Cron شروع شد", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1347", "708", "عملیات توسط WP Cron کامل شد", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1348", "723", "ایجاد فعالیت", "2025-08-25 06:53:29", "2025-08-25 06:53:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1349", "713", "عملیات توسط WP Cron شروع شد", "2025-08-25 08:21:26", "2025-08-25 08:21:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1350", "713", "عملیات توسط WP Cron کامل شد", "2025-08-25 08:21:26", "2025-08-25 08:21:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1351", "724", "ایجاد فعالیت", "2025-08-25 08:21:26", "2025-08-25 08:21:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1352", "720", "عملیات توسط WP Cron شروع شد", "2025-08-25 20:43:25", "2025-08-25 20:43:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1353", "720", "عملیات توسط WP Cron کامل شد", "2025-08-25 20:43:25", "2025-08-25 20:43:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1354", "725", "ایجاد فعالیت", "2025-08-25 20:43:25", "2025-08-25 20:43:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1355", "724", "عملیات توسط WP Cron شروع شد", "2025-08-25 20:43:25", "2025-08-25 20:43:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1356", "724", "عملیات توسط WP Cron کامل شد", "2025-08-25 20:43:25", "2025-08-25 20:43:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1357", "726", "ایجاد فعالیت", "2025-08-25 20:43:25", "2025-08-25 20:43:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1358", "714", "عملیات توسط WP Cron شروع شد", "2025-08-26 03:15:05", "2025-08-26 03:15:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1359", "714", "عملیات توسط WP Cron کامل شد", "2025-08-26 03:15:05", "2025-08-26 03:15:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1360", "727", "ایجاد فعالیت", "2025-08-26 03:15:05", "2025-08-26 03:15:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1361", "715", "عملیات توسط WP Cron شروع شد", "2025-08-26 03:15:05", "2025-08-26 03:15:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1362", "715", "عملیات توسط WP Cron کامل شد", "2025-08-26 03:15:13", "2025-08-26 03:15:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1363", "728", "ایجاد فعالیت", "2025-08-26 03:15:13", "2025-08-26 03:15:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1364", "716", "عملیات توسط WP Cron شروع شد", "2025-08-26 03:15:13", "2025-08-26 03:15:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1365", "716", "عملیات توسط WP Cron کامل شد", "2025-08-26 03:15:14", "2025-08-26 03:15:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1366", "729", "ایجاد فعالیت", "2025-08-26 03:15:14", "2025-08-26 03:15:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1367", "719", "عملیات توسط WP Cron شروع شد", "2025-08-26 03:15:14", "2025-08-26 03:15:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1368", "730", "ایجاد فعالیت", "2025-08-26 03:15:14", "2025-08-26 03:15:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1369", "731", "ایجاد فعالیت", "2025-08-26 03:15:14", "2025-08-26 03:15:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1370", "719", "عملیات توسط WP Cron کامل شد", "2025-08-26 03:15:14", "2025-08-26 03:15:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1371", "732", "ایجاد فعالیت", "2025-08-26 03:15:14", "2025-08-26 03:15:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1372", "731", "عملیات توسط WP Cron شروع شد", "2025-08-26 05:40:39", "2025-08-26 05:40:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1373", "731", "عملیات توسط WP Cron کامل شد", "2025-08-26 05:40:39", "2025-08-26 05:40:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1374", "730", "عملیات توسط WP Cron شروع شد", "2025-08-26 05:40:39", "2025-08-26 05:40:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1375", "730", "عملیات توسط WP Cron کامل شد", "2025-08-26 05:40:39", "2025-08-26 05:40:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1376", "721", "عملیات توسط WP Cron شروع شد", "2025-08-26 07:49:06", "2025-08-26 07:49:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1377", "721", "عملیات توسط WP Cron کامل شد", "2025-08-26 07:49:06", "2025-08-26 07:49:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1378", "733", "ایجاد فعالیت", "2025-08-26 07:49:06", "2025-08-26 07:49:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1379", "722", "عملیات توسط WP Cron شروع شد", "2025-08-26 07:49:06", "2025-08-26 07:49:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1380", "722", "عملیات توسط WP Cron کامل شد", "2025-08-26 07:49:06", "2025-08-26 07:49:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1381", "734", "ایجاد فعالیت", "2025-08-26 07:49:06", "2025-08-26 07:49:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1382", "723", "عملیات توسط WP Cron شروع شد", "2025-08-26 07:49:06", "2025-08-26 07:49:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1383", "723", "عملیات توسط WP Cron کامل شد", "2025-08-26 07:49:06", "2025-08-26 07:49:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1384", "735", "ایجاد فعالیت", "2025-08-26 07:49:06", "2025-08-26 07:49:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1385", "725", "عملیات توسط WP Cron شروع شد", "2025-08-26 09:08:55", "2025-08-26 09:08:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1386", "725", "عملیات توسط WP Cron کامل شد", "2025-08-26 09:08:55", "2025-08-26 09:08:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1387", "736", "ایجاد فعالیت", "2025-08-26 09:08:55", "2025-08-26 09:08:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1388", "726", "عملیات توسط WP Cron شروع شد", "2025-08-26 09:08:55", "2025-08-26 09:08:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1389", "726", "عملیات توسط WP Cron کامل شد", "2025-08-26 09:08:55", "2025-08-26 09:08:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1390", "737", "ایجاد فعالیت", "2025-08-26 09:08:55", "2025-08-26 09:08:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1391", "736", "عملیات توسط WP Cron شروع شد", "2025-08-26 21:23:10", "2025-08-26 21:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1392", "736", "عملیات توسط WP Cron کامل شد", "2025-08-26 21:23:10", "2025-08-26 21:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1393", "738", "ایجاد فعالیت", "2025-08-26 21:23:10", "2025-08-26 21:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1394", "737", "عملیات توسط WP Cron شروع شد", "2025-08-26 21:23:10", "2025-08-26 21:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1395", "737", "عملیات توسط WP Cron کامل شد", "2025-08-26 21:23:10", "2025-08-26 21:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1396", "739", "ایجاد فعالیت", "2025-08-26 21:23:10", "2025-08-26 21:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1397", "727", "عملیات توسط WP Cron شروع شد", "2025-08-27 05:54:09", "2025-08-27 05:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1398", "727", "عملیات توسط WP Cron کامل شد", "2025-08-27 05:54:09", "2025-08-27 05:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1399", "740", "ایجاد فعالیت", "2025-08-27 05:54:09", "2025-08-27 05:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1400", "728", "عملیات توسط WP Cron شروع شد", "2025-08-27 05:54:09", "2025-08-27 05:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1401", "728", "عملیات توسط WP Cron کامل شد", "2025-08-27 05:54:19", "2025-08-27 05:54:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1402", "741", "ایجاد فعالیت", "2025-08-27 05:54:19", "2025-08-27 05:54:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1403", "729", "عملیات توسط WP Cron شروع شد", "2025-08-27 05:54:19", "2025-08-27 05:54:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1404", "729", "عملیات توسط WP Cron کامل شد", "2025-08-27 05:54:20", "2025-08-27 05:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1405", "742", "ایجاد فعالیت", "2025-08-27 05:54:20", "2025-08-27 05:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1406", "732", "عملیات توسط WP Cron شروع شد", "2025-08-27 05:54:20", "2025-08-27 05:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1407", "743", "ایجاد فعالیت", "2025-08-27 05:54:20", "2025-08-27 05:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1408", "744", "ایجاد فعالیت", "2025-08-27 05:54:20", "2025-08-27 05:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1409", "732", "عملیات توسط WP Cron کامل شد", "2025-08-27 05:54:20", "2025-08-27 05:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1410", "745", "ایجاد فعالیت", "2025-08-27 05:54:20", "2025-08-27 05:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1411", "744", "عملیات توسط WP Cron شروع شد", "2025-08-27 06:35:25", "2025-08-27 06:35:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1412", "744", "عملیات توسط WP Cron کامل شد", "2025-08-27 06:35:25", "2025-08-27 06:35:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1413", "743", "عملیات توسط WP Cron شروع شد", "2025-08-27 07:08:32", "2025-08-27 07:08:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1414", "743", "عملیات توسط WP Cron کامل شد", "2025-08-27 07:08:32", "2025-08-27 07:08:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1415", "733", "عملیات توسط WP Cron شروع شد", "2025-08-27 07:57:03", "2025-08-27 07:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1416", "733", "عملیات توسط WP Cron کامل شد", "2025-08-27 07:57:03", "2025-08-27 07:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1417", "746", "ایجاد فعالیت", "2025-08-27 07:57:03", "2025-08-27 07:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1418", "734", "عملیات توسط WP Cron شروع شد", "2025-08-27 07:57:03", "2025-08-27 07:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1419", "734", "عملیات توسط WP Cron کامل شد", "2025-08-27 07:57:03", "2025-08-27 07:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1420", "747", "ایجاد فعالیت", "2025-08-27 07:57:03", "2025-08-27 07:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1421", "735", "عملیات توسط WP Cron شروع شد", "2025-08-27 07:57:03", "2025-08-27 07:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1422", "735", "عملیات توسط WP Cron کامل شد", "2025-08-27 07:57:03", "2025-08-27 07:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1423", "748", "ایجاد فعالیت", "2025-08-27 07:57:03", "2025-08-27 07:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1424", "738", "عملیات توسط WP Cron شروع شد", "2025-08-27 11:15:08", "2025-08-27 11:15:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1425", "738", "عملیات توسط WP Cron کامل شد", "2025-08-27 11:15:08", "2025-08-27 11:15:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1426", "749", "ایجاد فعالیت", "2025-08-27 11:15:08", "2025-08-27 11:15:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1427", "739", "عملیات توسط WP Cron شروع شد", "2025-08-27 11:15:08", "2025-08-27 11:15:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1428", "739", "عملیات توسط WP Cron کامل شد", "2025-08-27 11:15:08", "2025-08-27 11:15:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1429", "750", "ایجاد فعالیت", "2025-08-27 11:15:08", "2025-08-27 11:15:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1430", "749", "عملیات توسط WP Cron شروع شد", "2025-08-27 23:39:14", "2025-08-27 23:39:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1431", "749", "عملیات توسط WP Cron کامل شد", "2025-08-27 23:39:14", "2025-08-27 23:39:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1432", "751", "ایجاد فعالیت", "2025-08-27 23:39:14", "2025-08-27 23:39:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1433", "750", "عملیات توسط WP Cron شروع شد", "2025-08-27 23:39:14", "2025-08-27 23:39:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1434", "750", "عملیات توسط WP Cron کامل شد", "2025-08-27 23:39:14", "2025-08-27 23:39:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1435", "752", "ایجاد فعالیت", "2025-08-27 23:39:14", "2025-08-27 23:39:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1436", "740", "عملیات توسط WP Cron شروع شد", "2025-08-28 09:40:22", "2025-08-28 09:40:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1437", "740", "عملیات توسط WP Cron کامل شد", "2025-08-28 09:40:22", "2025-08-28 09:40:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1438", "753", "ایجاد فعالیت", "2025-08-28 09:40:22", "2025-08-28 09:40:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1439", "741", "عملیات توسط WP Cron شروع شد", "2025-08-28 09:40:22", "2025-08-28 09:40:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1440", "741", "عملیات توسط WP Cron کامل شد", "2025-08-28 09:40:30", "2025-08-28 09:40:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1441", "754", "ایجاد فعالیت", "2025-08-28 09:40:30", "2025-08-28 09:40:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1442", "742", "عملیات توسط WP Cron شروع شد", "2025-08-28 09:40:30", "2025-08-28 09:40:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1443", "742", "عملیات توسط WP Cron کامل شد", "2025-08-28 09:40:31", "2025-08-28 09:40:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1444", "755", "ایجاد فعالیت", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1445", "746", "عملیات توسط WP Cron شروع شد", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1446", "746", "عملیات توسط WP Cron کامل شد", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1447", "756", "ایجاد فعالیت", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1448", "747", "عملیات توسط WP Cron شروع شد", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1449", "747", "عملیات توسط WP Cron کامل شد", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1450", "757", "ایجاد فعالیت", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1451", "748", "عملیات توسط WP Cron شروع شد", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1452", "748", "عملیات توسط WP Cron کامل شد", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1453", "758", "ایجاد فعالیت", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1454", "745", "عملیات توسط WP Cron شروع شد", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1455", "759", "ایجاد فعالیت", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1456", "760", "ایجاد فعالیت", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1457", "745", "عملیات توسط WP Cron کامل شد", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1458", "761", "ایجاد فعالیت", "2025-08-28 09:40:32", "2025-08-28 09:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1459", "760", "عملیات توسط WP Cron شروع شد", "2025-08-28 12:19:32", "2025-08-28 12:19:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1460", "760", "عملیات توسط WP Cron کامل شد", "2025-08-28 12:19:33", "2025-08-28 12:19:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1461", "759", "عملیات توسط WP Cron شروع شد", "2025-08-28 12:19:33", "2025-08-28 12:19:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1462", "759", "عملیات توسط WP Cron کامل شد", "2025-08-28 12:19:33", "2025-08-28 12:19:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1463", "751", "عملیات توسط WP Cron شروع شد", "2025-08-28 12:19:33", "2025-08-28 12:19:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1464", "751", "عملیات توسط WP Cron کامل شد", "2025-08-28 12:19:33", "2025-08-28 12:19:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1465", "762", "ایجاد فعالیت", "2025-08-28 12:19:33", "2025-08-28 12:19:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1466", "752", "عملیات توسط WP Cron شروع شد", "2025-08-28 12:19:33", "2025-08-28 12:19:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1467", "752", "عملیات توسط WP Cron کامل شد", "2025-08-28 12:19:33", "2025-08-28 12:19:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1468", "763", "ایجاد فعالیت", "2025-08-28 12:19:33", "2025-08-28 12:19:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1469", "762", "عملیات توسط WP Cron شروع شد", "2025-08-29 03:31:08", "2025-08-29 03:31:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1470", "762", "عملیات توسط WP Cron کامل شد", "2025-08-29 03:31:08", "2025-08-29 03:31:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1471", "764", "ایجاد فعالیت", "2025-08-29 03:31:08", "2025-08-29 03:31:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1472", "763", "عملیات توسط WP Cron شروع شد", "2025-08-29 03:31:08", "2025-08-29 03:31:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1473", "763", "عملیات توسط WP Cron کامل شد", "2025-08-29 03:31:08", "2025-08-29 03:31:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1474", "765", "ایجاد فعالیت", "2025-08-29 03:31:08", "2025-08-29 03:31:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1475", "753", "عملیات توسط WP Cron شروع شد", "2025-08-29 10:43:37", "2025-08-29 10:43:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1476", "753", "عملیات توسط WP Cron کامل شد", "2025-08-29 10:43:37", "2025-08-29 10:43:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1477", "766", "ایجاد فعالیت", "2025-08-29 10:43:37", "2025-08-29 10:43:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1478", "754", "عملیات توسط WP Cron شروع شد", "2025-08-29 10:43:37", "2025-08-29 10:43:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1479", "754", "عملیات توسط WP Cron کامل شد", "2025-08-29 10:43:45", "2025-08-29 10:43:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1480", "767", "ایجاد فعالیت", "2025-08-29 10:43:45", "2025-08-29 10:43:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1481", "755", "عملیات توسط WP Cron شروع شد", "2025-08-29 10:43:45", "2025-08-29 10:43:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1482", "755", "عملیات توسط WP Cron کامل شد", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1483", "768", "ایجاد فعالیت", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1484", "756", "عملیات توسط WP Cron شروع شد", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1485", "756", "عملیات توسط WP Cron کامل شد", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1486", "769", "ایجاد فعالیت", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1487", "757", "عملیات توسط WP Cron شروع شد", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1488", "757", "عملیات توسط WP Cron کامل شد", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1489", "770", "ایجاد فعالیت", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1490", "758", "عملیات توسط WP Cron شروع شد", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1491", "758", "عملیات توسط WP Cron کامل شد", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1492", "771", "ایجاد فعالیت", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1493", "761", "عملیات توسط WP Cron شروع شد", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1494", "772", "ایجاد فعالیت", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1495", "773", "ایجاد فعالیت", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1496", "761", "عملیات توسط WP Cron کامل شد", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1497", "774", "ایجاد فعالیت", "2025-08-29 10:43:46", "2025-08-29 10:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1498", "773", "عملیات توسط WP Cron شروع شد", "2025-08-29 20:23:27", "2025-08-29 20:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1499", "773", "عملیات توسط WP Cron کامل شد", "2025-08-29 20:23:27", "2025-08-29 20:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1500", "772", "عملیات توسط WP Cron شروع شد", "2025-08-29 20:23:27", "2025-08-29 20:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1501", "772", "عملیات توسط WP Cron کامل شد", "2025-08-29 20:23:27", "2025-08-29 20:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1502", "764", "عملیات توسط WP Cron شروع شد", "2025-08-29 20:23:27", "2025-08-29 20:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1503", "764", "عملیات توسط WP Cron کامل شد", "2025-08-29 20:23:27", "2025-08-29 20:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1504", "775", "ایجاد فعالیت", "2025-08-29 20:23:27", "2025-08-29 20:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1505", "765", "عملیات توسط WP Cron شروع شد", "2025-08-29 20:23:27", "2025-08-29 20:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1506", "765", "عملیات توسط WP Cron کامل شد", "2025-08-29 20:23:27", "2025-08-29 20:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1507", "776", "ایجاد فعالیت", "2025-08-29 20:23:27", "2025-08-29 20:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1508", "777", "ایجاد فعالیت", "2025-08-29 20:23:37", "2025-08-29 20:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1509", "777", "عملیات توسط WP Cron شروع شد", "2025-08-30 05:46:39", "2025-08-30 05:46:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1510", "777", "عملیات توسط WP Cron کامل شد", "2025-08-30 05:46:39", "2025-08-30 05:46:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1511", "775", "عملیات توسط WP Cron شروع شد", "2025-08-30 11:03:22", "2025-08-30 11:03:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1512", "775", "عملیات توسط WP Cron کامل شد", "2025-08-30 11:03:22", "2025-08-30 11:03:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1513", "778", "ایجاد فعالیت", "2025-08-30 11:03:22", "2025-08-30 11:03:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1514", "776", "عملیات توسط WP Cron شروع شد", "2025-08-30 11:03:22", "2025-08-30 11:03:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1515", "776", "عملیات توسط WP Cron کامل شد", "2025-08-30 11:03:22", "2025-08-30 11:03:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1516", "779", "ایجاد فعالیت", "2025-08-30 11:03:22", "2025-08-30 11:03:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1517", "766", "عملیات توسط WP Cron شروع شد", "2025-08-30 11:03:22", "2025-08-30 11:03:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1518", "766", "عملیات توسط WP Cron کامل شد", "2025-08-30 11:03:22", "2025-08-30 11:03:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1519", "780", "ایجاد فعالیت", "2025-08-30 11:03:22", "2025-08-30 11:03:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1520", "767", "عملیات توسط WP Cron شروع شد", "2025-08-30 11:03:22", "2025-08-30 11:03:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1521", "767", "عملیات توسط WP Cron کامل شد", "2025-08-30 11:03:30", "2025-08-30 11:03:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1522", "781", "ایجاد فعالیت", "2025-08-30 11:03:30", "2025-08-30 11:03:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1523", "768", "عملیات توسط WP Cron شروع شد", "2025-08-30 11:03:30", "2025-08-30 11:03:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1524", "768", "عملیات توسط WP Cron کامل شد", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1525", "782", "ایجاد فعالیت", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1526", "769", "عملیات توسط WP Cron شروع شد", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1527", "769", "عملیات توسط WP Cron کامل شد", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1528", "783", "ایجاد فعالیت", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1529", "770", "عملیات توسط WP Cron شروع شد", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1530", "770", "عملیات توسط WP Cron کامل شد", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1531", "784", "ایجاد فعالیت", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1532", "771", "عملیات توسط WP Cron شروع شد", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1533", "771", "عملیات توسط WP Cron کامل شد", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1534", "785", "ایجاد فعالیت", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1535", "774", "عملیات توسط WP Cron شروع شد", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1536", "786", "ایجاد فعالیت", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1537", "787", "ایجاد فعالیت", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1538", "774", "عملیات توسط WP Cron کامل شد", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1539", "788", "ایجاد فعالیت", "2025-08-30 11:03:31", "2025-08-30 11:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1540", "787", "عملیات توسط WP Cron شروع شد", "2025-08-30 12:17:30", "2025-08-30 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1541", "787", "عملیات توسط WP Cron کامل شد", "2025-08-30 12:17:30", "2025-08-30 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1542", "786", "عملیات توسط WP Cron شروع شد", "2025-08-30 12:17:30", "2025-08-30 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1543", "786", "عملیات توسط WP Cron کامل شد", "2025-08-30 12:17:30", "2025-08-30 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1544", "778", "عملیات توسط WP Cron شروع شد", "2025-08-31 01:33:05", "2025-08-31 01:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1545", "778", "عملیات توسط WP Cron کامل شد", "2025-08-31 01:33:05", "2025-08-31 01:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1546", "789", "ایجاد فعالیت", "2025-08-31 01:33:05", "2025-08-31 01:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1547", "779", "عملیات توسط WP Cron شروع شد", "2025-08-31 01:33:05", "2025-08-31 01:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1548", "779", "عملیات توسط WP Cron کامل شد", "2025-08-31 01:33:05", "2025-08-31 01:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1549", "790", "ایجاد فعالیت", "2025-08-31 01:33:05", "2025-08-31 01:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1550", "791", "ایجاد فعالیت", "2025-08-31 04:14:10", "2025-08-31 04:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1551", "792", "ایجاد فعالیت", "2025-08-31 04:14:32", "2025-08-31 04:14:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1552", "791", "عملیات توسط WP Cron شروع شد", "2025-08-31 04:14:35", "2025-08-31 04:14:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1553", "791", "عملیات توسط WP Cron کامل شد", "2025-08-31 04:14:35", "2025-08-31 04:14:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1554", "792", "عملیات توسط WP Cron شروع شد", "2025-08-31 04:14:35", "2025-08-31 04:14:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1555", "792", "عملیات توسط WP Cron کامل شد", "2025-08-31 04:14:36", "2025-08-31 04:14:36");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "208", "ووکامرس", "", "", "", "2020-01-28 15:32:37", "2020-01-28 12:02:37", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "209", "ووکامرس", "", "", "", "2020-01-28 15:33:12", "2020-01-28 12:03:12", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "210", "ووکامرس", "", "", "", "2020-01-28 15:33:39", "2020-01-28 12:03:39", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "211", "ووکامرس", "", "", "", "2020-01-28 15:34:20", "2020-01-28 12:04:20", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "212", "ووکامرس", "", "", "", "2020-01-28 15:34:57", "2020-01-28 12:04:57", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "834", "ووکامرس", "", "", "", "2025-08-23 04:28:41", "2025-08-23 04:28:41", "کاربر به درگاه پرداخت هدایت شد. شناسه تراکنش: A000000000000000000000000000x58xv1o6", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "841", "ووکامرس", "", "", "", "2025-08-23 07:58:30", "2025-08-23 07:58:30", "کاربر به درگاه پرداخت هدایت شد. شناسه تراکنش: A000000000000000000000000000z75nvrpv", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "834", "ووکامرس", "", "", "", "2025-08-24 04:37:05", "2025-08-24 04:37:05", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت. وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "841", "ووکامرس", "", "", "", "2025-08-24 04:37:05", "2025-08-24 04:37:05", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت. وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: wp_digits_login_logs */
INSERT INTO `wp_digits_login_logs` VALUES("1", "1", "1", "default", "unknown", "login", "", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:142.0) Gecko/20100101 Firefox/142.0", "0", "2025-08-23 10:04:38", "185.111.82.58");
INSERT INTO `wp_digits_login_logs` VALUES("2", "1", "1", "default", "unknown", "login", "", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36", "0", "2025-08-24 08:07:08", "46.36.100.128");
INSERT INTO `wp_digits_login_logs` VALUES("3", "1", "1", "default", "unknown", "login", "", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36", "0", "2025-08-29 07:19:29", "188.213.192.129");
INSERT INTO `wp_digits_login_logs` VALUES("4", "1", "1", "default", "unknown", "login", "", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36", "0", "2025-08-30 10:16:47", "93.119.212.213");
INSERT INTO `wp_digits_login_logs` VALUES("5", "1", "1", "default", "unknown", "login", "", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36", "0", "2025-08-30 21:09:58", "188.121.103.128");

/* INSERT TABLE DATA: wp_digits_user_session */
INSERT INTO `wp_digits_user_session` VALUES("132", "digits_country_info_157.55.39.13_digits_cache", "cf0edd055ba31c5dc09ed095f320cadc9b3048771e3e05f4aefd5ef588d13ef247914e86d08532ce3571b70a04c22471b5672e14d38f4bc034cbb37a70033df2", "0", "digits_country_info_157.55.39.13_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-31 17:21:21", "2025-08-30 17:21:21");
INSERT INTO `wp_digits_user_session` VALUES("131", "digits_country_info_207.46.13.154_digits_cache", "c843109d0801e3489c81833a815328271af137932d274524b85ce0b9ba3d831a88cdd8ea28090432af49a4860240b20ad30776b90c87c9b8fdf0c3d416da35f3", "0", "digits_country_info_207.46.13.154_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-31 15:04:01", "2025-08-30 15:04:01");
INSERT INTO `wp_digits_user_session` VALUES("130", "digits_country_info_52.167.144.58_digits_cache", "35d291e4d15d36d0b782cf0bd8c33d218f6166a53514c342d2b5baa7c09705784625d07b4636a7e34b3607ccd0e4a81754be3f5824a248f32747a7114255b610", "0", "digits_country_info_52.167.144.58_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-31 15:03:58", "2025-08-30 15:03:58");
INSERT INTO `wp_digits_user_session` VALUES("129", "digits_country_info_207.46.13.17_digits_cache", "039ba148ef2bef97dd97bb6ab2bdeb4665a1f5b8175cbf1da7188fa5bcfb49505e8880e2a68dbc8f6a3b9ed5e524bb37b69eeacf99557dc00b5ca205d0040748", "0", "digits_country_info_207.46.13.17_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-31 12:38:07", "2025-08-30 12:38:07");
INSERT INTO `wp_digits_user_session` VALUES("128", "digits_country_info_66.249.79.166_digits_cache", "b98d2c4883d6276c533d98b4f1f6ea4e2c970f1daed244b65904b9aacf86b6de1f1217cbd17dd88fa9b16677c766faa6b3aed7034e4f3cbd7c878547a4284eb4", "0", "digits_country_info_66.249.79.166_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-31 12:17:27", "2025-08-30 12:17:27");
INSERT INTO `wp_digits_user_session` VALUES("127", "digits_country_info_52.167.144.140_digits_cache", "713f9c8491c5f01f088c5a8643691240b8c77b41a3dd9e01944cebf18e69fa76fce0e2649d8afecd9b74f07fcc865759fa9e0c57544b60ce80f64117b2bd582a", "0", "digits_country_info_52.167.144.140_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-31 11:59:01", "2025-08-30 11:59:01");
INSERT INTO `wp_digits_user_session` VALUES("126", "digits_country_info_45.92.92.159_digits_cache", "bd3ac4c762031a8d80acbcff5aab5ea0131ba91448cb991a9b6a414b4e013629c20c60ef60cd420d460e6637ea4e510b989e8f17ddafee4ef930beedfa2d3a5a", "0", "digits_country_info_45.92.92.159_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-31 11:03:22", "2025-08-30 11:03:22");
INSERT INTO `wp_digits_user_session` VALUES("117", "digits_country_info_66.249.70.65_digits_cache", "c08e954b20577ec4dbf08dadde32b6577d8519717b92326c2312fde12f2c151251090c2012f0a145562904cd779d50909c84a1c3057105f6aff3aa9390b84e17", "0", "digits_country_info_66.249.70.65_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-30 10:43:39", "2025-08-29 10:43:39");
INSERT INTO `wp_digits_user_session` VALUES("116", "digits_country_info_45.92.92.159_digits_cache", "dbec00839028bcac409ff1d9aa746c71b27ea9ae21b60c193aa9fe0899c0a70fef21de50e4ac8864416edadc5114bf87ede7cddca74ea7a4fed0eb4e44328f98", "0", "digits_country_info_45.92.92.159_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-30 10:43:37", "2025-08-29 10:43:37");
INSERT INTO `wp_digits_user_session` VALUES("115", "digits_country_info_66.249.70.67_digits_cache", "53df2ca24024aa0b4151b6714c1ba4b7534ea545791d0b983f694ba14946dfe63e204100d35d8bf57eb99bd0f900411b525247525a6a86b60b107662d49c916b", "0", "digits_country_info_66.249.70.67_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-30 10:43:35", "2025-08-29 10:43:35");
INSERT INTO `wp_digits_user_session` VALUES("114", "digits_country_info_5.255.231.150_digits_cache", "8565639fe84f129a2c578203693f9ef79a61824936e1ecb3f11ec7a6e82b884a378788ffc0ac40f68913fe4615ddfb9bb0c79545b183ad76f717b4e8975a3902", "0", "digits_country_info_5.255.231.150_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-30 08:01:47", "2025-08-29 08:01:47");
INSERT INTO `wp_digits_user_session` VALUES("113", "digits_country_info_5.255.231.76_digits_cache", "91a33182b1270c75092ca5ad2bdf6793125e00ca45f07fc9ba94f77016c858dad8edb80f35fd14ebf062596f9e15a482b11da1758b50a75c49f8b5cbfe861198", "0", "digits_country_info_5.255.231.76_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-30 08:01:44", "2025-08-29 08:01:44");
INSERT INTO `wp_digits_user_session` VALUES("112", "digits_country_info_87.250.224.120_digits_cache", "45d77204790eac724990d7213f3cb0dd8ab15a758a52128852b86fd61719778ca797da886b7113a0ddeb46c0f69f9571d82928683c9c74fee7d803621fb89d89", "0", "digits_country_info_87.250.224.120_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-30 06:27:40", "2025-08-29 06:27:40");
INSERT INTO `wp_digits_user_session` VALUES("123", "digits_country_info_93.119.212.213_digits_cache", "f31c2321175053bce461aaac0a8eebf5055dbf55cecb45662ec3939bb5ad21079ee7dc4e9bfedf46b29b4884ae577fcc361156c40d8b8c94e393850c170b27c5", "0", "digits_country_info_93.119.212.213_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-31 06:46:47", "2025-08-30 06:46:47");
INSERT INTO `wp_digits_user_session` VALUES("124", "digits_country_info_188.121.103.128_digits_cache", "qBm80PyMTCy5KQMWEVsxvy7NzF4jbSNNhos2xNEdUDI", "1", "digits_country_info_188.121.103.128_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-31 07:20:20", "2025-08-30 07:20:20");
INSERT INTO `wp_digits_user_session` VALUES("125", "digits_country_info_95.108.213.216_digits_cache", "ee09a6794cf8522888723779d263618308e7a25976c4fae85b7a7bfd58b50144704a0ef24747296cc1d54e59478325f18ca83a287f36f7d09150c6010e449e0d", "0", "digits_country_info_95.108.213.216_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-31 11:03:19", "2025-08-30 11:03:19");
INSERT INTO `wp_digits_user_session` VALUES("111", "digits_country_info_95.108.213.234_digits_cache", "4285a993ba40db6c368c19b52b72f7580383b6f03abb273a684d5a9926daca8effebc6a179c963f6167e57fe451e76e2a2c819f46d8ab4c1cfdf434f09f62938", "0", "digits_country_info_95.108.213.234_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-30 06:27:37", "2025-08-29 06:27:37");
INSERT INTO `wp_digits_user_session` VALUES("110", "digits_country_info_2a06:98c0:3600::103, 172.71.146.81_digits_cache", "4036590cb46e48ca7043dfd259f9d883ddf296f09538d49d71ad1fbcb61fc5eb7a77f810b62a24c39584ee2f3d9b3409125ac1b0c0e4d25b9dcba4ffd40f0fe0", "0", "digits_country_info_2a06:98c0:3600::103, 172.71.146.81_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-30 04:53:02", "2025-08-29 04:53:02");
INSERT INTO `wp_digits_user_session` VALUES("109", "digits_country_info_2a06:98c0:3600::103, 172.71.26.131_digits_cache", "cfd53c33f79ba5550a488fd2bc19130e05b2243b3a631c0b49b8032eda1f68b90ec47652ad952457532e41619b383501ee56f359d6ed4d99ea8e1c19d79c7608", "0", "digits_country_info_2a06:98c0:3600::103, 172.71.26.131_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-30 04:52:36", "2025-08-29 04:52:36");
INSERT INTO `wp_digits_user_session` VALUES("108", "digits_country_info_188.213.192.129_digits_cache", "4c7d786d56a3b15f2f13e8d01c8783ee3375895dd38b89fa3769826c53d6abac9988ad5d0c7d08d4258afbb41ae328902cbdf28f9734d8f271bce3b9280c220a", "0", "digits_country_info_188.213.192.129_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-30 03:49:28", "2025-08-29 03:49:28");
INSERT INTO `wp_digits_user_session` VALUES("120", "digits_country_info_40.77.167.52_digits_cache", "c44f4e3b786a2ff10c24a67484e5900b0b9c016d64fe65d59d306aeec14e10da5dae021451ef188b135c92b8975322c2df139b6eb25aa7ed7ea92254382639ab", "0", "digits_country_info_40.77.167.52_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-31 06:29:57", "2025-08-30 06:29:57");
INSERT INTO `wp_digits_user_session` VALUES("137", "digits_country_info_178.131.160.197_digits_cache", "ysx6oJXOJH6RrG8X2GSYbHkzMh9go66S3YAjCaWs2Wl", "1", "digits_country_info_178.131.160.197_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-09-01 04:07:00", "2025-08-31 04:07:00");
INSERT INTO `wp_digits_user_session` VALUES("136", "digits_country_info_104.210.140.134_digits_cache", "c572281e649d0b6ef478b9180a383ee4c8e1171f92cb81de7a03f4f5c5abfaad9bed3fd490f04180fc7dbd4c1c06ec394545d32ec863bbe91319c02d98d08442", "0", "digits_country_info_104.210.140.134_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-09-01 02:13:06", "2025-08-31 02:13:06");
INSERT INTO `wp_digits_user_session` VALUES("135", "digits_country_info_54.217.83.13_digits_cache", "70e93f249ee974dee455917212d43213bfc07c6d62f3bcba586068591899d30e19c3b371db11b6baac1e3de295eda3a74a5bfcba4848a13248a650fe39a37d0a", "0", "digits_country_info_54.217.83.13_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-09-01 01:33:01", "2025-08-31 01:33:01");
INSERT INTO `wp_digits_user_session` VALUES("105", "digits_country_info_44.200.225.96_digits_cache", "24070b32460842678efd6a16dfbe1c3629939b3d67b08d4ddf27240b15221f389d1aa6238738dab971c676efb1d061bbbe3e918eca336281c8e49cd0fdb7419c", "0", "digits_country_info_44.200.225.96_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-30 03:31:06", "2025-08-29 03:31:06");
INSERT INTO `wp_digits_user_session` VALUES("118", "digits_country_info_185.177.72.45_digits_cache", "1fcaa96a92a61f94f851cf22ca66bf9a1cde3f38cc25a6e6252a244b04f7b342ca37f7e38fbd8a2158f7cb35e753b34f7f7a979b8aa2cbcda70ea0ce03a20281", "0", "digits_country_info_185.177.72.45_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-30 20:23:19", "2025-08-29 20:23:19");
INSERT INTO `wp_digits_user_session` VALUES("119", "digits_country_info_5.238.248.91_digits_cache", "2cd310ba1defcff24a0d688f9148624b25e4e0c89b088f297cdeb5e4120fca6c0452ad30d7b8b7e21eca2ae76dbb1ad499d4aa0422659f0ef12e3edc30116749", "0", "digits_country_info_5.238.248.91_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-31 05:46:36", "2025-08-30 05:46:36");
INSERT INTO `wp_digits_user_session` VALUES("133", "digits_country_info_178.131.150.195_digits_cache", "ysx6oJXOJH6RrG8X2GSYbHkzMh9go66S3YAjCaWs2Wl", "1", "digits_country_info_178.131.150.195_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-31 17:40:09", "2025-08-30 17:40:09");
INSERT INTO `wp_digits_user_session` VALUES("134", "digits_country_info_157.55.39.49_digits_cache", "95db34ec50765f1380ed9ee5536f6892d0ec7d2653255d5539e75e51a8cf612edf49902b1e9ab8de720e11e8b55a848739619b99ac3c8f23d3d11a4e180fbe15", "0", "digits_country_info_157.55.39.49_digits_cache", "{\"country_code\":\"98\",\"country\":\"Iran\"}", "2025-08-31 21:49:11", "2025-08-30 21:49:11");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("24", "lanaria", "0c4e14ae5a1b01d06163_20250831041910", "21", "2025-08-31 04:19:19", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-08-31 04:19:10\";s:7:\"Version\";s:8:\"1.5.13.1\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:7:\"10.6.22\";s:10:\"VersionPHP\";s:6:\"8.1.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:24;s:4:\"Name\";s:7:\"lanaria\";s:4:\"Hash\";s:35:\"0c4e14ae5a1b01d06163_20250831041910\";s:8:\"NameHash\";s:43:\"lanaria_0c4e14ae5a1b01d06163_20250831041910\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:53:\"lanaria_0c4e14ae5a1b01d06163_20250831041910_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.8\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:55:\"lanaria_0c4e14ae5a1b01d06163_20250831041910_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:27:\"/home/maikutai/a.maikuta.ir\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3904;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:26347;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-08-31 04:19:10\";s:7:\"Version\";s:8:\"1.5.13.1\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:7:\"10.6.22\";s:10:\"VersionPHP\";s:6:\"8.1.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:7:\"lanaria\";s:4:\"Hash\";s:35:\"0c4e14ae5a1b01d06163_20250831041910\";s:8:\"NameHash\";s:43:\"lanaria_0c4e14ae5a1b01d06163_20250831041910\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:61:\"lanaria_0c4e14ae5a1b01d06163_20250831041910_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:41:\"/home/maikutai/a.maikuta.ir/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:56:\"lanaria_0c4e14ae5a1b01d06163_20250831041910_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:116:\"/home/maikutai/a.maikuta.ir/wp-content/backups-dup-lite/tmp/lanaria_0c4e14ae5a1b01d06163_20250831041910_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:36:\"/home/maikutai/a.maikuta.ir/wp-admin\";i:1;s:39:\"/home/maikutai/a.maikuta.ir/wp-includes\";i:2;s:48:\"/home/maikutai/a.maikuta.ir/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:27:\"/home/maikutai/a.maikuta.ir\";i:1;s:27:\"/home/maikutai/a.maikuta.ir\";i:2;s:38:\"/home/maikutai/a.maikuta.ir/wp-content\";i:3;s:46:\"/home/maikutai/a.maikuta.ir/wp-content/uploads\";i:4;s:46:\"/home/maikutai/a.maikuta.ir/wp-content/plugins\";i:5;s:49:\"/home/maikutai/a.maikuta.ir/wp-content/mu-plugins\";i:6;s:45:\"/home/maikutai/a.maikuta.ir/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:59:\"/home/maikutai/a.maikuta.ir/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://a.maikuta.ir", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://a.maikuta.ir", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "لاناریا", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "mj.masoud@yahoo.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:323:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:23:\"^/([^/]*)/page/([^/]*)?\";s:61:\"index.php?page_id=0&wishlist_id=$matches[1]&paged=$matches[2]\";s:15:\"^/page/([^/]*)?\";s:37:\"index.php?page_id=0&paged=$matches[1]\";s:11:\"^/([^/]*)/?\";s:43:\"index.php?page_id=0&wishlist_id=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:43:\"woodmart_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_layout/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_layout=$matches[1]&embed=true\";s:36:\"woodmart_layout/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_layout=$matches[1]&tb=1\";s:44:\"woodmart_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_layout/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_layout=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_layout/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_layout=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_layout/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_layout/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_layout=$matches[1]&page=$matches[2]\";s:32:\"woodmart_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_woo_lv/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_woo_lv=$matches[1]&embed=true\";s:36:\"woodmart_woo_lv/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_woo_lv=$matches[1]&tb=1\";s:44:\"woodmart_woo_lv/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_woo_lv/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_woo_lv/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_woo_lv=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_woo_lv/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_woo_lv=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_woo_lv/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_woo_lv/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_woo_lv=$matches[1]&page=$matches[2]\";s:32:\"woodmart_woo_lv/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_woo_lv/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_woo_lv/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_woo_lv/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"woodmart_woo_fbt/([^/]+)/embed/?$\";s:49:\"index.php?woodmart_woo_fbt=$matches[1]&embed=true\";s:37:\"woodmart_woo_fbt/([^/]+)/trackback/?$\";s:43:\"index.php?woodmart_woo_fbt=$matches[1]&tb=1\";s:45:\"woodmart_woo_fbt/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&paged=$matches[2]\";s:52:\"woodmart_woo_fbt/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&cpage=$matches[2]\";s:53:\"woodmart_woo_fbt/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?woodmart_woo_fbt=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"woodmart_woo_fbt/([^/]+)/wc-api(/(.*))?/?$\";s:57:\"index.php?woodmart_woo_fbt=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:48:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"woodmart_woo_fbt/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?woodmart_woo_fbt=$matches[1]&page=$matches[2]\";s:33:\"woodmart_woo_fbt/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"woodmart_woo_fbt/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"woodmart_woo_fbt/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"woodmart_woo_fbt/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"cms_block_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:49:\"cms_block_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:30:\"cms_block_cat/([^/]+)/embed/?$\";s:46:\"index.php?cms_block_cat=$matches[1]&embed=true\";s:42:\"cms_block_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?cms_block_cat=$matches[1]&paged=$matches[2]\";s:24:\"cms_block_cat/([^/]+)/?$\";s:35:\"index.php?cms_block_cat=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:46:\"portfolio/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"portfolio/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"project-cat/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:45:\"project-cat/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:26:\"project-cat/(.+?)/embed/?$\";s:44:\"index.php?project-cat=$matches[1]&embed=true\";s:38:\"project-cat/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project-cat=$matches[1]&paged=$matches[2]\";s:20:\"project-cat/(.+?)/?$\";s:33:\"index.php?project-cat=$matches[1]\";s:47:\"برند/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:42:\"برند/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:23:\"برند/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:35:\"برند/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:17:\"برند/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:47:\"mc4wp-form/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?mc4wp-form=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"mc4wp-form/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=13&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:27:\"(.?.+?)/waitlist(/(.*))?/?$\";s:51:\"index.php?pagename=$matches[1]&waitlist=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:11:{i:0;s:36:\"contact-form-7/wp-contact-form-7.php\";i:1;s:17:\"digits1/digit.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:23:\"elementor/elementor.php\";i:4;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:5;s:23:\"revslider/revslider.php\";i:6;s:27:\"woocommerce/woocommerce.php\";i:7;s:31:\"woodmart-core/woodmart-core.php\";i:8;s:33:\"woodmart-farsi/woodmart-farsi.php\";i:9;s:29:\"wp-parsidate/wp-parsidate.php\";i:10;s:46:\"zarinpal-woocommerce-payment-gateway/index.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "https://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:3:{i:0;s:88:\"/home/maikutai/a.maikuta.ir/wp-content/themes/woodmart/inc/admin/dashboard/dashboard.php\";i:2;s:64:\"/home/maikutai/a.maikuta.ir/wp-content/themes/woodmart/style.css\";i:3;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "woodmart", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "woodmart", "yes");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "60421", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "blank", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:6:{i:3;a:4:{s:5:\"title\";s:21:\"بهداشت شخصی\";s:4:\"text\";s:207:\"<ul>\r\n 	<li>سلامت عمومی</li>\r\n 	<li>بهداشت سالمندان</li>\r\n 	<li>بهداشت جنسی</li>\r\n 	<li>بهداشت بانوان</li>\r\n 	<li>بهداشت دهان و دندان</li>\r\n</ul>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:4;a:4:{s:5:\"title\";s:14:\"مرادانه\";s:4:\"text\";s:190:\"<ul>\r\n 	<li>محصولات بدن آقایان</li>\r\n 	<li>اصلاح آقایان</li>\r\n 	<li>محصولات موی آقایان</li>\r\n 	<li>محصولات پوست آقایان</li>\r\n</ul>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:5;a:4:{s:5:\"title\";s:28:\"لوازم شخصی برقی\";s:4:\"text\";s:180:\"<ul>\r\n 	<li>حالت دهنده های برقی</li>\r\n 	<li>اصلاح صورت و بدن</li>\r\n 	<li>سایر لوازم شخصی برقی</li>\r\n 	<li>خشک کن ها</li>\r\n</ul>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:6;a:4:{s:5:\"title\";s:10:\"سالنی\";s:4:\"text\";s:242:\"<ul>\r\n 	<li>تجهیزات آرایشگاهی</li>\r\n 	<li>کتاب و جزوه</li>\r\n 	<li>اپیلاسیون</li>\r\n 	<li>کاشت و طراحی ناخن</li>\r\n 	<li>اکستنشن</li>\r\n 	<li>ابزار آرایش و پیرایش</li>\r\n</ul>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:8;a:4:{s:5:\"title\";s:41:\"اعتماد شما افتخار ماست\";s:4:\"text\";s:294:\"<img class=\"alignnone size-full wp-image-170\" src=\"https://a.maikuta.ir/wp-content/uploads/2020/01/enamad.png\" alt=\"\" width=\"150\" height=\"150\" /> <img class=\"alignnone size-full wp-image-171\" src=\"https://a.maikuta.ir/wp-content/uploads/2020/01/samandehi.png\" alt=\"\" width=\"150\" height=\"150\" />\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "Atlantic/Azores", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "13", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "740", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("93", "admin_email_lifespan", "1756698574", "yes");
INSERT INTO `wp_options` VALUES("94", "initial_db_version", "45805", "yes");
INSERT INTO `wp_options` VALUES("95", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:128:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:36:\"vc_access_rules_post_types/cms_block\";b:1;s:36:\"vc_access_rules_post_types/portfolio\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:24:\"vc_access_rules_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:43:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:19:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:14:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:102:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:16:\"create_customers\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("96", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("97", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "sidebars_widgets", "a:16:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:12:\"categories-2\";}s:22:\"portfolio-widgets-area\";a:0:{}s:12:\"sidebar-shop\";a:5:{i:0;s:24:\"wd-widget-stock-status-2\";i:1;s:26:\"woocommerce_price_filter-3\";i:2;s:34:\"woodmart-woocommerce-layered-nav-3\";i:3;s:34:\"woodmart-woocommerce-layered-nav-2\";i:4;s:34:\"woodmart-woocommerce-layered-nav-5\";}s:12:\"filters-area\";a:0:{}s:22:\"sidebar-product-single\";a:1:{i:0;s:21:\"woodmart-html-block-2\";}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:1:{i:0;s:6:\"text-3\";}s:8:\"footer-3\";a:1:{i:0;s:6:\"text-4\";}s:8:\"footer-4\";a:1:{i:0;s:6:\"text-5\";}s:8:\"footer-5\";a:1:{i:0;s:6:\"text-6\";}s:8:\"footer-6\";a:1:{i:0;s:6:\"text-8\";}s:13:\"array_version\";i:3;}", "on");
INSERT INTO `wp_options` VALUES("104", "cron", "a:25:{i:1756613960;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1756614747;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1756615507;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1756616588;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1756617020;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1756617224;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1756617329;a:1:{s:40:\"woodmart_wishlist_send_promotional_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1756620666;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"944837faafe5a441927da90550a740c0\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:867;}}}}i:1756621000;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"89e96ad8fd3ab276c95851431996ec5f\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:868;}}}}i:1756627989;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1756632141;a:1:{s:29:\"puc_cron_check_updates-digits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1756649845;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756651506;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756651507;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1756651580;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756651582;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756656630;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756663388;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756675342;a:1:{s:15:\"dig_pcd_act_chk\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756675352;a:1:{s:24:\"digits_session_cron_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756735200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1756758926;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1756915557;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757099469;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("105", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("117", "theme_mods_twentytwenty", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1580136427;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "off");
INSERT INTO `wp_options` VALUES("144", "current_theme", "Woodmart", "yes");
INSERT INTO `wp_options` VALUES("145", "theme_mods_woodmart", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:11:\"mobile-menu\";i:16;s:9:\"main-menu\";i:16;}s:18:\"custom_css_post_id\";i:564;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1637177432;s:4:\"data\";a:14:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:12:\"sidebar-shop\";a:5:{i:0;s:24:\"wd-widget-stock-status-2\";i:1;s:26:\"woocommerce_price_filter-3\";i:2;s:32:\"woocommerce_product_categories-2\";i:3;s:34:\"woodmart-woocommerce-layered-nav-3\";i:4;s:34:\"woodmart-woocommerce-layered-nav-2\";}s:12:\"filters-area\";a:0:{}s:22:\"sidebar-product-single\";a:1:{i:0;s:21:\"woodmart-html-block-2\";}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:1:{i:0;s:6:\"text-3\";}s:8:\"footer-3\";a:1:{i:0;s:6:\"text-4\";}s:8:\"footer-4\";a:1:{i:0;s:6:\"text-5\";}s:8:\"footer-5\";a:1:{i:0;s:6:\"text-6\";}s:8:\"footer-6\";a:1:{i:0;s:6:\"text-8\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("146", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("147", "woodmart_token", "1", "yes");
INSERT INTO `wp_options` VALUES("148", "woodmart_is_activated", "1", "yes");
INSERT INTO `wp_options` VALUES("152", "woocommerce_store_address", "تهران", "yes");
INSERT INTO `wp_options` VALUES("153", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_options` VALUES("154", "woocommerce_store_city", "تهران", "yes");
INSERT INTO `wp_options` VALUES("155", "woocommerce_default_country", "IR:THR", "yes");
INSERT INTO `wp_options` VALUES("156", "woocommerce_store_postcode", "12345678", "yes");
INSERT INTO `wp_options` VALUES("157", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("158", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("159", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("160", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("161", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("162", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_options` VALUES("163", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("164", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("165", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("166", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("167", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `wp_options` VALUES("168", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("169", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wp_options` VALUES("170", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `wp_options` VALUES("171", "woocommerce_shop_page_id", "6", "yes");
INSERT INTO `wp_options` VALUES("172", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("173", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("174", "woocommerce_placeholder_image", "5", "yes");
INSERT INTO `wp_options` VALUES("175", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("176", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("177", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("178", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("179", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("180", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("181", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("182", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("183", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("184", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("185", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("186", "woocommerce_stock_email_recipient", "mj.masoud@yahoo.com", "no");
INSERT INTO `wp_options` VALUES("187", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("188", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("189", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("190", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("191", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("192", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("193", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("194", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("195", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("196", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("197", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("198", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_options` VALUES("199", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("200", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_options` VALUES("201", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("202", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("203", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("204", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_options` VALUES("205", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("206", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_options` VALUES("207", "woocommerce_enable_guest_checkout", "no", "no");
INSERT INTO `wp_options` VALUES("208", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `wp_options` VALUES("209", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("210", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `wp_options` VALUES("211", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("212", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `wp_options` VALUES("213", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("214", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("215", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("216", "woocommerce_registration_privacy_policy_text", "", "yes");
INSERT INTO `wp_options` VALUES("217", "woocommerce_checkout_privacy_policy_text", "", "yes");
INSERT INTO `wp_options` VALUES("218", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("219", "woocommerce_trash_pending_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("220", "woocommerce_trash_failed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("221", "woocommerce_trash_cancelled_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("222", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("223", "woocommerce_email_from_name", "Pinado", "no");
INSERT INTO `wp_options` VALUES("224", "woocommerce_email_from_address", "mj.masoud@yahoo.com", "no");
INSERT INTO `wp_options` VALUES("225", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("226", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_options` VALUES("227", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `wp_options` VALUES("228", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("229", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("230", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("231", "woocommerce_cart_page_id", "7", "no");
INSERT INTO `wp_options` VALUES("232", "woocommerce_checkout_page_id", "8", "no");
INSERT INTO `wp_options` VALUES("233", "woocommerce_myaccount_page_id", "9", "no");
INSERT INTO `wp_options` VALUES("234", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("235", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("236", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("237", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("238", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("239", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("240", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("241", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("242", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("243", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("244", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("245", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("246", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("247", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("248", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("249", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("250", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("251", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_options` VALUES("252", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `wp_options` VALUES("253", "woocommerce_single_image_width", "800", "yes");
INSERT INTO `wp_options` VALUES("254", "woocommerce_thumbnail_image_width", "400", "yes");
INSERT INTO `wp_options` VALUES("255", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("256", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_options` VALUES("257", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("258", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("259", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("262", "default_product_cat", "15", "yes");
INSERT INTO `wp_options` VALUES("267", "revslider_servers", "a:3:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-b.tools\";i:2;s:22:\"themepunch-ext-c.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("268", "revslider_server_refresh", "1755893050", "yes");
INSERT INTO `wp_options` VALUES("269", "revslider-update-check-short", "1756464225", "yes");
INSERT INTO `wp_options` VALUES("270", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("271", "revslider-update-hash", "0703b6475563f66fedd7c5640d301243", "yes");
INSERT INTO `wp_options` VALUES("272", "revslider-latest-version", "6.7.37", "yes");
INSERT INTO `wp_options` VALUES("273", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wp_options` VALUES("274", "revslider-notices", "a:5:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:952:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-a.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-a.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:956:\"<div style=\"display: block; background: #1c0950;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-a.tools//banners/blackfriday2024-admin2.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-a.tools//banners/blackfriday2024-admin2.jpg\"></div><map name=\"srbannermap\"><area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks24\" coords=\"569,135,890,196\" shape=\"rect\"><area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks24\" coords=\"570,200,889,260\" shape=\"rect\"></map>\";s:4:\"code\";s:8:\"TPSRBF24\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-a.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPSNOTR3011\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:302:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 250px;\"><a href=\"https://forms.gle/jrzzrpu34VvrFDsMA\" target=\"_blank\" rel=\"noopener\">\n<img style=\"min-width:920px;height:250px;display: inline-block;\" src=\"//updates.themepunch-ext-a.tools//banners/SR2024survey.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPSURVEY2024\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:1;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:4;O:8:\"stdClass\":11:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:324:\"<style type=\"text/css\">#rs_ads_1 .rs_close_advert { display: none; } #rs_ads_1 { box-shadow: none !important; }</style>\n<iframe id=\"sr-notice-ad-iframe-wrapper\" \n        src=\"//updates.themepunch-ext-a.tools//banners/ads/ads.php\"\n        style=\"text-align: center; height:360px;width: 100%;\"\n        scrolling=\"no\"\n</iframe>\";s:4:\"code\";s:10:\"TPAD1_2025\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:2:\"id\";s:8:\"rs_ads_1\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("275", "revslider-addons", "O:8:\"stdClass\":36:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"559\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_particlewave.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_particlewave.jpg\";s:7:\"img_md5\";s:32:\"623bec30f175f4cc541048f1d6d5fd07\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"558\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"567\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_cluster.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_cluster.jpg\";s:7:\"img_md5\";s:32:\"7ada93a9f08a3bcfddc078699674d755\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-fluiddynamics-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"551\";s:9:\"releaseid\";s:2:\"31\";s:4:\"slug\";s:29:\"revslider-fluiddynamics-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Fluid Dynamics\";s:6:\"line_1\";s:46:\"Creating breathtaking Dynamic Fluid animations\";s:6:\"line_2\";s:25:\"as layer or as background\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_fluid.png\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_fluid.png\";s:7:\"img_md5\";s:32:\"4e52333540d80bcb2a41b8ed5961e088\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FD\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:4:\"1471\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:6:\"6.7.32\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"6.7.9\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2025-07-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"545\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"569\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"555\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"552\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"553\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"556\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2025-01-15\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"547\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"550\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2024-12-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"554\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2024-12-06\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"562\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"616\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:6:\"6.7.21\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"575\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"549\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2025-02-18\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"564\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2024-12-19\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"571\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:81:\"//updates.themepunch-ext-a.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"560\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"561\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"566\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-shapeburst-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"613\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:26:\"revslider-shapeburst-addon\";s:12:\"version_from\";s:6:\"6.7.23\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"ShapeBurst\";s:6:\"line_1\";s:8:\"Shape...\";s:6:\"line_2\";s:9:\"and Burst\";s:9:\"available\";s:5:\"7.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"670\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_shape_burst.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_shape_burst.jpg\";s:7:\"img_md5\";s:32:\"2b1b6cb4613bdfcfff4c8c46660be8f5\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:1:{i:0;s:14:\"Visual Effects\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"570\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"548\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("276", "revslider-library-check", "1755893074", "yes");
INSERT INTO `wp_options` VALUES("277", "revslider-library-hash", "324e6ba47fb68dfb7f1bd5b0b203bdc5", "yes");
INSERT INTO `wp_options` VALUES("278", "rs-library", "a:3:{s:4:\"hash\";s:32:\"324e6ba47fb68dfb7f1bd5b0b203bdc5\";s:7:\"objects\";a:417:{i:0;a:13:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14130;s:4:\"orig\";i:220294;}}i:1;a:13:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:27127;s:4:\"orig\";i:1192484;}}i:2;a:13:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:1745;s:4:\"orig\";i:36243;}}i:3;a:13:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10511;s:4:\"orig\";i:102067;}}i:4;a:13:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18581;s:4:\"orig\";i:776243;}}i:5;a:13:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4745;s:4:\"orig\";i:330658;}}i:6;a:13:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4461;s:4:\"orig\";i:109963;}}i:7;a:13:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6790;s:4:\"orig\";i:407746;}}i:8;a:13:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18710;s:4:\"orig\";i:985569;}}i:9;a:13:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6113;s:4:\"orig\";i:75865;}}i:10;a:13:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8145;s:4:\"orig\";i:400329;}}i:11;a:13:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5251;s:4:\"orig\";i:358141;}}i:12;a:13:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:127536;s:4:\"orig\";i:838279;}}i:13;a:13:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4081;s:4:\"orig\";i:22391;}}i:14;a:13:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9331;s:4:\"orig\";i:516465;}}i:15;a:13:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:463818;}}i:16;a:13:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6359;s:4:\"orig\";i:102578;}}i:17;a:13:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22078;s:4:\"orig\";i:1107904;}}i:18;a:13:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15660;s:4:\"orig\";i:355784;}}i:19;a:13:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5586;s:4:\"orig\";i:106514;}}i:20;a:13:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20909;s:4:\"orig\";i:988589;}}i:21;a:13:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6807;s:4:\"orig\";i:604409;}}i:22;a:13:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10484;s:4:\"orig\";i:229243;}}i:23;a:13:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6034;s:4:\"orig\";i:516575;}}i:24;a:13:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30999;s:4:\"orig\";i:627862;}}i:25;a:13:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:658948;}}i:26;a:13:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16432;s:4:\"orig\";i:531684;}}i:27;a:13:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15860;s:4:\"orig\";i:212685;}}i:28;a:13:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12774;s:4:\"orig\";i:290128;}}i:29;a:13:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8558;s:4:\"orig\";i:264887;}}i:30;a:13:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23349;s:4:\"orig\";i:324946;}}i:31;a:13:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18439;s:4:\"orig\";i:583276;}}i:32;a:13:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8475;s:4:\"orig\";i:241613;}}i:33;a:13:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12227;s:4:\"orig\";i:465092;}}i:34;a:13:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23476;s:4:\"orig\";i:838985;}}i:35;a:13:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:128594;s:4:\"orig\";i:323284;}}i:36;a:13:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15763;s:4:\"orig\";i:606028;}}i:37;a:13:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8743;s:4:\"orig\";i:230696;}}i:38;a:13:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18213;s:4:\"orig\";i:963650;}}i:39;a:13:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9109;s:4:\"orig\";i:190560;}}i:40;a:13:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7469;s:4:\"orig\";i:161910;}}i:41;a:13:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8883;s:4:\"orig\";i:223813;}}i:42;a:13:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13021;s:4:\"orig\";i:334845;}}i:43;a:13:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20718;s:4:\"orig\";i:626836;}}i:44;a:13:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:135139;s:4:\"orig\";i:761240;}}i:45;a:13:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13099;s:4:\"orig\";i:337348;}}i:46;a:13:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13096;s:4:\"orig\";i:413010;}}i:47;a:13:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8043;s:4:\"orig\";i:146037;}}i:48;a:13:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37011;s:4:\"orig\";i:2569343;}}i:49;a:13:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:118650;s:4:\"orig\";i:83713;}}i:50;a:13:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16941;s:4:\"orig\";i:419726;}}i:51;a:13:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23620;s:4:\"orig\";i:734047;}}i:52;a:13:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21088;s:4:\"orig\";i:683735;}}i:53;a:13:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121307;s:4:\"orig\";i:454357;}}i:54;a:13:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39586;s:4:\"orig\";i:1296460;}}i:55;a:13:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21396;s:4:\"orig\";i:835061;}}i:56;a:13:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9545;s:4:\"orig\";i:197811;}}i:57;a:13:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12033;s:4:\"orig\";i:168991;}}i:58;a:13:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39587;s:4:\"orig\";i:1318549;}}i:59;a:13:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:137321;s:4:\"orig\";i:211275;}}i:60;a:13:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14164;s:4:\"orig\";i:731428;}}i:61;a:13:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:130362;s:4:\"orig\";i:908876;}}i:62;a:13:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:132862;s:4:\"orig\";i:925492;}}i:63;a:13:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119015;s:4:\"orig\";i:133010;}}i:64;a:13:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28476;s:4:\"orig\";i:203448;}}i:65;a:13:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:120592;s:4:\"orig\";i:133753;}}i:66;a:13:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119554;s:4:\"orig\";i:160622;}}i:67;a:13:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14058;s:4:\"orig\";i:98209;}}i:68;a:13:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:126007;s:4:\"orig\";i:137953;}}i:69;a:13:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124418;s:4:\"orig\";i:108064;}}i:70;a:13:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125639;s:4:\"orig\";i:131820;}}i:71;a:13:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11948;s:4:\"orig\";i:74707;}}i:72;a:13:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:115633;s:4:\"orig\";i:176188;}}i:73;a:13:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121535;s:4:\"orig\";i:315586;}}i:74;a:13:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:133693;s:4:\"orig\";i:907152;}}i:75;a:13:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11689;s:4:\"orig\";i:183976;}}i:76;a:13:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119147;s:4:\"orig\";i:164255;}}i:77;a:13:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9499;s:4:\"orig\";i:358634;}}i:78;a:13:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14203;s:4:\"orig\";i:523017;}}i:79;a:13:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10702;s:4:\"orig\";i:121030;}}i:80;a:13:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9002;s:4:\"orig\";i:338072;}}i:81;a:13:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121622;s:4:\"orig\";i:211345;}}i:82;a:13:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:122962;s:4:\"orig\";i:353407;}}i:83;a:13:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7170;s:4:\"orig\";i:118827;}}i:84;a:13:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125910;s:4:\"orig\";i:126452;}}i:85;a:13:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12207;s:4:\"orig\";i:177730;}}i:86;a:13:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13663;s:4:\"orig\";i:833006;}}i:87;a:13:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9899;s:4:\"orig\";i:247486;}}i:88;a:13:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7169;s:4:\"orig\";i:522980;}}i:89;a:13:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12411;s:4:\"orig\";i:1051815;}}i:90;a:13:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14974;s:4:\"orig\";i:1082610;}}i:91;a:13:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26819;s:4:\"orig\";i:1283468;}}i:92;a:13:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22713;s:4:\"orig\";i:1335327;}}i:93;a:13:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5513;s:4:\"orig\";i:477513;}}i:94;a:13:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24077;s:4:\"orig\";i:1392352;}}i:95;a:13:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11502;s:4:\"orig\";i:779077;}}i:96;a:13:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7975;s:4:\"orig\";i:323107;}}i:97;a:13:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:129564;s:4:\"orig\";i:432451;}}i:98;a:13:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6743;s:4:\"orig\";i:479348;}}i:99;a:13:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3910;s:4:\"orig\";i:246373;}}i:100;a:13:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9677;s:4:\"orig\";i:154608;}}i:101;a:13:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5998;s:4:\"orig\";i:447839;}}i:102;a:13:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10117;s:4:\"orig\";i:559800;}}i:103;a:13:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24853;s:4:\"orig\";i:1214851;}}i:104;a:13:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18163;s:4:\"orig\";i:1098732;}}i:105;a:13:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5457;s:4:\"orig\";i:320148;}}i:106;a:13:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13313;s:4:\"orig\";i:828871;}}i:107;a:13:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5901;s:4:\"orig\";i:268842;}}i:108;a:13:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37178;s:4:\"orig\";i:1972817;}}i:109;a:13:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26589;s:4:\"orig\";i:851135;}}i:110;a:13:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13334;s:4:\"orig\";i:225651;}}i:111;a:13:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17640;s:4:\"orig\";i:719125;}}i:112;a:13:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8897;s:4:\"orig\";i:83416;}}i:113;a:13:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29174;s:4:\"orig\";i:1663503;}}i:114;a:13:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3668;s:4:\"orig\";i:69153;}}i:115;a:13:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3179;s:4:\"orig\";i:45340;}}i:116;a:13:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21907;s:4:\"orig\";i:937495;}}i:117;a:13:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124560;s:4:\"orig\";i:575796;}}i:118;a:13:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20553;s:4:\"orig\";i:734042;}}i:119;a:13:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9048;s:4:\"orig\";i:129827;}}i:120;a:13:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19226;s:4:\"orig\";i:758093;}}i:121;a:13:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12387;s:4:\"orig\";i:472820;}}i:122;a:13:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10972;s:4:\"orig\";i:380716;}}i:123;a:13:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12394;s:4:\"orig\";i:959761;}}i:124;a:13:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11474;s:4:\"orig\";i:284282;}}i:125;a:13:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13395;s:4:\"orig\";i:519568;}}i:126;a:13:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15367;s:4:\"orig\";i:364626;}}i:127;a:13:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16174;s:4:\"orig\";i:265728;}}i:128;a:13:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7677;s:4:\"orig\";i:256526;}}i:129;a:13:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12408;s:4:\"orig\";i:354771;}}i:130;a:13:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17621;s:4:\"orig\";i:673109;}}i:131;a:13:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9464;s:4:\"orig\";i:180683;}}i:132;a:13:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16190;s:4:\"orig\";i:381967;}}i:133;a:13:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26583;s:4:\"orig\";i:792941;}}i:134;a:13:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17464;s:4:\"orig\";i:394604;}}i:135;a:13:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19126;s:4:\"orig\";i:403268;}}i:136;a:13:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16597;s:4:\"orig\";i:552042;}}i:137;a:13:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16027;s:4:\"orig\";i:430912;}}i:138;a:13:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15961;s:4:\"orig\";i:706482;}}i:139;a:13:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20286;s:4:\"orig\";i:704324;}}i:140;a:13:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10077;s:4:\"orig\";i:197347;}}i:141;a:13:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14092;s:4:\"orig\";i:517927;}}i:142;a:13:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18629;s:4:\"orig\";i:620706;}}i:143;a:13:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10220;s:4:\"orig\";i:348322;}}i:144;a:13:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6348;s:4:\"orig\";i:211494;}}i:145;a:13:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9826;s:4:\"orig\";i:377551;}}i:146;a:13:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13862;s:4:\"orig\";i:454028;}}i:147;a:13:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18636;s:4:\"orig\";i:785357;}}i:148;a:13:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17409;s:4:\"orig\";i:996686;}}i:149;a:13:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12053;s:4:\"orig\";i:916937;}}i:150;a:13:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3887;s:4:\"orig\";i:154603;}}i:151;a:13:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16305;s:4:\"orig\";i:483681;}}i:152;a:13:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12105;s:4:\"orig\";i:314746;}}i:153;a:13:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18137;s:4:\"orig\";i:371805;}}i:154;a:13:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11586;s:4:\"orig\";i:354781;}}i:155;a:13:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9848;s:4:\"orig\";i:195359;}}i:156;a:13:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10089;s:4:\"orig\";i:218538;}}i:157;a:13:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16403;s:4:\"orig\";i:547096;}}i:158;a:13:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19188;s:4:\"orig\";i:371592;}}i:159;a:13:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15157;s:4:\"orig\";i:658386;}}i:160;a:13:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24833;s:4:\"orig\";i:942816;}}i:161;a:13:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:345362;}}i:162;a:13:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15665;s:4:\"orig\";i:407640;}}i:163;a:13:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19443;s:4:\"orig\";i:844506;}}i:164;a:13:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15564;s:4:\"orig\";i:573777;}}i:165;a:13:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13337;s:4:\"orig\";i:762091;}}i:166;a:13:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16746;s:4:\"orig\";i:365391;}}i:167;a:13:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12699;s:4:\"orig\";i:427166;}}i:168;a:13:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4748;s:4:\"orig\";i:238506;}}i:169;a:13:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19043;s:4:\"orig\";i:595277;}}i:170;a:13:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11863;s:4:\"orig\";i:228649;}}i:171;a:13:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10878;s:4:\"orig\";i:313238;}}i:172;a:13:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7596;s:4:\"orig\";i:193734;}}i:173;a:13:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9305;s:4:\"orig\";i:223763;}}i:174;a:13:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23289;s:4:\"orig\";i:699269;}}i:175;a:13:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16638;s:4:\"orig\";i:415507;}}i:176;a:13:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11706;s:4:\"orig\";i:310875;}}i:177;a:13:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18880;s:4:\"orig\";i:531273;}}i:178;a:13:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20175;s:4:\"orig\";i:554813;}}i:179;a:13:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6818;s:4:\"orig\";i:122809;}}i:180;a:13:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8776;s:4:\"orig\";i:190452;}}i:181;a:13:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52127;s:4:\"orig\";i:352596;}}i:182;a:13:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8878;s:4:\"orig\";i:183427;}}i:183;a:13:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:368977;}}i:184;a:13:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15080;s:4:\"orig\";i:707157;}}i:185;a:13:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5473;s:4:\"orig\";i:288675;}}i:186;a:13:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19262;s:4:\"orig\";i:513524;}}i:187;a:13:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9810;s:4:\"orig\";i:317981;}}i:188;a:13:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15773;s:4:\"orig\";i:519696;}}i:189;a:13:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32647;s:4:\"orig\";i:350074;}}i:190;a:13:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14643;s:4:\"orig\";i:314424;}}i:191;a:13:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19823;s:4:\"orig\";i:511473;}}i:192;a:13:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37262;s:4:\"orig\";i:1590451;}}i:193;a:13:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13647;s:4:\"orig\";i:408622;}}i:194;a:13:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10075;s:4:\"orig\";i:216586;}}i:195;a:13:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10969;s:4:\"orig\";i:405945;}}i:196;a:13:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9975;s:4:\"orig\";i:257177;}}i:197;a:13:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9598;s:4:\"orig\";i:300066;}}i:198;a:13:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7588;s:4:\"orig\";i:184359;}}i:199;a:13:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9507;s:4:\"orig\";i:290246;}}i:200;a:13:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14875;s:4:\"orig\";i:324145;}}i:201;a:13:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18138;s:4:\"orig\";i:736181;}}i:202;a:13:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10664;s:4:\"orig\";i:411404;}}i:203;a:13:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11609;s:4:\"orig\";i:273103;}}i:204;a:13:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16837;s:4:\"orig\";i:456937;}}i:205;a:13:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13774;s:4:\"orig\";i:385875;}}i:206;a:13:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12285;s:4:\"orig\";i:546492;}}i:207;a:13:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12631;s:4:\"orig\";i:540206;}}i:208;a:13:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9964;s:4:\"orig\";i:309994;}}i:209;a:13:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13683;s:4:\"orig\";i:369417;}}i:210;a:13:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15941;s:4:\"orig\";i:475914;}}i:211;a:13:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17854;s:4:\"orig\";i:371480;}}i:212;a:13:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17441;s:4:\"orig\";i:507045;}}i:213;a:13:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32396;s:4:\"orig\";i:750503;}}i:214;a:13:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25355;s:4:\"orig\";i:517171;}}i:215;a:13:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30467;s:4:\"orig\";i:1076108;}}i:216;a:13:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17629;s:4:\"orig\";i:804567;}}i:217;a:13:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12952;s:4:\"orig\";i:489898;}}i:218;a:13:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11065;s:4:\"orig\";i:384178;}}i:219;a:13:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6262;s:4:\"orig\";i:198960;}}i:220;a:13:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16353;s:4:\"orig\";i:245636;}}i:221;a:13:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6048;s:4:\"orig\";i:133907;}}i:222;a:13:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15187;s:4:\"orig\";i:450326;}}i:223;a:13:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17977;s:4:\"orig\";i:582673;}}i:224;a:13:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20171;s:4:\"orig\";i:617346;}}i:225;a:13:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14937;s:4:\"orig\";i:227355;}}i:226;a:13:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9789;s:4:\"orig\";i:321713;}}i:227;a:13:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18374;s:4:\"orig\";i:642218;}}i:228;a:13:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17332;s:4:\"orig\";i:791283;}}i:229;a:13:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28854;s:4:\"orig\";i:1228379;}}i:230;a:13:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7529;s:4:\"orig\";i:263779;}}i:231;a:13:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18101;s:4:\"orig\";i:617407;}}i:232;a:13:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18049;s:4:\"orig\";i:757700;}}i:233;a:13:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18133;s:4:\"orig\";i:633849;}}i:234;a:13:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24430;s:4:\"orig\";i:954378;}}i:235;a:13:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16738;s:4:\"orig\";i:664032;}}i:236;a:13:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17594;s:4:\"orig\";i:503413;}}i:237;a:13:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15558;s:4:\"orig\";i:508616;}}i:238;a:13:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14665;s:4:\"orig\";i:429256;}}i:239;a:13:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20433;s:4:\"orig\";i:1162968;}}i:240;a:13:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10872;s:4:\"orig\";i:289488;}}i:241;a:13:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17988;s:4:\"orig\";i:602577;}}i:242;a:13:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9794;s:4:\"orig\";i:352053;}}i:243;a:13:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:370551;}}i:244;a:13:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10397;s:4:\"orig\";i:280660;}}i:245;a:13:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26832;s:4:\"orig\";i:677097;}}i:246;a:13:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13591;s:4:\"orig\";i:846550;}}i:247;a:13:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12138;s:4:\"orig\";i:511326;}}i:248;a:13:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14005;s:4:\"orig\";i:392648;}}i:249;a:13:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11612;s:4:\"orig\";i:688650;}}i:250;a:13:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28096;s:4:\"orig\";i:766943;}}i:251;a:13:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17419;s:4:\"orig\";i:759716;}}i:252;a:13:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10910;s:4:\"orig\";i:191059;}}i:253;a:13:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24825;s:4:\"orig\";i:706226;}}i:254;a:13:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11091;s:4:\"orig\";i:300143;}}i:255;a:13:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15004;s:4:\"orig\";i:475888;}}i:256;a:13:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13155;s:4:\"orig\";i:683645;}}i:257;a:13:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15305;s:4:\"orig\";i:655207;}}i:258;a:13:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17740;s:4:\"orig\";i:745183;}}i:259;a:13:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17442;s:4:\"orig\";i:641873;}}i:260;a:13:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16088;s:4:\"orig\";i:241567;}}i:261;a:13:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8512;s:4:\"orig\";i:267430;}}i:262;a:13:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25804;s:4:\"orig\";i:908234;}}i:263;a:13:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4691;s:4:\"orig\";i:108160;}}i:264;a:13:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12753;s:4:\"orig\";i:218714;}}i:265;a:13:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19312;s:4:\"orig\";i:438345;}}i:266;a:13:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16224;s:4:\"orig\";i:409547;}}i:267;a:13:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22344;s:4:\"orig\";i:432904;}}i:268;a:13:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9431;s:4:\"orig\";i:220442;}}i:269;a:13:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29538;s:4:\"orig\";i:733632;}}i:270;a:13:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12859;s:4:\"orig\";i:430959;}}i:271;a:13:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13413;s:4:\"orig\";i:324558;}}i:272;a:13:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11553;s:4:\"orig\";i:146076;}}i:273;a:13:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21184;s:4:\"orig\";i:537577;}}i:274;a:13:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14134;s:4:\"orig\";i:245565;}}i:275;a:13:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16035;s:4:\"orig\";i:401592;}}i:276;a:13:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12906;s:4:\"orig\";i:483885;}}i:277;a:13:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:80956;}}i:278;a:13:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11452;s:4:\"orig\";i:175118;}}i:279;a:13:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12170;s:4:\"orig\";i:236860;}}i:280;a:13:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10268;s:4:\"orig\";i:117315;}}i:281;a:13:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12485;s:4:\"orig\";i:374567;}}i:282;a:13:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8401;s:4:\"orig\";i:203253;}}i:283;a:13:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12578;s:4:\"orig\";i:287796;}}i:284;a:13:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8484;s:4:\"orig\";i:199508;}}i:285;a:13:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16659;s:4:\"orig\";i:524922;}}i:286;a:13:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9240;s:4:\"orig\";i:109310;}}i:287;a:13:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8288;s:4:\"orig\";i:216553;}}i:288;a:13:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6855;s:4:\"orig\";i:234043;}}i:289;a:13:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12347;s:4:\"orig\";i:238706;}}i:290;a:13:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7748;s:4:\"orig\";i:169462;}}i:291;a:13:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10402;s:4:\"orig\";i:358403;}}i:292;a:13:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12887;s:4:\"orig\";i:261525;}}i:293;a:13:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:2963;s:4:\"orig\";i:30890;}}i:294;a:13:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10266;s:4:\"orig\";i:183341;}}i:295;a:13:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8156;s:4:\"orig\";i:102119;}}i:296;a:13:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10271;s:4:\"orig\";i:138495;}}i:297;a:13:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11654;s:4:\"orig\";i:171098;}}i:298;a:13:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10569;s:4:\"orig\";i:437331;}}i:299;a:13:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15739;s:4:\"orig\";i:446809;}}i:300;a:13:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9456;s:4:\"orig\";i:206722;}}i:301;a:13:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13833;s:4:\"orig\";i:341185;}}i:302;a:13:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10647;s:4:\"orig\";i:193025;}}i:303;a:13:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6239;s:4:\"orig\";i:48178;}}i:304;a:13:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14454;s:4:\"orig\";i:454843;}}i:305;a:13:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7734;s:4:\"orig\";i:119909;}}i:306;a:13:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11927;s:4:\"orig\";i:209224;}}i:307;a:13:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9609;s:4:\"orig\";i:230249;}}i:308;a:13:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12396;s:4:\"orig\";i:290596;}}i:309;a:14:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25803;s:11:\"video_thumb\";i:2753823;s:5:\"cover\";i:127867;s:4:\"orig\";i:5991847;}}i:310;a:14:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19154;s:11:\"video_thumb\";i:4783500;s:5:\"cover\";i:97843;s:4:\"orig\";i:12408832;}}i:311;a:14:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28284;s:11:\"video_thumb\";i:2150510;s:5:\"cover\";i:124176;s:4:\"orig\";i:7726114;}}i:312;a:14:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23354;s:11:\"video_thumb\";i:3635377;s:5:\"cover\";i:106283;s:4:\"orig\";i:12688465;}}i:313;a:14:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29858;s:11:\"video_thumb\";i:9614915;s:5:\"cover\";i:153660;s:4:\"orig\";i:13424151;}}i:314;a:14:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19155;s:11:\"video_thumb\";i:2361089;s:5:\"cover\";i:103588;s:4:\"orig\";i:14717688;}}i:315;a:14:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:11719;s:11:\"video_thumb\";i:4841259;s:5:\"cover\";i:40309;s:4:\"orig\";i:11715637;}}i:316;a:14:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:56469;s:11:\"video_thumb\";i:5107558;s:5:\"cover\";i:273635;s:4:\"orig\";i:13833056;}}i:317;a:14:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:30439;s:11:\"video_thumb\";i:3864288;s:5:\"cover\";i:133345;s:4:\"orig\";i:13159814;}}i:318;a:14:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31267;s:11:\"video_thumb\";i:2732735;s:5:\"cover\";i:173636;s:4:\"orig\";i:5536475;}}i:319;a:14:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29090;s:11:\"video_thumb\";i:4861363;s:5:\"cover\";i:188894;s:4:\"orig\";i:13731609;}}i:320;a:14:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31123;s:11:\"video_thumb\";i:1386258;s:5:\"cover\";i:219740;s:4:\"orig\";i:6479275;}}i:321;a:14:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21091;s:11:\"video_thumb\";i:11134706;s:5:\"cover\";i:115059;s:4:\"orig\";i:12313637;}}i:322;a:14:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19624;s:11:\"video_thumb\";i:3913179;s:5:\"cover\";i:118864;s:4:\"orig\";i:14700830;}}i:323;a:14:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:45123;s:11:\"video_thumb\";i:2547876;s:5:\"cover\";i:268587;s:4:\"orig\";i:8823724;}}i:324;a:14:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:33867;s:11:\"video_thumb\";i:5972511;s:5:\"cover\";i:172632;s:4:\"orig\";i:13869858;}}i:325;a:14:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16185;s:11:\"video_thumb\";i:4097952;s:5:\"cover\";i:160912;s:4:\"orig\";i:12307362;}}i:326;a:14:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9324;s:11:\"video_thumb\";i:1843046;s:5:\"cover\";i:94919;s:4:\"orig\";i:4938526;}}i:327;a:14:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:13455;s:11:\"video_thumb\";i:5101194;s:5:\"cover\";i:66493;s:4:\"orig\";i:11852447;}}i:328;a:14:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20003;s:11:\"video_thumb\";i:1696754;s:5:\"cover\";i:103202;s:4:\"orig\";i:12515577;}}i:329;a:14:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19377;s:11:\"video_thumb\";i:3861934;s:5:\"cover\";i:101592;s:4:\"orig\";i:13370749;}}i:330;a:14:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31120;s:11:\"video_thumb\";i:2732488;s:5:\"cover\";i:190596;s:4:\"orig\";i:13625169;}}i:331;a:14:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17475;s:11:\"video_thumb\";i:1248121;s:5:\"cover\";i:203284;s:4:\"orig\";i:4921567;}}i:332;a:14:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26132;s:11:\"video_thumb\";i:5777142;s:5:\"cover\";i:138198;s:4:\"orig\";i:12817212;}}i:333;a:14:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40668;s:11:\"video_thumb\";i:3711074;s:5:\"cover\";i:243587;s:4:\"orig\";i:12354374;}}i:334;a:14:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:41275;s:11:\"video_thumb\";i:2631988;s:5:\"cover\";i:330226;s:4:\"orig\";i:8304831;}}i:335;a:14:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:54209;s:11:\"video_thumb\";i:4596191;s:5:\"cover\";i:335804;s:4:\"orig\";i:13306988;}}i:336;a:14:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:75484;s:11:\"video_thumb\";i:3134686;s:5:\"cover\";i:461854;s:4:\"orig\";i:20337064;}}i:337;a:14:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25915;s:11:\"video_thumb\";i:2352326;s:5:\"cover\";i:136931;s:4:\"orig\";i:12104254;}}i:338;a:14:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40965;s:11:\"video_thumb\";i:8637814;s:5:\"cover\";i:195812;s:4:\"orig\";i:13878956;}}i:339;a:14:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19037;s:11:\"video_thumb\";i:3065043;s:5:\"cover\";i:65493;s:4:\"orig\";i:12935967;}}i:340;a:14:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:24344;s:11:\"video_thumb\";i:1911296;s:5:\"cover\";i:192540;s:4:\"orig\";i:4631422;}}i:341;a:14:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23517;s:11:\"video_thumb\";i:4899641;s:5:\"cover\";i:86737;s:4:\"orig\";i:12281833;}}i:342;a:14:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31844;s:11:\"video_thumb\";i:4412295;s:5:\"cover\";i:154844;s:4:\"orig\";i:10753079;}}i:343;a:14:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14905;s:11:\"video_thumb\";i:3394055;s:5:\"cover\";i:73276;s:4:\"orig\";i:11722124;}}i:344;a:14:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:48591;s:11:\"video_thumb\";i:5268295;s:5:\"cover\";i:211021;s:4:\"orig\";i:11990742;}}i:345;a:14:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27863;s:11:\"video_thumb\";i:2674570;s:5:\"cover\";i:119321;s:4:\"orig\";i:11602755;}}i:346;a:14:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27505;s:11:\"video_thumb\";i:3025283;s:5:\"cover\";i:144357;s:4:\"orig\";i:13176990;}}i:347;a:14:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22543;s:11:\"video_thumb\";i:1327376;s:5:\"cover\";i:111224;s:4:\"orig\";i:4727340;}}i:348;a:14:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:34936;s:11:\"video_thumb\";i:3198076;s:5:\"cover\";i:160493;s:4:\"orig\";i:12804022;}}i:349;a:14:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28883;s:11:\"video_thumb\";i:4750283;s:5:\"cover\";i:153687;s:4:\"orig\";i:13054569;}}i:350;a:14:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:53693;s:11:\"video_thumb\";i:9780815;s:5:\"cover\";i:341419;s:4:\"orig\";i:13738077;}}i:351;a:14:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9494;s:11:\"video_thumb\";i:942533;s:5:\"cover\";i:52833;s:4:\"orig\";i:6629299;}}i:352;a:14:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22781;s:11:\"video_thumb\";i:2415073;s:5:\"cover\";i:126450;s:4:\"orig\";i:11684367;}}i:353;a:14:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22296;s:11:\"video_thumb\";i:1465206;s:5:\"cover\";i:73047;s:4:\"orig\";i:4008355;}}i:354;a:14:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19851;s:11:\"video_thumb\";i:3023599;s:5:\"cover\";i:25426;s:4:\"orig\";i:12847145;}}i:355;a:14:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:18002;s:11:\"video_thumb\";i:1791449;s:5:\"cover\";i:101725;s:4:\"orig\";i:13746552;}}i:356;a:14:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:8176;s:11:\"video_thumb\";i:4255586;s:5:\"cover\";i:75455;s:4:\"orig\";i:10948491;}}i:357;a:14:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:46567;s:11:\"video_thumb\";i:3789289;s:5:\"cover\";i:25425;s:4:\"orig\";i:15943336;}}i:358;a:14:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26927;s:11:\"video_thumb\";i:2605391;s:5:\"cover\";i:149830;s:4:\"orig\";i:13232415;}}i:359;a:14:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20000;s:11:\"video_thumb\";i:655504;s:5:\"cover\";i:620066;s:4:\"orig\";i:13229794;}}i:360;a:14:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23213;s:11:\"video_thumb\";i:498407;s:5:\"cover\";i:308442;s:4:\"orig\";i:11108924;}}i:361;a:14:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21648;s:11:\"video_thumb\";i:109062;s:5:\"cover\";i:305957;s:4:\"orig\";i:6267674;}}i:362;a:14:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19198;s:11:\"video_thumb\";i:326656;s:5:\"cover\";i:554701;s:4:\"orig\";i:10151652;}}i:363;a:14:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14725;s:11:\"video_thumb\";i:72977;s:5:\"cover\";i:72535;s:4:\"orig\";i:4938006;}}i:364;a:14:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:12165;s:11:\"video_thumb\";i:256975;s:5:\"cover\";i:340550;s:4:\"orig\";i:9691449;}}i:365;a:14:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:36900;s:11:\"video_thumb\";i:920631;s:5:\"cover\";i:949012;s:4:\"orig\";i:13422013;}}i:366;a:14:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17289;s:11:\"video_thumb\";i:137402;s:5:\"cover\";i:300574;s:4:\"orig\";i:7528458;}}i:367;a:14:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16562;s:11:\"video_thumb\";i:161004;s:5:\"cover\";i:291708;s:4:\"orig\";i:7596827;}}i:368;a:14:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19186;s:11:\"video_thumb\";i:404406;s:5:\"cover\";i:496556;s:4:\"orig\";i:15358645;}}i:369;a:14:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11778;s:5:\"video\";i:126230;}}i:370;a:14:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9342;s:5:\"video\";i:258890;}}i:371;a:14:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22925;s:5:\"video\";i:337622;}}i:372;a:14:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13590;s:5:\"video\";i:143116;}}i:373;a:14:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12603;s:5:\"video\";i:267056;}}i:374;a:14:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11225;s:5:\"video\";i:104722;}}i:375;a:14:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16221;s:5:\"video\";i:183244;}}i:376;a:14:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15072;s:5:\"video\";i:90577;}}i:377;a:14:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11741;s:5:\"video\";i:96061;}}i:378;a:14:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15979;s:5:\"video\";i:136040;}}i:379;a:14:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13637;s:5:\"video\";i:98053;}}i:380;a:14:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14892;s:5:\"video\";i:125449;}}i:381;a:14:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16568;s:5:\"video\";i:127133;}}i:382;a:14:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19099;s:5:\"video\";i:202784;}}i:383;a:14:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21756;s:5:\"video\";i:295899;}}i:384;a:14:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20783;s:5:\"video\";i:279347;}}i:385;a:14:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17862;s:5:\"video\";i:111140;}}i:386;a:14:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10799;s:5:\"video\";i:49269;}}i:387;a:14:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14442;s:5:\"video\";i:143950;}}i:388;a:14:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16819;s:5:\"video\";i:142842;}}i:389;a:14:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12575;s:5:\"video\";i:106541;}}i:390;a:14:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12931;s:5:\"video\";i:84922;}}i:391;a:14:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18105;s:5:\"video\";i:184683;}}i:392;a:14:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13440;s:5:\"video\";i:104866;}}i:393;a:14:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17477;s:5:\"video\";i:147765;}}i:394;a:14:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36069;s:5:\"video\";i:104559;}}i:395;a:14:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20095;s:5:\"video\";i:60429;}}i:396;a:14:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:38056;s:5:\"video\";i:45726;}}i:397;a:14:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:54736;s:5:\"video\";i:26685;}}i:398;a:14:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34717;s:5:\"video\";i:16283;}}i:399;a:14:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25700;s:5:\"video\";i:38602;}}i:400;a:14:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:55897;s:5:\"video\";i:21279;}}i:401;a:14:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39579;s:5:\"video\";i:22677;}}i:402;a:14:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41903;s:5:\"video\";i:65515;}}i:403;a:14:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25902;s:5:\"video\";i:15295;}}i:404;a:14:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40029;s:5:\"video\";i:28970;}}i:405;a:14:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21834;s:5:\"video\";i:21250;}}i:406;a:14:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36633;s:5:\"video\";i:51973;}}i:407;a:14:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22669;s:5:\"video\";i:46598;}}i:408;a:14:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52537;s:5:\"video\";i:29580;}}i:409;a:14:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34343;s:5:\"video\";i:18413;}}i:410;a:14:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20519;s:5:\"video\";i:25391;}}i:411;a:14:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16265;s:5:\"video\";i:75634;}}i:412;a:14:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41495;s:5:\"video\";i:49692;}}i:413;a:14:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40417;s:5:\"video\";i:80078;}}i:414;a:14:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34150;s:5:\"video\";i:23500;}}i:415;a:14:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15426;s:5:\"video\";i:21651;}}i:416;a:14:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:33524;s:5:\"video\";i:46449;}}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "no");
INSERT INTO `wp_options` VALUES("279", "revslider-templates-check", "1756274060", "yes");
INSERT INTO `wp_options` VALUES("280", "revslider-templates-hash", "b96b775a157df234982e78b412618927", "yes");
INSERT INTO `wp_options` VALUES("281", "rs-templates-new", "", "no");
INSERT INTO `wp_options` VALUES("282", "rs-templates", "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", "no");
INSERT INTO `wp_options` VALUES("286", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("287", "woocommerce_admin_notices", "a:1:{i:0;s:14:\"template_files\";}", "yes");
INSERT INTO `wp_options` VALUES("288", "revslider_update_version", "6.7.24", "yes");
INSERT INTO `wp_options` VALUES("289", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"pxrR8bIo9xHWKDuK7P9rSJVgDWAoTtXm\";}", "yes");
INSERT INTO `wp_options` VALUES("291", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("292", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("293", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("294", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("295", "widget_woocommerce_price_filter", "a:2:{i:3;a:1:{s:5:\"title\";s:19:\"فیلتر قیمت\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("296", "widget_woocommerce_product_categories", "a:2:{i:2;a:8:{s:5:\"title\";s:32:\"دسته‌های محصولات\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("297", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("298", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("299", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("300", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("301", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("302", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("303", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("304", "widget_nav_mega_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("305", "widget_woodmart-banner", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("306", "widget_woodmart-author-information", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("307", "widget_woodmart-instagram", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("308", "widget_woodmart-html-block", "a:2:{i:2;a:1:{s:2:\"id\";s:2:\"35\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("309", "widget_woodmart-recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("310", "widget_woodmart-twitter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("311", "widget_woodmart-user-panel", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("312", "widget_woodmart-woocommerce-layered-nav", "a:4:{i:2;a:8:{s:5:\"title\";s:17:\"فیلتر رنگ\";s:9:\"attribute\";s:5:\"color\";s:8:\"category\";s:3:\"all\";s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:3:\"off\";}i:3;a:11:{s:5:\"title\";s:34:\"فیلتر برند محصولات\";s:9:\"attribute\";s:5:\"brand\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:3:\"off\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:7:\"inherit\";s:17:\"search_by_filters\";b:0;}s:12:\"_multiwidget\";i:1;i:5;a:12:{s:5:\"title\";s:19:\"مناسب برای\";s:9:\"attribute\";s:19:\"مناسب-برای\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:7:\"inherit\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:2:\"on\";s:10:\"checkboxes\";s:3:\"off\";s:17:\"search_by_filters\";b:0;}}", "on");
INSERT INTO `wp_options` VALUES("313", "widget_woodmart-woocommerce-sort-by", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("314", "widget_woodmart-price-filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("315", "widget_woodmart-ajax-search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("317", "vc_version", "6.2.0", "yes");
INSERT INTO `wp_options` VALUES("319", "xts-default_header-css-data", ".whb-top-bar .wd-dropdown {\n	margin-top: 0px;\n}\n\n.whb-top-bar .wd-dropdown:after {\n	height: 10px;\n}\n\n.whb-sticked .whb-general-header .wd-dropdown {\n	margin-top: 7.5px;\n}\n\n.whb-sticked .whb-general-header .wd-dropdown:after {\n	height: 17.5px;\n}\n\n.whb-header-bottom .wd-dropdown {\n	margin-top: 5px;\n}\n\n.whb-header-bottom .wd-dropdown:after {\n	height: 15px;\n}\n\n.whb-sticked .whb-header-bottom .wd-dropdown {\n	margin-top: 5px;\n}\n\n.whb-sticked .whb-header-bottom .wd-dropdown:after {\n	height: 15px;\n}\n\n.whb-header .whb-header-bottom .wd-header-cats {\n	margin-top: -1px;\n	margin-bottom: -1px;\n	height: calc(100% + 2px);\n}\n\n\n@media (min-width: 1025px) {\n		.whb-top-bar-inner {\n		height: 40px;\n		max-height: 40px;\n	}\n\n		.whb-sticked .whb-top-bar-inner {\n		height: 40px;\n		max-height: 40px;\n	}\n		\n		.whb-general-header-inner {\n		height: 90px;\n		max-height: 90px;\n	}\n\n		.whb-sticked .whb-general-header-inner {\n		height: 55px;\n		max-height: 55px;\n	}\n		\n		.whb-header-bottom-inner {\n		height: 50px;\n		max-height: 50px;\n	}\n\n		.whb-sticked .whb-header-bottom-inner {\n		height: 50px;\n		max-height: 50px;\n	}\n		\n	\n	}\n\n@media (max-width: 1024px) {\n	\n		.whb-general-header-inner {\n		height: 60px;\n		max-height: 60px;\n	}\n	\n	\n	\n	}\n		\n.whb-top-bar {\n	background-color: rgba(255, 255, 255, 1);border-color: rgba(217, 217, 217, 1);border-bottom-width: 1px;border-bottom-style: solid;\n}\n\n.whb-general-header {\n	border-color: rgba(129, 129, 129, 0.2);border-bottom-width: 1px;border-bottom-style: solid;\n}\n.whb-n75lp1zoots235dih121 .menu-opener { background-color: rgba(255, 255, 255, 1); }.whb-n75lp1zoots235dih121.wd-more-cat:not(.wd-show-cat) .item-level-0:nth-child(n+7):not(:last-child) {\n				    display: none;\n				}.\n				wd-more-cat .item-level-0:nth-child(n+7) {\n				    animation: wd-fadeIn .3s ease both;\n				}\n.whb-header-bottom {\n	border-color: rgba(222, 222, 222, 1);border-bottom-width: 1px;border-bottom-style: solid;\n}\n", "yes");
INSERT INTO `wp_options` VALUES("320", "xts-default_header-status", "valid", "yes");
INSERT INTO `wp_options` VALUES("321", "xts-default_header-version", "7.0.2", "yes");
INSERT INTO `wp_options` VALUES("322", "xts-theme_settings_default-css-data", "@font-face {\n	font-weight: normal;\n	font-style: normal;\n	font-family: \"woodmart-font\";\n	src: url(\"//a.maikuta.ir/wp-content/themes/woodmart/fonts/woodmart-font-2-700.woff2?v=8.2.7.1\") format(\"woff2\");\n}\n\n@font-face {\n	font-family: \"star\";\n	font-weight: 400;\n	font-style: normal;\n	src: url(\"//a.maikuta.ir/wp-content/plugins/woocommerce/assets/fonts/star.eot?#iefix\") format(\"embedded-opentype\"), url(\"//a.maikuta.ir/wp-content/plugins/woocommerce/assets/fonts/star.woff\") format(\"woff\"), url(\"//a.maikuta.ir/wp-content/plugins/woocommerce/assets/fonts/star.ttf\") format(\"truetype\"), url(\"//a.maikuta.ir/wp-content/plugins/woocommerce/assets/fonts/star.svg#star\") format(\"svg\");\n}\n\n@font-face {\n	font-family: \"WooCommerce\";\n	font-weight: 400;\n	font-style: normal;\n	src: url(\"//a.maikuta.ir/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.eot?#iefix\") format(\"embedded-opentype\"), url(\"//a.maikuta.ir/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.woff\") format(\"woff\"), url(\"//a.maikuta.ir/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.ttf\") format(\"truetype\"), url(\"//a.maikuta.ir/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.svg#WooCommerce\") format(\"svg\");\n}\n\n:root {\n	--wd-text-font: IRansansX;\n	--wd-text-font-weight: 400;\n	--wd-text-color: #777777;\n	--wd-text-font-size: 14px;\n	--wd-title-font: IRansansX;\n	--wd-title-font-weight: 600;\n	--wd-title-color: #242424;\n	--wd-entities-title-font: IRansansX;\n	--wd-entities-title-font-weight: 500;\n	--wd-entities-title-color: #333333;\n	--wd-entities-title-color-hover: rgb(51 51 51 / 65%);\n	--wd-alternative-font: IRansansX;\n	--wd-widget-title-font: IRansansX;\n	--wd-widget-title-font-weight: 600;\n	--wd-widget-title-transform: uppercase;\n	--wd-widget-title-color: #333;\n	--wd-widget-title-font-size: 16px;\n	--wd-header-el-font: IRansansX;\n	--wd-header-el-font-weight: 600;\n	--wd-header-el-transform: uppercase;\n	--wd-header-el-font-size: 13px;\n	--wd-primary-color: #d60644;\n	--wd-alternative-color: #fbbc34;\n	--wd-link-color: #333333;\n	--wd-link-color-hover: #242424;\n	--btn-default-bgcolor: #f7f7f7;\n	--btn-default-bgcolor-hover: #efefef;\n	--btn-accented-bgcolor: #d60644;\n	--btn-accented-bgcolor-hover: #c40545;\n	--wd-form-brd-width: 2px;\n	--notices-success-bg: #459647;\n	--notices-success-color: #fff;\n	--notices-warning-bg: #E0B252;\n	--notices-warning-color: #fff;\n}\n.wd-popup.wd-age-verify {\n	--wd-popup-width: 500px;\n}\n.wd-popup.wd-promo-popup {\n	background-color: #111111;\n	background-image: none;\n	background-repeat: no-repeat;\n	background-size: contain;\n	background-position: left center;\n	--wd-popup-width: 800px;\n}\n:is(.woodmart-woocommerce-layered-nav, .wd-product-category-filter) .wd-scroll-content {\n	max-height: 233px;\n}\n.wd-page-title {\n	background-color: #e8e8e8;\n	background-image: none;\n	background-size: cover;\n	background-position: center center;\n}\n.wd-footer {\n	background-color: #f4f4f4;\n	background-image: none;\n}\n.wd-popup.popup-quick-view {\n	--wd-popup-width: 920px;\n}\n:root{\n--wd-container-w: 1600px;\n--wd-form-brd-radius: 5px;\n--btn-default-color: #333;\n--btn-default-color-hover: #333;\n--btn-accented-color: #fff;\n--btn-accented-color-hover: #fff;\n--btn-default-brd-radius: 5px;\n--btn-default-box-shadow: none;\n--btn-default-box-shadow-hover: none;\n--btn-accented-brd-radius: 5px;\n--btn-accented-box-shadow: none;\n--btn-accented-box-shadow-hover: none;\n--wd-brd-radius: 5px;\n}\n\n\nrs-slides :is([data-type=text],[data-type=button]) {\nfont-family: IRansansX !important;\n}\nrs-slides :is(h1,h2,h3,h4,h5,h6)[data-type=text] {\nfont-family: IRansansX !important;\n}\n\n.woodmart-button-wrapper.inline-element {\r\n    margin-bottom: 0px;\r\n}\r\n.promo-banner .banner-image img {\r\n    border-radius: 15px;\r\n}\r\n.wd-hover-tiled {\r\n    overflow: hidden;\r\n    border-radius: 15px;\r\n	background: #fff;\r\n}\r\n.product-grid-item .product-image-link {\r\n    display: block;\r\n    padding: 20px;\r\n}\r\n.labels-rectangular .product-label {\r\n    padding: 5px 10px;\r\n    font-size: 12px;\r\n    border-radius: 15px;\r\n    margin-right: 5px;\r\n}", "on");
INSERT INTO `wp_options` VALUES("323", "xts-theme_settings_default-status", "valid", "yes");
INSERT INTO `wp_options` VALUES("324", "xts-theme_settings_default-version", "8.2.7.1", "on");
INSERT INTO `wp_options` VALUES("334", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("338", "xts-woodmart-options", "a:649:{s:12:\"last_message\";s:4:\"save\";s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";s:1:\"0\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:5:\"after\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"1\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"0\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:1:\"0\";s:23:\"stretch_product_desktop\";s:1:\"0\";s:22:\"stretch_product_tablet\";s:1:\"0\";s:22:\"stretch_product_mobile\";s:1:\"0\";s:25:\"product_title_lines_limit\";s:3:\"two\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"0\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"1\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";s:1:\"0\";s:23:\"grid_stock_progress_bar\";s:1:\"1\";s:14:\"shop_countdown\";s:1:\"1\";s:22:\"categories_under_title\";s:1:\"0\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:18:\"show_reviews_count\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:19:\"categories_rounding\";s:0:\"\";s:31:\"custom_categories_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"0\";s:15:\"shop_categories\";s:1:\"0\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"4\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"30\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:2:{i:0;s:1:\"3\";i:1;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:1:\"8\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:7:\"9,24,36\";s:15:\"shop_pagination\";s:8:\"more-btn\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"233\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_content\";s:2:\"35\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_246188\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:171:\"<h4 style=\"text-align: center\">Are you over 18?</h4>\r\n<p style=\"text-align: center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:134:\"<h4 style=\"text-align: center\">Access forbidden</h4>\r\n<p style=\"text-align: center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:4:\"text\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:0:\"\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:224:\"ما از کوکی ها برای بهبود کارکردن شما با سایت استفاده می کنیم. با استفاده از این سایت شما استفاده ما از کوکی ها را پذیرفته اید.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"0\";s:18:\"header_banner_link\";s:1:\"#\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:21:\"[html_block id=\"398\"]\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"55\";s:27:\"header_banner_mobile_height\";s:2:\"50\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:4:\"wide\";s:17:\"site_custom_width\";s:4:\"1222\";s:11:\"main_layout\";s:10:\"full-width\";s:13:\"sidebar_width\";s:1:\"3\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:7:\"default\";s:16:\"title-background\";a:7:{s:5:\"color\";s:7:\"#e8e8e8\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:4:\"dark\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"12\";s:17:\"footer_html_block\";s:3:\"790\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:7:\"#f4f4f4\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:4:\"dark\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"0\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:0:\"\";s:11:\"copyrights2\";s:0:\"\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:20:\"[html_block id=\"67\"]\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:9:\"IRansansX\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:9:\"IRansansX\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:9:\"IRansansX\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:9:\"IRansansX\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:9:\"IRansansX\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:9:\"IRansansX\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"13\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:2:{i:0;a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"2\";s:6:\"weight\";s:3:\"700\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:1:\"5\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:7:\"#d60644\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:7:\"#fbbc34\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:7:\"#242424\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:12:\"semi-rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:7:\"#f7f7f7\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#efefef\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:12:\"semi-rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:7:\"#d60644\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#c40545\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:12:\"semi-rounded\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:7:\"masonry\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"1\";s:12:\"blog_columns\";s:1:\"3\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"100\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:2:\"30\";s:18:\"portoflio_per_page\";s:2:\"12\";s:20:\"portfolio_pagination\";s:10:\"pagination\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"1\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"1\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"old\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:11:\"rectangular\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:0:\"\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:12:\"availability\";i:2;s:3:\"sku\";}s:18:\"empty_compare_text\";s:0:\"\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:27:\"update_cart_quantity_change\";s:1:\"0\";s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:13:\"sidebar-right\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"2\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"1\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:20:\"single_product_style\";s:1:\"1\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"1\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:6:\"bottom\";s:34:\"single_product_grid_column_desktop\";s:0:\"\";s:33:\"single_product_grid_column_tablet\";s:0:\"\";s:33:\"single_product_grid_column_mobile\";s:0:\"\";s:31:\"single_product_grid_columns_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:22:\"main_gallery_on_tablet\";s:1:\"1\";s:22:\"main_gallery_on_mobile\";s:1:\"1\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:12:\"below_header\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"1\";s:17:\"product_countdown\";s:1:\"1\";s:23:\"sale_countdown_variable\";s:1:\"1\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"5\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:0:\"\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"0\";s:9:\"reg_title\";s:10:\"عضویت\";s:8:\"reg_text\";s:0:\"\";s:11:\"login_title\";s:8:\"ورود\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:447:\".woodmart-button-wrapper.inline-element {\r\n    margin-bottom: 0px;\r\n}\r\n.promo-banner .banner-image img {\r\n    border-radius: 15px;\r\n}\r\n.wd-hover-tiled {\r\n    overflow: hidden;\r\n    border-radius: 15px;\r\n	background: #fff;\r\n}\r\n.product-grid-item .product-image-link {\r\n    display: block;\r\n    padding: 20px;\r\n}\r\n.labels-rectangular .product-label {\r\n    padding: 5px 10px;\r\n    font-size: 12px;\r\n    border-radius: 15px;\r\n    margin-right: 5px;\r\n}\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:14:\"isntagram_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:8:\"share_ok\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:16:\"load_text_domain\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:29:\"disable_gutenberg_backend_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:16:\"flickity_library\";s:8:\"required\";s:21:\"flickity-fade_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:11:\"owl_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:13:\"slick_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:22:\"lazy_generate_previews\";s:1:\"1\";s:12:\"lazy_base_64\";s:1:\"1\";s:19:\"lazy_proprtion_size\";s:1:\"1\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:28:\"load_elementor_optimized_css\";s:1:\"0\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:8:\"required\";s:20:\"el_waypoints_library\";s:8:\"required\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:6:\"always\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:12:\"negative_gap\";s:8:\"disabled\";s:20:\"sticky_notifications\";s:1:\"1\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"0\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"1\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"1\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"0\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:0:\"\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:0:\"\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"include\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"1\";s:27:\"counter_visitor_data_source\";s:9:\"fake_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:17:\"discounts_enabled\";s:1:\"0\";s:20:\"show_discounts_table\";s:1:\"0\";s:27:\"checkout_show_product_image\";s:1:\"0\";s:25:\"checkout_product_quantity\";s:1:\"0\";s:22:\"checkout_remove_button\";s:1:\"0\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"one-column\";s:15:\"reviews_columns\";s:1:\"1\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:7:\"style-2\";s:24:\"reviews_enable_pros_cons\";s:1:\"1\";s:20:\"reviews_enable_likes\";s:1:\"1\";s:32:\"show_reviews_purchased_indicator\";s:1:\"1\";s:15:\"reviews_sorting\";s:1:\"1\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"0\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"0\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:20:\"sold_counter_enabled\";s:1:\"0\";s:23:\"sold_counter_sales_type\";s:9:\"real_data\";s:24:\"sold_counter_shown_after\";s:1:\"0\";s:22:\"sold_counter_min_count\";s:2:\"10\";s:22:\"sold_counter_max_count\";s:2:\"20\";s:31:\"sold_counter_hide_on_outofstock\";s:1:\"0\";s:22:\"sold_counter_timeframe\";s:1:\"3\";s:29:\"sold_counter_timeframe_period\";s:7:\"minutes\";s:28:\"sold_counter_transient_hours\";s:2:\"24\";s:8:\"last_tab\";s:18:\"copyrights_section\";}", "yes");
INSERT INTO `wp_options` VALUES("358", "woocommerce_setup_ab_wc_admin_onboarding", "a", "yes");
INSERT INTO `wp_options` VALUES("360", "woocommerce_product_type", "both", "yes");
INSERT INTO `wp_options` VALUES("361", "woocommerce_cheque_settings", "a:1:{s:7:\"enabled\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("362", "woocommerce_bacs_settings", "a:1:{s:7:\"enabled\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("363", "woocommerce_cod_settings", "a:6:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:36:\"پرداخت هنگام دریافت\";s:11:\"description\";s:43:\"پرداخت نقدی پس از تحویل.\";s:12:\"instructions\";s:43:\"پرداخت نقدی پس از تحویل.\";s:18:\"enable_for_methods\";a:0:{}s:18:\"enable_for_virtual\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("375", "whb_default_header", "a:4:{s:4:\"name\";s:21:\"Default header layout\";s:2:\"id\";s:14:\"default_header\";s:9:\"structure\";a:3:{s:2:\"id\";s:4:\"root\";s:4:\"type\";s:4:\"root\";s:7:\"content\";a:3:{i:0;a:4:{s:2:\"id\";s:7:\"top-bar\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:7:\"column5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:3:{i:0;a:3:{s:2:\"id\";s:20:\"skeezdsgge7iogsbjfg9\";s:4:\"type\";s:4:\"text\";s:6:\"params\";a:3:{s:7:\"content\";a:3:{s:2:\"id\";s:7:\"content\";s:5:\"value\";s:46:\"فروشگاه اینترنتی وودمارت\";s:4:\"type\";s:6:\"editor\";}s:6:\"inline\";a:3:{s:2:\"id\";s:6:\"inline\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:1;a:3:{s:2:\"id\";s:20:\"dlxezqgaz9a0do1d9565\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:2:{s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:2;a:3:{s:2:\"id\";s:20:\"lmb8yj2sj6iy2d6pbgkg\";s:4:\"type\";s:4:\"menu\";s:6:\"params\";a:5:{s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:86:\"%d9%86%d9%88%d8%a7%d8%b1-%d8%a8%d8%a7%d9%84%d8%a7%db%8c-%d8%b3%d8%b1%d8%a8%d8%b1%da%af\";s:4:\"type\";s:7:\"options\";}s:10:\"menu_style\";a:3:{s:2:\"id\";s:10:\"menu_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:10:\"menu_align\";a:3:{s:2:\"id\";s:10:\"menu_align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:9:\"items_gap\";a:3:{s:2:\"id\";s:9:\"items_gap\";s:5:\"value\";s:1:\"s\";s:4:\"type\";s:8:\"selector\";}s:6:\"inline\";a:3:{s:2:\"id\";s:6:\"inline\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:1;a:3:{s:2:\"id\";s:7:\"column6\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:7:\"column7\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"61qbocnh2ezx7e7al7jd\";s:4:\"type\";s:6:\"social\";s:6:\"params\";a:7:{s:4:\"type\";a:3:{s:2:\"id\";s:4:\"type\";s:5:\"value\";s:6:\"follow\";s:4:\"type\";s:8:\"selector\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:5:\"align\";a:3:{s:2:\"id\";s:5:\"align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:4:\"size\";a:3:{s:2:\"id\";s:4:\"size\";s:5:\"value\";s:5:\"small\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:4:\"form\";a:3:{s:2:\"id\";s:4:\"form\";s:5:\"value\";s:6:\"circle\";s:4:\"type\";s:8:\"selector\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile1\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"nugd58vqvv5sdr3bc5dd\";s:4:\"type\";s:6:\"social\";s:6:\"params\";a:7:{s:4:\"type\";a:3:{s:2:\"id\";s:4:\"type\";s:5:\"value\";s:5:\"share\";s:4:\"type\";s:8:\"selector\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:5:\"align\";a:3:{s:2:\"id\";s:5:\"align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:4:\"size\";a:3:{s:2:\"id\";s:4:\"size\";s:5:\"value\";s:5:\"small\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:4:\"form\";a:3:{s:2:\"id\";s:4:\"form\";s:5:\"value\";s:6:\"circle\";s:4:\"type\";s:8:\"selector\";}}}}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:35;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";a:1:{s:16:\"background-color\";a:4:{s:1:\"r\";i:255;s:1:\"g\";i:255;s:1:\"b\";i:255;s:1:\"a\";i:1;}}s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:3:{s:5:\"width\";s:1:\"1\";s:5:\"color\";a:4:{s:1:\"r\";i:217;s:1:\"g\";i:217;s:1:\"b\";i:217;s:1:\"a\";i:1;}s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}}s:4:\"type\";s:6:\"border\";}}}i:1;a:4:{s:2:\"id\";s:14:\"general-header\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:6:{i:0;a:3:{s:2:\"id\";s:7:\"column8\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:8:{i:0;a:3:{s:2:\"id\";s:20:\"5u866sftq6yga790jxf3\";s:4:\"type\";s:4:\"cart\";s:6:\"params\";a:4:{s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:1:\"2\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:3:\"bag\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}i:1;a:3:{s:2:\"id\";s:20:\"aj3i3sgmkczq8j5etzrz\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:2:{s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:2;a:3:{s:2:\"id\";s:20:\"i8977fqp1lmve3hyjltf\";s:4:\"type\";s:8:\"wishlist\";s:6:\"params\";a:5:{s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"2\";s:4:\"type\";s:8:\"selector\";}s:18:\"hide_product_count\";a:3:{s:2:\"id\";s:18:\"hide_product_count\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}i:3;a:3:{s:2:\"id\";s:20:\"8ti5hoe2d2yb4yp246za\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:2:{s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:4;a:3:{s:2:\"id\";s:20:\"5ctl6euocj10e0l74hok\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:2:{s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:5;a:3:{s:2:\"id\";s:20:\"vzfll7h67mfeot4u55e0\";s:4:\"type\";s:7:\"compare\";s:6:\"params\";a:5:{s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"2\";s:4:\"type\";s:8:\"selector\";}s:18:\"hide_product_count\";a:3:{s:2:\"id\";s:18:\"hide_product_count\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}i:6;a:3:{s:2:\"id\";s:20:\"2b8mjqhbtvxz16jtxdrd\";s:4:\"type\";s:7:\"account\";s:6:\"params\";a:7:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:13:\"with_username\";a:3:{s:2:\"id\";s:13:\"with_username\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"login_dropdown\";a:3:{s:2:\"id\";s:14:\"login_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"form_display\";a:3:{s:2:\"id\";s:12:\"form_display\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}}}i:7;a:3:{s:2:\"id\";s:20:\"2cc93mk4p68g2ojkml7x\";s:4:\"type\";s:5:\"space\";s:6:\"params\";a:2:{s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}}}i:1;a:3:{s:2:\"id\";s:7:\"column9\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"duljtjrl87kj7pmuut6b\";s:4:\"type\";s:6:\"search\";s:6:\"params\";a:15:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"form\";s:4:\"type\";s:8:\"selector\";}s:19:\"categories_dropdown\";a:3:{s:2:\"id\";s:19:\"categories_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:16:\"popular_requests\";a:3:{s:2:\"id\";s:16:\"popular_requests\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:4:\"ajax\";a:3:{s:2:\"id\";s:4:\"ajax\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:17:\"ajax_result_count\";a:3:{s:2:\"id\";s:17:\"ajax_result_count\";s:5:\"value\";i:10;s:4:\"type\";s:6:\"slider\";}s:9:\"post_type\";a:3:{s:2:\"id\";s:9:\"post_type\";s:5:\"value\";s:7:\"product\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"search_style\";a:3:{s:2:\"id\";s:12:\"search_style\";s:5:\"value\";s:7:\"with-bg\";s:4:\"type\";s:8:\"selector\";}s:10:\"form_color\";a:3:{s:2:\"id\";s:10:\"form_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:22:\"form_placeholder_color\";a:3:{s:2:\"id\";s:22:\"form_placeholder_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"form_brd_color\";a:3:{s:2:\"id\";s:14:\"form_brd_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:20:\"form_brd_color_focus\";a:3:{s:2:\"id\";s:20:\"form_brd_color_focus\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:7:\"form_bg\";a:3:{s:2:\"id\";s:7:\"form_bg\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}}}}}i:2;a:3:{s:2:\"id\";s:8:\"column10\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:2:{i:0;a:3:{s:2:\"id\";s:20:\"xmf0qymf4r5oje3mdv6f\";s:4:\"type\";s:5:\"space\";s:6:\"params\";a:2:{s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:1;a:3:{s:2:\"id\";s:20:\"250rtwdwz5p8e5b7tpw0\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:6:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:214;s:3:\"url\";s:58:\"https://a.maikuta.ir/wp-content/uploads/2020/01/logo-2.png\";s:5:\"width\";i:174;s:6:\"height\";i:36;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:250;s:4:\"type\";s:6:\"slider\";}s:13:\"sticky_notice\";a:3:{s:2:\"id\";s:13:\"sticky_notice\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"notice\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:150;s:4:\"type\";s:6:\"slider\";}s:12:\"width_height\";a:3:{s:2:\"id\";s:12:\"width_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile2\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"wn5z894j1g5n0yp3eeuz\";s:4:\"type\";s:6:\"burger\";s:6:\"params\";a:16:{s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:5:\"right\";s:4:\"type\";s:8:\"selector\";}s:11:\"search_form\";a:3:{s:2:\"id\";s:11:\"search_form\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:9:\"post_type\";a:3:{s:2:\"id\";s:9:\"post_type\";s:5:\"value\";s:7:\"product\";s:4:\"type\";s:8:\"selector\";}s:15:\"categories_menu\";a:3:{s:2:\"id\";s:15:\"categories_menu\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:9:\"tabs_swap\";a:3:{s:2:\"id\";s:9:\"tabs_swap\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:18:\"primary_menu_title\";a:3:{s:2:\"id\";s:18:\"primary_menu_title\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:20:\"secondary_menu_title\";a:3:{s:2:\"id\";s:20:\"secondary_menu_title\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:105:\"%d9%85%d9%86%d9%88%db%8c-%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c-%d8%b9%d9%85%d9%88%d8%af%db%8c\";s:4:\"type\";s:7:\"options\";}s:13:\"show_wishlist\";a:3:{s:2:\"id\";s:13:\"show_wishlist\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"show_compare\";a:3:{s:2:\"id\";s:12:\"show_compare\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"show_account\";a:3:{s:2:\"id\";s:12:\"show_account\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:9:\"close_btn\";a:3:{s:2:\"id\";s:9:\"close_btn\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:4;a:3:{s:2:\"id\";s:14:\"column_mobile3\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"g5z57bkgtznbk6v9pll5\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:6:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:214;s:3:\"url\";s:58:\"https://a.maikuta.ir/wp-content/uploads/2020/01/logo-2.png\";s:5:\"width\";i:174;s:6:\"height\";i:36;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:140;s:4:\"type\";s:6:\"slider\";}s:13:\"sticky_notice\";a:3:{s:2:\"id\";s:13:\"sticky_notice\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"notice\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";a:4:{s:2:\"id\";i:214;s:3:\"url\";s:58:\"https://a.maikuta.ir/wp-content/uploads/2020/01/logo-2.png\";s:5:\"width\";i:174;s:6:\"height\";i:36;}s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:150;s:4:\"type\";s:6:\"slider\";}s:12:\"width_height\";a:3:{s:2:\"id\";s:12:\"width_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:5;a:3:{s:2:\"id\";s:14:\"column_mobile4\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:2:{i:0;a:3:{s:2:\"id\";s:20:\"petgsu6di56mzyzuopqb\";s:4:\"type\";s:7:\"account\";s:6:\"params\";a:7:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:13:\"with_username\";a:3:{s:2:\"id\";s:13:\"with_username\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:14:\"login_dropdown\";a:3:{s:2:\"id\";s:14:\"login_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"form_display\";a:3:{s:2:\"id\";s:12:\"form_display\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}}}i:1;a:3:{s:2:\"id\";s:20:\"u6cx6mzhiof1qeysah9h\";s:4:\"type\";s:4:\"cart\";s:6:\"params\";a:4:{s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:1:\"5\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:3:\"bag\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:90;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:55;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:3:{s:5:\"width\";s:1:\"1\";s:5:\"color\";a:4:{s:1:\"r\";i:129;s:1:\"g\";i:129;s:1:\"b\";i:129;s:1:\"a\";d:0.2;}s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}}s:4:\"type\";s:6:\"border\";}}}i:2;a:4:{s:2:\"id\";s:13:\"header-bottom\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:8:\"column11\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:2:{i:0;a:3:{s:2:\"id\";s:20:\"n75lp1zoots235dih121\";s:4:\"type\";s:10:\"categories\";s:6:\"params\";a:12:{s:16:\"categories_title\";a:3:{s:2:\"id\";s:16:\"categories_title\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:7:\"options\";}s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:105:\"%d9%85%d9%86%d9%88%db%8c-%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c-%d8%b9%d9%85%d9%88%d8%af%db%8c\";s:4:\"type\";s:7:\"options\";}s:15:\"more_cat_button\";a:3:{s:2:\"id\";s:15:\"more_cat_button\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:21:\"more_cat_button_count\";a:3:{s:2:\"id\";s:21:\"more_cat_button_count\";s:5:\"value\";i:6;s:4:\"type\";s:6:\"slider\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:11:\"mouse_event\";a:3:{s:2:\"id\";s:11:\"mouse_event\";s:5:\"value\";s:5:\"hover\";s:4:\"type\";s:8:\"selector\";}s:13:\"open_dropdown\";a:3:{s:2:\"id\";s:13:\"open_dropdown\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";a:1:{s:16:\"background-color\";a:4:{s:1:\"r\";i:255;s:1:\"g\";i:255;s:1:\"b\";i:255;s:1:\"a\";i:1;}}s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"border\";}}}i:1;a:3:{s:2:\"id\";s:20:\"ah9p0q61rqrvvibdgzml\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:2:{s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}}}i:1;a:3:{s:2:\"id\";s:8:\"column12\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"tiueim5f5uazw1f1dm8r\";s:4:\"type\";s:8:\"mainmenu\";s:6:\"params\";a:9:{s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:10:\"menu_style\";a:3:{s:2:\"id\";s:10:\"menu_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:10:\"menu_align\";a:3:{s:2:\"id\";s:10:\"menu_align\";s:5:\"value\";s:5:\"right\";s:4:\"type\";s:8:\"selector\";}s:11:\"full_screen\";a:3:{s:2:\"id\";s:11:\"full_screen\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:9:\"items_gap\";a:3:{s:2:\"id\";s:9:\"items_gap\";s:5:\"value\";s:1:\"s\";s:4:\"type\";s:8:\"selector\";}s:6:\"inline\";a:3:{s:2:\"id\";s:6:\"inline\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:2;a:3:{s:2:\"id\";s:8:\"column13\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"x8vdfqly4j60o5jkmb5e\";s:4:\"type\";s:6:\"button\";s:6:\"params\";a:26:{s:5:\"title\";a:3:{s:2:\"id\";s:5:\"title\";s:5:\"value\";s:26:\"% تخفیف های روز\";s:4:\"type\";s:4:\"text\";}s:4:\"link\";a:3:{s:2:\"id\";s:4:\"link\";s:5:\"value\";a:1:{s:3:\"url\";s:29:\"https://a.maikuta.ir/on-sale/\";}s:4:\"type\";s:4:\"link\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:7:\"primary\";s:4:\"type\";s:8:\"selector\";}s:4:\"size\";a:3:{s:2:\"id\";s:4:\"size\";s:5:\"value\";s:5:\"large\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:5:\"shape\";a:3:{s:2:\"id\";s:5:\"shape\";s:5:\"value\";s:9:\"rectangle\";s:4:\"type\";s:8:\"selector\";}s:12:\"icon_library\";a:3:{s:2:\"id\";s:12:\"icon_library\";s:5:\"value\";s:11:\"fontawesome\";s:4:\"type\";s:7:\"options\";}s:16:\"icon_fontawesome\";a:3:{s:2:\"id\";s:16:\"icon_fontawesome\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:15:\"icon_openiconic\";a:3:{s:2:\"id\";s:15:\"icon_openiconic\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_typicons\";a:3:{s:2:\"id\";s:13:\"icon_typicons\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:11:\"icon_entypo\";a:3:{s:2:\"id\";s:11:\"icon_entypo\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_linecons\";a:3:{s:2:\"id\";s:13:\"icon_linecons\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:15:\"icon_monosocial\";a:3:{s:2:\"id\";s:15:\"icon_monosocial\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_material\";a:3:{s:2:\"id\";s:13:\"icon_material\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_position\";a:3:{s:2:\"id\";s:13:\"icon_position\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:10:\"full_width\";a:3:{s:2:\"id\";s:10:\"full_width\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"button_inline\";a:3:{s:2:\"id\";s:13:\"button_inline\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:5:\"align\";a:3:{s:2:\"id\";s:5:\"align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:20:\"button_smooth_scroll\";a:3:{s:2:\"id\";s:20:\"button_smooth_scroll\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"switcher\";}s:25:\"button_smooth_scroll_time\";a:3:{s:2:\"id\";s:25:\"button_smooth_scroll_time\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:27:\"button_smooth_scroll_offset\";a:3:{s:2:\"id\";s:27:\"button_smooth_scroll_offset\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}s:14:\"bg_color_hover\";a:3:{s:2:\"id\";s:14:\"bg_color_hover\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:18:\"color_scheme_hover\";a:3:{s:2:\"id\";s:18:\"color_scheme_hover\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:3:{s:5:\"width\";s:1:\"1\";s:5:\"color\";a:4:{s:1:\"r\";i:222;s:1:\"g\";i:222;s:1:\"b\";i:222;s:1:\"a\";i:1;}s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}}s:4:\"type\";s:6:\"border\";}}}}}s:8:\"settings\";a:9:{s:7:\"overlap\";a:3:{s:2:\"id\";s:7:\"overlap\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:5:\"boxed\";a:3:{s:2:\"id\";s:5:\"boxed\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"full_width\";a:3:{s:2:\"id\";s:10:\"full_width\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:14:\"dropdowns_dark\";a:3:{s:2:\"id\";s:14:\"dropdowns_dark\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_shadow\";a:3:{s:2:\"id\";s:13:\"sticky_shadow\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"hide_on_scroll\";a:3:{s:2:\"id\";s:14:\"hide_on_scroll\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_effect\";a:3:{s:2:\"id\";s:13:\"sticky_effect\";s:5:\"value\";s:5:\"slide\";s:4:\"type\";s:8:\"selector\";}s:12:\"sticky_clone\";a:3:{s:2:\"id\";s:12:\"sticky_clone\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}}}", "yes");
INSERT INTO `wp_options` VALUES("376", "whb_saved_headers", "a:2:{s:14:\"default_header\";a:2:{s:2:\"id\";s:14:\"default_header\";s:4:\"name\";s:21:\"Default header layout\";}s:13:\"header_246188\";a:2:{s:2:\"id\";s:13:\"header_246188\";s:4:\"name\";s:19:\"سربرگ اصلی\";}}", "yes");
INSERT INTO `wp_options` VALUES("381", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("611", "woodmart_pa_brand_swatch_size", "default", "yes");
INSERT INTO `wp_options` VALUES("612", "woodmart_pa_brand_show_on_product", "", "yes");
INSERT INTO `wp_options` VALUES("819", "widget_mc4wp_form_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("820", "mc4wp_version", "4.10.6", "yes");
INSERT INTO `wp_options` VALUES("821", "mc4wp_flash_messages", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("824", "mc4wp", "a:6:{s:19:\"grecaptcha_site_key\";s:0:\"\";s:21:\"grecaptcha_secret_key\";s:0:\"\";s:7:\"api_key\";s:0:\"\";s:20:\"allow_usage_tracking\";i:0;s:15:\"debug_log_level\";s:7:\"warning\";s:18:\"first_activated_on\";i:1580151499;}", "yes");
INSERT INTO `wp_options` VALUES("825", "mc4wp_default_form_id", "68", "yes");
INSERT INTO `wp_options` VALUES("827", "mc4wp_form_stylesheets", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1124", "revslider_update_revision_current", "6.7.24", "yes");
INSERT INTO `wp_options` VALUES("1213", "woodmart-vc-imported-media", "a:1:{i:146;s:90:\"http://dummy.xtemos.com/woodmart/demos/wp-content/uploads/sites/2/2018/09/cars-video-4.jpg\";}", "yes");
INSERT INTO `wp_options` VALUES("1271", "woocommerce_default_catalog_orderby", "date", "yes");
INSERT INTO `wp_options` VALUES("1272", "woocommerce_maybe_regenerate_images_hash", "28dc1b60493fb1f45b4d923c242c6423", "yes");
INSERT INTO `wp_options` VALUES("1388", "woodmart_import_attributes", "1", "yes");
INSERT INTO `wp_options` VALUES("1400", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.1.1\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1755921386;s:7:\"version\";s:5:\"6.1.1\";s:11:\"count_valid\";i:0;s:13:\"count_invalid\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("1442", "woodmart_pa_color_swatch_size", "default", "yes");
INSERT INTO `wp_options` VALUES("1443", "woodmart_pa_color_show_on_product", "", "yes");
INSERT INTO `wp_options` VALUES("1600", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1944", "new_admin_email", "amirhossein.mashayekh8@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("2022", "woodmart_purchase_code", "valid", "yes");
INSERT INTO `wp_options` VALUES("2027", "woodmart-update-time", "1756499015", "yes");
INSERT INTO `wp_options` VALUES("2028", "woodmart-update-info", "O:8:\"stdClass\":6:{s:11:\"new_version\";s:5:\"8.2.7\";s:7:\"version\";s:5:\"8.2.7\";s:5:\"theme\";s:8:\"woodmart\";s:7:\"checked\";i:1756499015;s:3:\"url\";s:41:\"https://xtemos.com/woodmart-changelog.php\";s:7:\"package\";s:65:\"https://xtemos.com/wp-json/xts/v1/download?token=1&theme=woodmart\";}", "yes");
INSERT INTO `wp_options` VALUES("2063", "rs_image_meta_todo", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2174", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("2186", "action_scheduler_hybrid_store_demarkation", "267", "yes");
INSERT INTO `wp_options` VALUES("2187", "schema-ActionScheduler_StoreSchema", "8.0.1755893574", "yes");
INSERT INTO `wp_options` VALUES("2188", "schema-ActionScheduler_LoggerSchema", "3.0.1634459924", "yes");
INSERT INTO `wp_options` VALUES("2189", "woocommerce_onboarding_opt_in", "no", "yes");
INSERT INTO `wp_options` VALUES("2192", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_options` VALUES("2194", "woocommerce_onboarding_profile", "a:1:{s:9:\"completed\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("2199", "woocommerce_admin_install_timestamp", "1587485430", "yes");
INSERT INTO `wp_options` VALUES("2204", "action_scheduler_lock_async-request-runner", "68b3cd207e3606.07769673|1756613980", "yes");
INSERT INTO `wp_options` VALUES("2210", "woocommerce_admin_last_orders_milestone", "1", "yes");
INSERT INTO `wp_options` VALUES("2217", "recovery_mode_email_last_sent", "1686032499", "yes");
INSERT INTO `wp_options` VALUES("2240", "xts-default_header-site-url", "105934ba3e148e8bb5909100634c7e87", "yes");
INSERT INTO `wp_options` VALUES("2241", "xts-theme_settings_default-site-url", "f11f149e07f02735d6a64376a98e41a4", "yes");
INSERT INTO `wp_options` VALUES("2421", "revslider-additions", "O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-a.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("2422", "rs-templates-counter", "0", "off");
INSERT INTO `wp_options` VALUES("2466", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:19:\"mj.masoud@yahoo.com\";s:7:\"version\";s:5:\"6.4.6\";s:9:\"timestamp\";i:1755893118;}", "no");
INSERT INTO `wp_options` VALUES("2481", "widget_wd-widget-stock-status", "a:2:{i:2;a:3:{s:5:\"title\";s:35:\"فیلتر موجودی و حراج\";s:7:\"instock\";s:1:\"1\";s:6:\"onsale\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("2484", "woocommerce_schema_version", "920", "yes");
INSERT INTO `wp_options` VALUES("2499", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("2582", "elementor_version", "3.31.2", "yes");
INSERT INTO `wp_options` VALUES("2584", "_elementor_installed_time", "1594736256", "yes");
INSERT INTO `wp_options` VALUES("2585", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "no");
INSERT INTO `wp_options` VALUES("2586", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:100:\"Introducing Elementor 3.30: new Editor V4 capabilities, full Website Templates in the cloud, & more!\";s:7:\"excerpt\";s:361:\"Elementor 3.30 is here and it includes upgrades that accelerate your workflow, bring you a step closer to the full power of Editor V4, and help you deliver beautiful, accessible websites faster than ever. From advanced styling tools and smarter editing to full Website Templates in the cloud, this release enhances both the way you design and the way you scale.\";s:7:\"created\";i:1751974442;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-330-v4-alpha-website-templates/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "no");
INSERT INTO `wp_options` VALUES("2594", "elementor_active_kit", "269", "yes");
INSERT INTO `wp_options` VALUES("2618", "elementor_unfiltered_files_upload", "1", "yes");
INSERT INTO `wp_options` VALUES("2645", "_elementor_general_settings", "a:3:{s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:21:\"global_image_lightbox\";s:3:\"yes\";s:15:\"container_width\";s:4:\"1600\";}", "yes");
INSERT INTO `wp_options` VALUES("2646", "_elementor_settings_update_time", "1647071255", "yes");
INSERT INTO `wp_options` VALUES("2647", "elementor_cpt_support", "a:6:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:9:\"cms_block\";i:3;s:9:\"portfolio\";i:4;s:7:\"product\";i:5;s:15:\"woodmart_layout\";}", "yes");
INSERT INTO `wp_options` VALUES("2648", "elementor_disable_color_schemes", "yes", "yes");
INSERT INTO `wp_options` VALUES("2649", "elementor_disable_typography_schemes", "yes", "yes");
INSERT INTO `wp_options` VALUES("2650", "elementor_allow_tracking", "no", "yes");
INSERT INTO `wp_options` VALUES("2651", "elementor_default_generic_fonts", "Sans-serif", "yes");
INSERT INTO `wp_options` VALUES("2652", "elementor_container_width", "1600", "yes");
INSERT INTO `wp_options` VALUES("2653", "elementor_space_between_widgets", "", "yes");
INSERT INTO `wp_options` VALUES("2654", "elementor_stretched_section_container", "", "yes");
INSERT INTO `wp_options` VALUES("2655", "elementor_page_title_selector", "", "yes");
INSERT INTO `wp_options` VALUES("2656", "elementor_viewport_lg", "", "yes");
INSERT INTO `wp_options` VALUES("2658", "elementor_viewport_md", "", "yes");
INSERT INTO `wp_options` VALUES("2659", "elementor_global_image_lightbox", "yes", "yes");
INSERT INTO `wp_options` VALUES("2660", "elementor_css_print_method", "external", "yes");
INSERT INTO `wp_options` VALUES("2661", "elementor_editor_break_lines", "", "yes");
INSERT INTO `wp_options` VALUES("2662", "elementor_load_fa4_shim", "", "yes");
INSERT INTO `wp_options` VALUES("2776", "wpp_settings", "a:6:{s:12:\"submenu_move\";s:6:\"enable\";s:12:\"persian_date\";s:6:\"enable\";s:10:\"conv_dates\";s:6:\"enable\";s:11:\"news_source\";s:5:\"parsi\";s:16:\"months_name_type\";s:7:\"persian\";s:17:\"date_in_admin_bar\";s:6:\"enable\";}", "yes");
INSERT INTO `wp_options` VALUES("2777", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("2778", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("2781", "duplicator_new_storage_position", "1", "yes");
INSERT INTO `wp_options` VALUES("2878", "elementor_tracker_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("3065", "xts-header_246188-css-data", ":root{\n	--wd-top-bar-h: .00001px;\n	--wd-top-bar-sm-h: .00001px;\n	--wd-top-bar-sticky-h: .00001px;\n	--wd-top-bar-brd-w: .00001px;\n\n	--wd-header-general-h: 90px;\n	--wd-header-general-sm-h: 60px;\n	--wd-header-general-sticky-h: 55px;\n	--wd-header-general-brd-w: 1px;\n\n	--wd-header-bottom-h: 50px;\n	--wd-header-bottom-sm-h: .00001px;\n	--wd-header-bottom-sticky-h: 50px;\n	--wd-header-bottom-brd-w: 1px;\n\n	--wd-header-clone-h: .00001px;\n\n	--wd-header-brd-w: calc(var(--wd-top-bar-brd-w) + var(--wd-header-general-brd-w) + var(--wd-header-bottom-brd-w));\n	--wd-header-h: calc(var(--wd-top-bar-h) + var(--wd-header-general-h) + var(--wd-header-bottom-h) + var(--wd-header-brd-w));\n	--wd-header-sticky-h: calc(var(--wd-top-bar-sticky-h) + var(--wd-header-general-sticky-h) + var(--wd-header-bottom-sticky-h) + var(--wd-header-clone-h) + var(--wd-header-brd-w));\n	--wd-header-sm-h: calc(var(--wd-top-bar-sm-h) + var(--wd-header-general-sm-h) + var(--wd-header-bottom-sm-h) + var(--wd-header-brd-w));\n}\n\n\n.whb-sticked .whb-general-header .wd-dropdown:not(.sub-sub-menu) {\n	margin-top: 7.5px;\n}\n\n.whb-sticked .whb-general-header .wd-dropdown:not(.sub-sub-menu):after {\n	height: 17.5px;\n}\n\n:root:has(.whb-top-bar.whb-border-boxed) {\n	--wd-top-bar-brd-w: .00001px;\n}\n\n@media (max-width: 1024px) {\n:root:has(.whb-top-bar.whb-hidden-mobile) {\n	--wd-top-bar-brd-w: .00001px;\n}\n}\n\n:root:has(.whb-general-header.whb-border-boxed) {\n	--wd-header-general-brd-w: .00001px;\n}\n\n@media (max-width: 1024px) {\n:root:has(.whb-general-header.whb-hidden-mobile) {\n	--wd-header-general-brd-w: .00001px;\n}\n}\n\n:root:has(.whb-header-bottom.whb-border-boxed) {\n	--wd-header-bottom-brd-w: .00001px;\n}\n\n@media (max-width: 1024px) {\n:root:has(.whb-header-bottom.whb-hidden-mobile) {\n	--wd-header-bottom-brd-w: .00001px;\n}\n}\n\n.whb-header-bottom .wd-dropdown {\n	margin-top: 5px;\n}\n\n.whb-header-bottom .wd-dropdown:after {\n	height: 15px;\n}\n\n.whb-sticked .whb-header-bottom .wd-dropdown:not(.sub-sub-menu) {\n	margin-top: 5px;\n}\n\n.whb-sticked .whb-header-bottom .wd-dropdown:not(.sub-sub-menu):after {\n	height: 15px;\n}\n\n\n		\n.whb-top-bar {\n	background-color: rgba(255, 255, 255, 1);border-color: rgba(217, 217, 217, 1);border-bottom-width: 1px;border-bottom-style: solid;\n}\n\n.whb-general-header {\n	border-color: rgba(129, 129, 129, 0.2);border-bottom-width: 1px;border-bottom-style: solid;\n}\n\n.whb-74x7eaf1aa6cs4cu8fb9 a:is(.btn-style-default, .btn-style-3d) {\n	background-color: rgba(65, 117, 5, 1);\n}\n.whb-74x7eaf1aa6cs4cu8fb9 a:is(.btn-style-bordered, .btn-style-link) {\n	border-color: rgba(65, 117, 5, 1);\n}\n.whb-header-bottom {\n	border-color: rgba(222, 222, 222, 1);border-bottom-width: 1px;border-bottom-style: solid;\n}\n", "on");
INSERT INTO `wp_options` VALUES("3066", "xts-header_246188-status", "valid", "yes");
INSERT INTO `wp_options` VALUES("3067", "xts-header_246188-version", "8.2.7.1", "on");
INSERT INTO `wp_options` VALUES("3068", "xts-header_246188-site-url", "f11f149e07f02735d6a64376a98e41a4", "yes");
INSERT INTO `wp_options` VALUES("3069", "whb_header_246188", "a:4:{s:4:\"name\";s:19:\"سربرگ اصلی\";s:2:\"id\";s:13:\"header_246188\";s:9:\"structure\";a:3:{s:2:\"id\";s:4:\"root\";s:4:\"type\";s:4:\"root\";s:7:\"content\";a:3:{i:0;a:4:{s:2:\"id\";s:7:\"top-bar\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:7:\"column5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:3:{i:0;a:3:{s:2:\"id\";s:20:\"skeezdsgge7iogsbjfg9\";s:4:\"type\";s:4:\"text\";s:6:\"params\";a:3:{s:7:\"content\";a:3:{s:2:\"id\";s:7:\"content\";s:5:\"value\";s:46:\"فروشگاه اینترنتی وودمارت\";s:4:\"type\";s:6:\"editor\";}s:6:\"inline\";a:3:{s:2:\"id\";s:6:\"inline\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:1;a:3:{s:2:\"id\";s:20:\"dlxezqgaz9a0do1d9565\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:3:{s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:2;a:3:{s:2:\"id\";s:20:\"lmb8yj2sj6iy2d6pbgkg\";s:4:\"type\";s:4:\"menu\";s:6:\"params\";a:8:{s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:86:\"%d9%86%d9%88%d8%a7%d8%b1-%d8%a8%d8%a7%d9%84%d8%a7%db%8c-%d8%b3%d8%b1%d8%a8%d8%b1%da%af\";s:4:\"type\";s:7:\"options\";}s:10:\"menu_style\";a:3:{s:2:\"id\";s:10:\"menu_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:10:\"menu_align\";a:3:{s:2:\"id\";s:10:\"menu_align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:9:\"items_gap\";a:3:{s:2:\"id\";s:9:\"items_gap\";s:5:\"value\";s:1:\"s\";s:4:\"type\";s:8:\"selector\";}s:10:\"icon_width\";a:3:{s:2:\"id\";s:10:\"icon_width\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"slider\";}s:11:\"icon_height\";a:3:{s:2:\"id\";s:11:\"icon_height\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"slider\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"inline\";a:3:{s:2:\"id\";s:6:\"inline\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:1;a:3:{s:2:\"id\";s:7:\"column6\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:7:\"column7\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"61qbocnh2ezx7e7al7jd\";s:4:\"type\";s:6:\"social\";s:6:\"params\";a:6:{s:4:\"type\";a:3:{s:2:\"id\";s:4:\"type\";s:5:\"value\";s:6:\"follow\";s:4:\"type\";s:8:\"selector\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:4:\"form\";a:3:{s:2:\"id\";s:4:\"form\";s:5:\"value\";s:6:\"circle\";s:4:\"type\";s:8:\"selector\";}s:4:\"size\";a:3:{s:2:\"id\";s:4:\"size\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile1\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"nugd58vqvv5sdr3bc5dd\";s:4:\"type\";s:6:\"social\";s:6:\"params\";a:6:{s:4:\"type\";a:3:{s:2:\"id\";s:4:\"type\";s:5:\"value\";s:5:\"share\";s:4:\"type\";s:8:\"selector\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:4:\"form\";a:3:{s:2:\"id\";s:4:\"form\";s:5:\"value\";s:6:\"circle\";s:4:\"type\";s:8:\"selector\";}s:4:\"size\";a:3:{s:2:\"id\";s:4:\"size\";s:5:\"value\";s:5:\"small\";s:4:\"type\";s:7:\"options\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}}}}}}s:6:\"params\";a:12:{s:11:\"row_columns\";a:3:{s:2:\"id\";s:11:\"row_columns\";s:5:\"value\";s:1:\"3\";s:4:\"type\";s:8:\"selector\";}s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:35;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";a:1:{s:16:\"background-color\";a:4:{s:1:\"r\";i:255;s:1:\"g\";i:255;s:1:\"b\";i:255;s:1:\"a\";i:1;}}s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:3:{s:5:\"width\";s:1:\"1\";s:5:\"color\";a:4:{s:1:\"r\";i:217;s:1:\"g\";i:217;s:1:\"b\";i:217;s:1:\"a\";i:1;}s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}}s:4:\"type\";s:6:\"border\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}}}i:1;a:4:{s:2:\"id\";s:14:\"general-header\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:6:{i:0;a:3:{s:2:\"id\";s:7:\"column8\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:2:{i:0;a:3:{s:2:\"id\";s:20:\"250rtwdwz5p8e5b7tpw0\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:6:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:779;s:3:\"url\";s:56:\"https://a.maikuta.ir/wp-content/uploads/2025/08/logo.png\";s:5:\"width\";i:194;s:6:\"height\";i:64;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:250;s:4:\"type\";s:6:\"slider\";}s:13:\"sticky_notice\";a:3:{s:2:\"id\";s:13:\"sticky_notice\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"notice\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:150;s:4:\"type\";s:6:\"slider\";}s:12:\"width_height\";a:3:{s:2:\"id\";s:12:\"width_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}i:1;a:3:{s:2:\"id\";s:20:\"kywkv7op3whzar37jii4\";s:4:\"type\";s:5:\"space\";s:6:\"params\";a:2:{s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:85;s:4:\"type\";s:6:\"slider\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}}}i:1;a:3:{s:2:\"id\";s:7:\"column9\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"duljtjrl87kj7pmuut6b\";s:4:\"type\";s:6:\"search\";s:6:\"params\";a:34:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"form\";s:4:\"type\";s:8:\"selector\";}s:16:\"popular_requests\";a:3:{s:2:\"id\";s:16:\"popular_requests\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:22:\"search_history_enabled\";a:3:{s:2:\"id\";s:22:\"search_history_enabled\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:28:\"search_extra_content_enabled\";a:3:{s:2:\"id\";s:28:\"search_extra_content_enabled\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:20:\"search_extra_content\";a:3:{s:2:\"id\";s:20:\"search_extra_content\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:19:\"categories_dropdown\";a:3:{s:2:\"id\";s:19:\"categories_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:18:\"cat_selector_style\";a:3:{s:2:\"id\";s:18:\"cat_selector_style\";s:5:\"value\";s:8:\"bordered\";s:4:\"type\";s:8:\"selector\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:4:\"ajax\";a:3:{s:2:\"id\";s:4:\"ajax\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:17:\"ajax_result_count\";a:3:{s:2:\"id\";s:17:\"ajax_result_count\";s:5:\"value\";i:10;s:4:\"type\";s:6:\"slider\";}s:9:\"post_type\";a:3:{s:2:\"id\";s:9:\"post_type\";s:5:\"value\";s:7:\"product\";s:4:\"type\";s:8:\"selector\";}s:18:\"include_cat_search\";a:3:{s:2:\"id\";s:18:\"include_cat_search\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:12:\"search_style\";a:3:{s:2:\"id\";s:12:\"search_style\";s:5:\"value\";s:7:\"with-bg\";s:4:\"type\";s:8:\"selector\";}s:10:\"form_shape\";a:3:{s:2:\"id\";s:10:\"form_shape\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:11:\"form_height\";a:3:{s:2:\"id\";s:11:\"form_height\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"slider\";}s:10:\"form_color\";a:3:{s:2:\"id\";s:10:\"form_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:22:\"form_placeholder_color\";a:3:{s:2:\"id\";s:22:\"form_placeholder_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"form_brd_color\";a:3:{s:2:\"id\";s:14:\"form_brd_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:20:\"form_brd_color_focus\";a:3:{s:2:\"id\";s:20:\"form_brd_color_focus\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:7:\"form_bg\";a:3:{s:2:\"id\";s:7:\"form_bg\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:17:\"custom_icon_width\";a:3:{s:2:\"id\";s:17:\"custom_icon_width\";s:5:\"value\";i:0;s:4:\"type\";s:6:\"slider\";}}}}}i:2;a:3:{s:2:\"id\";s:8:\"column10\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:20:\"2b8mjqhbtvxz16jtxdrd\";s:4:\"type\";s:7:\"account\";s:6:\"params\";a:18:{s:13:\"with_username\";a:3:{s:2:\"id\";s:13:\"with_username\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"login_dropdown\";a:3:{s:2:\"id\";s:14:\"login_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"form_display\";a:3:{s:2:\"id\";s:12:\"form_display\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:17:\"custom_icon_width\";a:3:{s:2:\"id\";s:17:\"custom_icon_width\";s:5:\"value\";i:0;s:4:\"type\";s:6:\"slider\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}}}i:1;a:3:{s:2:\"id\";s:20:\"8ti5hoe2d2yb4yp246za\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:3:{s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:2;a:3:{s:2:\"id\";s:20:\"b18f5juogaze4p3bca1w\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:3:{s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:3;a:3:{s:2:\"id\";s:20:\"5u866sftq6yga790jxf3\";s:4:\"type\";s:4:\"cart\";s:6:\"params\";a:16:{s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:1:\"8\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:3:\"bag\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:17:\"custom_icon_width\";a:3:{s:2:\"id\";s:17:\"custom_icon_width\";s:5:\"value\";i:0;s:4:\"type\";s:6:\"slider\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile2\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"wn5z894j1g5n0yp3eeuz\";s:4:\"type\";s:6:\"burger\";s:6:\"params\";a:41:{s:9:\"close_btn\";a:3:{s:2:\"id\";s:9:\"close_btn\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"show_wishlist\";a:3:{s:2:\"id\";s:13:\"show_wishlist\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"show_compare\";a:3:{s:2:\"id\";s:12:\"show_compare\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"show_account\";a:3:{s:2:\"id\";s:12:\"show_account\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:15:\"show_html_block\";a:3:{s:2:\"id\";s:15:\"show_html_block\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"languages\";a:3:{s:2:\"id\";s:9:\"languages\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:18:\"show_language_flag\";a:3:{s:2:\"id\";s:18:\"show_language_flag\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:11:\"search_form\";a:3:{s:2:\"id\";s:11:\"search_form\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:16:\"popular_requests\";a:3:{s:2:\"id\";s:16:\"popular_requests\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:22:\"search_history_enabled\";a:3:{s:2:\"id\";s:22:\"search_history_enabled\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:28:\"search_extra_content_enabled\";a:3:{s:2:\"id\";s:28:\"search_extra_content_enabled\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:20:\"search_extra_content\";a:3:{s:2:\"id\";s:20:\"search_extra_content\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:4:\"ajax\";a:3:{s:2:\"id\";s:4:\"ajax\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:17:\"ajax_result_count\";a:3:{s:2:\"id\";s:17:\"ajax_result_count\";s:5:\"value\";i:20;s:4:\"type\";s:6:\"slider\";}s:9:\"post_type\";a:3:{s:2:\"id\";s:9:\"post_type\";s:5:\"value\";s:7:\"product\";s:4:\"type\";s:8:\"selector\";}s:18:\"include_cat_search\";a:3:{s:2:\"id\";s:18:\"include_cat_search\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:15:\"categories_menu\";a:3:{s:2:\"id\";s:15:\"categories_menu\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:18:\"primary_menu_title\";a:3:{s:2:\"id\";s:18:\"primary_menu_title\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:20:\"secondary_menu_title\";a:3:{s:2:\"id\";s:20:\"secondary_menu_title\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:49:\"%d9%85%d9%86%d9%88%db%8c-%d8%a7%d8%b5%d9%84%db%8c\";s:4:\"type\";s:7:\"options\";}s:9:\"tabs_swap\";a:3:{s:2:\"id\";s:9:\"tabs_swap\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"menu_layout\";a:3:{s:2:\"id\";s:11:\"menu_layout\";s:5:\"value\";s:8:\"dropdown\";s:4:\"type\";s:8:\"selector\";}s:19:\"drilldown_animation\";a:3:{s:2:\"id\";s:19:\"drilldown_animation\";s:5:\"value\";s:5:\"slide\";s:4:\"type\";s:8:\"selector\";}s:22:\"submenu_opening_action\";a:3:{s:2:\"id\";s:22:\"submenu_opening_action\";s:5:\"value\";s:10:\"only_arrow\";s:4:\"type\";s:8:\"selector\";}s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:5:\"right\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:17:\"custom_icon_width\";a:3:{s:2:\"id\";s:17:\"custom_icon_width\";s:5:\"value\";i:0;s:4:\"type\";s:6:\"slider\";}s:10:\"icon_width\";a:3:{s:2:\"id\";s:10:\"icon_width\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"slider\";}s:11:\"icon_height\";a:3:{s:2:\"id\";s:11:\"icon_height\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"slider\";}}}}}i:4;a:3:{s:2:\"id\";s:14:\"column_mobile3\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"g5z57bkgtznbk6v9pll5\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:6:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:779;s:3:\"url\";s:56:\"https://a.maikuta.ir/wp-content/uploads/2025/08/logo.png\";s:5:\"width\";i:194;s:6:\"height\";i:64;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:140;s:4:\"type\";s:6:\"slider\";}s:13:\"sticky_notice\";a:3:{s:2:\"id\";s:13:\"sticky_notice\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"notice\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";b:0;s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:150;s:4:\"type\";s:6:\"slider\";}s:12:\"width_height\";a:3:{s:2:\"id\";s:12:\"width_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:5;a:3:{s:2:\"id\";s:14:\"column_mobile4\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"u6cx6mzhiof1qeysah9h\";s:4:\"type\";s:4:\"cart\";s:6:\"params\";a:16:{s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:1:\"5\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:3:\"bag\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:17:\"custom_icon_width\";a:3:{s:2:\"id\";s:17:\"custom_icon_width\";s:5:\"value\";i:0;s:4:\"type\";s:6:\"slider\";}}}}}}s:6:\"params\";a:12:{s:11:\"row_columns\";a:3:{s:2:\"id\";s:11:\"row_columns\";s:5:\"value\";s:1:\"3\";s:4:\"type\";s:8:\"selector\";}s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:90;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:55;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:3:{s:5:\"width\";s:1:\"1\";s:5:\"color\";a:4:{s:1:\"r\";i:129;s:1:\"g\";i:129;s:1:\"b\";i:129;s:1:\"a\";d:0.200000000000000011102230246251565404236316680908203125;}s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}}s:4:\"type\";s:6:\"border\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}i:2;a:4:{s:2:\"id\";s:13:\"header-bottom\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:8:\"column11\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:1;a:3:{s:2:\"id\";s:8:\"column12\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"tiueim5f5uazw1f1dm8r\";s:4:\"type\";s:8:\"mainmenu\";s:6:\"params\";a:23:{s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:6:\"header\";s:4:\"type\";s:7:\"options\";}s:11:\"full_screen\";a:3:{s:2:\"id\";s:11:\"full_screen\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:17:\"custom_icon_width\";a:3:{s:2:\"id\";s:17:\"custom_icon_width\";s:5:\"value\";i:0;s:4:\"type\";s:6:\"slider\";}s:10:\"menu_style\";a:3:{s:2:\"id\";s:10:\"menu_style\";s:5:\"value\";s:9:\"underline\";s:4:\"type\";s:8:\"selector\";}s:10:\"menu_align\";a:3:{s:2:\"id\";s:10:\"menu_align\";s:5:\"value\";s:6:\"center\";s:4:\"type\";s:8:\"selector\";}s:9:\"items_gap\";a:3:{s:2:\"id\";s:9:\"items_gap\";s:5:\"value\";s:1:\"m\";s:4:\"type\";s:8:\"selector\";}s:10:\"icon_width\";a:3:{s:2:\"id\";s:10:\"icon_width\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"slider\";}s:11:\"icon_height\";a:3:{s:2:\"id\";s:11:\"icon_height\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"slider\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:6:\"inline\";a:3:{s:2:\"id\";s:6:\"inline\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:2;a:3:{s:2:\"id\";s:8:\"column13\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"74x7eaf1aa6cs4cu8fb9\";s:4:\"type\";s:6:\"button\";s:6:\"params\";a:28:{s:5:\"title\";a:3:{s:2:\"id\";s:5:\"title\";s:5:\"value\";s:25:\"مشاوره آنلاین\";s:4:\"type\";s:4:\"text\";}s:4:\"link\";a:3:{s:2:\"id\";s:4:\"link\";s:5:\"value\";a:1:{s:3:\"url\";s:36:\"https://wa.me/message/MSHBIPSJCX7PB1\";}s:4:\"type\";s:4:\"link\";}s:20:\"button_smooth_scroll\";a:3:{s:2:\"id\";s:20:\"button_smooth_scroll\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:25:\"button_smooth_scroll_time\";a:3:{s:2:\"id\";s:25:\"button_smooth_scroll_time\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:27:\"button_smooth_scroll_offset\";a:3:{s:2:\"id\";s:27:\"button_smooth_scroll_offset\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:5:\"shape\";a:3:{s:2:\"id\";s:5:\"shape\";s:5:\"value\";s:9:\"rectangle\";s:4:\"type\";s:8:\"selector\";}s:4:\"size\";a:3:{s:2:\"id\";s:4:\"size\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:7:\"options\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:7:\"options\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";a:4:{s:1:\"r\";i:65;s:1:\"g\";i:117;s:1:\"b\";i:5;s:1:\"a\";i:1;}s:4:\"type\";s:5:\"color\";}s:14:\"bg_color_hover\";a:3:{s:2:\"id\";s:14:\"bg_color_hover\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}s:19:\"custom_color_scheme\";a:3:{s:2:\"id\";s:19:\"custom_color_scheme\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:20:\"color_scheme_divider\";a:3:{s:2:\"id\";s:20:\"color_scheme_divider\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"divider\";}s:18:\"color_scheme_hover\";a:3:{s:2:\"id\";s:18:\"color_scheme_hover\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}s:25:\"custom_color_scheme_hover\";a:3:{s:2:\"id\";s:25:\"custom_color_scheme_hover\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:12:\"icon_library\";a:3:{s:2:\"id\";s:12:\"icon_library\";s:5:\"value\";s:11:\"fontawesome\";s:4:\"type\";s:7:\"options\";}s:16:\"icon_fontawesome\";a:3:{s:2:\"id\";s:16:\"icon_fontawesome\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:15:\"icon_openiconic\";a:3:{s:2:\"id\";s:15:\"icon_openiconic\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_typicons\";a:3:{s:2:\"id\";s:13:\"icon_typicons\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:11:\"icon_entypo\";a:3:{s:2:\"id\";s:11:\"icon_entypo\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_linecons\";a:3:{s:2:\"id\";s:13:\"icon_linecons\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:15:\"icon_monosocial\";a:3:{s:2:\"id\";s:15:\"icon_monosocial\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_material\";a:3:{s:2:\"id\";s:13:\"icon_material\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:8:\"img_size\";a:3:{s:2:\"id\";s:8:\"img_size\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_position\";a:3:{s:2:\"id\";s:13:\"icon_position\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:12:{s:11:\"row_columns\";a:3:{s:2:\"id\";s:11:\"row_columns\";s:5:\"value\";s:1:\"3\";s:4:\"type\";s:8:\"selector\";}s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:3:{s:5:\"width\";s:1:\"1\";s:5:\"color\";a:4:{s:1:\"r\";i:222;s:1:\"g\";i:222;s:1:\"b\";i:222;s:1:\"a\";i:1;}s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}}s:4:\"type\";s:6:\"border\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}s:8:\"settings\";a:9:{s:7:\"overlap\";a:3:{s:2:\"id\";s:7:\"overlap\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:5:\"boxed\";a:3:{s:2:\"id\";s:5:\"boxed\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"full_width\";a:3:{s:2:\"id\";s:10:\"full_width\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:14:\"dropdowns_dark\";a:3:{s:2:\"id\";s:14:\"dropdowns_dark\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_shadow\";a:3:{s:2:\"id\";s:13:\"sticky_shadow\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"hide_on_scroll\";a:3:{s:2:\"id\";s:14:\"hide_on_scroll\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_effect\";a:3:{s:2:\"id\";s:13:\"sticky_effect\";s:5:\"value\";s:5:\"slide\";s:4:\"type\";s:8:\"selector\";}s:12:\"sticky_clone\";a:3:{s:2:\"id\";s:12:\"sticky_clone\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}}}", "on");
INSERT INTO `wp_options` VALUES("3071", "whb_main_header", "header_246188", "yes");
INSERT INTO `wp_options` VALUES("3293", "elementor_log", "a:42:{s:32:\"4b18aeebf4659dfc6afee2159cfef004\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-04-27 07:57:41\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-04-27 07:57:41\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"e9e138460c2cca40a3c7d7698a36c89a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-04-27 07:57:41\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-04-27 07:57:41\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"1b9b4e0e905e486d159fa6df4a3dcf30\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-04-27 07:57:41\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-04-27 07:57:41\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"407cb4f9a6d49d1da564db59a9417c44\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-04-27 07:57:41\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.5\";s:2:\"to\";s:6:\"3.12.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-04-27 07:57:41\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.5\";s:2:\"to\";s:6:\"3.12.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"bcbf5027777b6e18454da71abbee2b8d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-06 06:29:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-06 06:29:00\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"cac34d80d67167a58594a1070bd3c55c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-06 06:29:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-06 06:29:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"a0a77a9f13bd952ccdd36558bc3a9909\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-06 06:29:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-06 06:29:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"57fcf6e2930ae4e933dfeb4bc888a2ef\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-06 06:29:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-06 06:29:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"feb989175e01232ee30debdf2faaaf16\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-06 06:29:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-06 06:29:00\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"316a2e578f766e06e73bd89e95cd77bc\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-06-06 06:29:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-06-06 06:29:02\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"c6a077c2c9b9e30b944edbef4d995121\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-08-02 18:07:38\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-08-02 18:07:38\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"7916123523f42b8aa3d2bfc0dfb2a0a5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-08-02 18:07:38\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-08-02 18:07:38\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"46a102169977627adf05d0682e0ee829\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-08-02 18:07:38\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-08-02 18:07:38\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"00fedd7a3a0cae16de335f3943afae30\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-08-02 18:07:38\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.13.4\";s:2:\"to\";s:6:\"3.15.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-08-02 18:07:38\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.13.4\";s:2:\"to\";s:6:\"3.15.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"c8563599c49bdbbda639e9a40276848e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-13 19:11:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.15.1\";s:2:\"to\";s:6:\"3.16.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-13 19:11:45\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.15.1\";s:2:\"to\";s:6:\"3.16.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"d3005c256988bff06961e43ea1a17427\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-13 19:11:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-13 19:11:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"43105fc52b4a718e36025af44aade7a5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-13 19:11:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-13 19:11:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"5fa4d3cf88c585c1b4fd5b315cb2386c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-13 19:11:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-13 19:11:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"8eb532208571ed178521140dd88235ff\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-13 19:11:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:60:\"المنتور/Upgrades - _v_3_16_0_container_updates Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-13 19:11:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:60:\"المنتور/Upgrades - _v_3_16_0_container_updates Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"ecfd9977dfe7652ef7daeed0da7e7295\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-13 19:11:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:62:\"المنتور/Upgrades - _v_3_16_0_container_updates Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-13 19:11:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:62:\"المنتور/Upgrades - _v_3_16_0_container_updates Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"9a3f7e6097b6f0cda2ae46a2eb3516fd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-13 19:11:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:64:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-13 19:11:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:64:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"4cb8dffc844e066f349cd9605516f515\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-13 19:11:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:66:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-13 19:11:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:66:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"21d762bca0f5a517ff9ae38f882508c2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-13 19:11:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.15.1\";s:2:\"to\";s:6:\"3.16.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-13 19:11:47\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.15.1\";s:2:\"to\";s:6:\"3.16.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"e6033f2d21a8af29e32de6391c0a50aa\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-11-27 05:49:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.16.5\";s:2:\"to\";s:6:\"3.17.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-11-27 05:49:25\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.16.5\";s:2:\"to\";s:6:\"3.17.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ef80a56dfa432e9f92b4f501489b6957\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-11-27 05:49:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-11-27 05:49:26\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"7974589e94a3bd31b2ccb08ca76d70a6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-11-27 05:49:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-11-27 05:49:26\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"d6fda0b56519a55c00210dc1e95c02ab\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-11-27 05:49:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-11-27 05:49:26\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"8c2a5ebeb418cc822327b9e81390ba39\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-11-27 05:49:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:64:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-11-27 05:49:26\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:64:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"8a7b22a1ef3c25dc3fd9d7bd20d616b6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-11-27 05:49:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:66:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-11-27 05:49:26\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:66:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"1f4b5334899f26cdc2bd119b7864f816\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-11-27 05:49:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.16.5\";s:2:\"to\";s:6:\"3.17.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-11-27 05:49:26\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.16.5\";s:2:\"to\";s:6:\"3.17.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"551dcb162172d2d7570af9c3d05e35d9\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2023-11-27 08:05:41\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:31:\"Undefined index: padding_mobile\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2023-11-27 08:05:41\";i:1;s:19:\"2023-11-27 08:05:48\";i:2;s:19:\"2023-11-27 08:05:52\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:31:\"Undefined index: padding_mobile\";s:4:\"file\";s:80:\"/home/maikutai/a.maikuta.ir\\wp-content\\plugins\\elementor\\core\\files\\css\\base.php\";s:4:\"line\";i:778;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:80:\"/home/maikutai/a.maikuta.ir\\wp-content\\plugins\\elementor\\core\\files\\css\\base.php\";s:7:\"\0*\0line\";i:778;}s:32:\"6b96df9e4367b6afae7c832ec39af722\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-22 20:12:53\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.17.3\";s:2:\"to\";s:6:\"3.31.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-22 20:12:53\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.17.3\";s:2:\"to\";s:6:\"3.31.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"7919abc56af90fb84cbf661bb1c1fb6b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-22 20:12:55\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-22 20:12:55\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"0dca2bc77ddbb849280d4533b8eddc79\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-22 20:12:55\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-22 20:12:55\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"2d3a53cebfad28fb857a0757c470953a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-22 20:12:55\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-22 20:12:55\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"055b4fab023932acf96e3c4dd875f1e7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-22 20:12:55\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:42:\"المنتور/Upgrades - _v_3_26_0 Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-22 20:12:55\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:42:\"المنتور/Upgrades - _v_3_26_0 Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"ade248c9a43edb99f5357725912d9667\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-22 20:12:55\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"المنتور/Upgrades - _v_3_26_0 Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-22 20:12:55\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"المنتور/Upgrades - _v_3_26_0 Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"e1b29836f9e220ab8ee47dae30bf4662\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-22 20:12:55\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.17.3\";s:2:\"to\";s:6:\"3.31.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-22 20:12:55\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.17.3\";s:2:\"to\";s:6:\"3.31.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ba89cd92a8eeae7b5584793a7576acc6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-22 20:12:58\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.17.3\";s:2:\"to\";s:6:\"3.31.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-22 20:12:58\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.17.3\";s:2:\"to\";s:6:\"3.31.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"8c714fac5f337ed34edbecea3ee69a2d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-08-23 04:15:10\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:107:\"Failed to execute &#039;querySelector&#039; on &#039;Document&#039;: &#039;#&#039; is not a valid selector.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:14;s:14:\"\0*\0times_dates\";a:14:{i:0;s:19:\"2025-08-23 04:15:10\";i:1;s:19:\"2025-08-23 04:15:10\";i:2;s:19:\"2025-08-23 04:15:10\";i:3;s:19:\"2025-08-23 04:15:10\";i:4;s:19:\"2025-08-23 04:17:00\";i:5;s:19:\"2025-08-23 04:17:00\";i:6;s:19:\"2025-08-23 04:17:00\";i:7;s:19:\"2025-08-23 04:17:00\";i:8;s:19:\"2025-08-30 17:46:44\";i:9;s:19:\"2025-08-30 17:46:44\";i:10;s:19:\"2025-08-30 17:48:52\";i:11;s:19:\"2025-08-30 17:48:52\";i:12;s:19:\"2025-08-30 17:48:52\";i:13;s:19:\"2025-08-30 17:48:52\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1755922510\";s:7:\"message\";s:77:\"Failed to execute \'querySelector\' on \'Document\': \'#\' is not a valid selector.\";s:3:\"url\";s:84:\"https://a.maikuta.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.2\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:7:\"1258999\";}s:7:\"\0*\0file\";s:84:\"https://a.maikuta.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.2\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:7:\"1258999\";}s:32:\"813d8949b649547472ac942fbae2fd3a\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-08-22 20:28:53\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:61:\"Document.querySelector: &#039;#&#039; is not a valid selector\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:10;s:14:\"\0*\0times_dates\";a:10:{i:0;s:19:\"2025-08-22 20:28:53\";i:1;s:19:\"2025-08-22 20:28:53\";i:2;s:19:\"2025-08-22 20:29:18\";i:3;s:19:\"2025-08-22 20:29:18\";i:4;s:19:\"2025-08-22 20:29:18\";i:5;s:19:\"2025-08-22 20:29:18\";i:6;s:19:\"2025-08-22 20:29:25\";i:7;s:19:\"2025-08-22 20:29:25\";i:8;s:19:\"2025-08-22 20:29:25\";i:9;s:19:\"2025-08-22 20:29:25\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1755894533\";s:7:\"message\";s:51:\"Document.querySelector: \'#\' is not a valid selector\";s:3:\"url\";s:84:\"https://a.maikuta.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.2\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:1:\"0\";}s:7:\"\0*\0file\";s:84:\"https://a.maikuta.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.2\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:1:\"0\";}s:32:\"7429493758b3bdf000438aac4d3c9b49\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-08-30 07:25:02\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:24:\"elementor is not defined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-30 07:25:02\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1756538702\";s:7:\"message\";s:24:\"elementor is not defined\";s:3:\"url\";s:84:\"https://a.maikuta.ir/wp-content/plugins/elementor/assets/js/common.min.js?ver=3.31.2\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"140215\";}s:7:\"\0*\0file\";s:84:\"https://a.maikuta.ir/wp-content/plugins/elementor/assets/js/common.min.js?ver=3.31.2\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"140215\";}}", "off");
INSERT INTO `wp_options` VALUES("3816", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("3817", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("3818", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("3819", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("3847", "elementor_install_history", "a:24:{s:5:\"3.0.5\";i:1599113471;s:6:\"3.0.13\";i:1605216502;s:6:\"3.0.14\";i:1606811151;s:5:\"3.1.4\";i:1617863693;s:5:\"3.2.3\";i:1620620213;s:5:\"3.2.4\";i:1624709859;s:5:\"3.2.5\";i:1624710219;s:5:\"3.4.5\";i:1634459836;s:5:\"3.4.8\";i:1637131635;s:5:\"3.5.6\";i:1647070628;s:5:\"3.6.1\";i:1648189421;s:5:\"3.6.4\";i:1650009816;s:5:\"3.6.6\";i:1655526821;s:5:\"3.7.8\";i:1665466275;s:5:\"3.8.0\";i:1668247995;s:6:\"3.11.0\";i:1676305148;s:6:\"3.11.2\";i:1677913608;s:6:\"3.11.5\";i:1678806738;s:6:\"3.12.2\";i:1682582261;s:6:\"3.13.4\";i:1686032940;s:6:\"3.15.1\";i:1690999658;s:6:\"3.16.5\";i:1697224307;s:6:\"3.17.3\";i:1701067766;s:6:\"3.31.2\";i:1755893575;}", "yes");
INSERT INTO `wp_options` VALUES("3865", "woocommerce_version", "10.1.2", "yes");
INSERT INTO `wp_options` VALUES("3888", "revslider_table_version", "1.0.13", "yes");
INSERT INTO `wp_options` VALUES("4077", "iwp_shield_settings_woodmart_theme", "45dbd47d59b591d8544915d51bf765a7", "yes");
INSERT INTO `wp_options` VALUES("4078", "1f82c51b0e1dc3d790bd51e8f8943da5", "{\"starter\":\"OGUzMDM1ZjAtYjBmZC00MzJjLWI1MmYtZjZlN2M1YjAwYTQ2\",\"action\":1,\"message\":\"\\u06a9\\u062f \\u0644\\u0627\\u06cc\\u0633\\u0646\\u0633 \\u0645\\u0639\\u062a\\u0628\\u0631 \\u0627\\u0633\\u062a.\",\"timer\":1599124551}", "yes");
INSERT INTO `wp_options` VALUES("4133", "rs-addons-counter", "1", "yes");
INSERT INTO `wp_options` VALUES("4142", "woocommerce_db_version", "10.1.2", "yes");
INSERT INTO `wp_options` VALUES("4184", "wc_admin_note_home_screen_feedback_homescreen_accessed", "1605216616", "yes");
INSERT INTO `wp_options` VALUES("4186", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":3:{s:22:\"there_were_no_products\";b:0;s:22:\"there_are_now_products\";b:1;s:17:\"new_product_count\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("4554", "woodmart-plugins-update-time", "1756499013", "yes");
INSERT INTO `wp_options` VALUES("4555", "woodmart_js_composer_version", "8.6.1", "yes");
INSERT INTO `wp_options` VALUES("4556", "woodmart_revslider_version", "6.7.37", "yes");
INSERT INTO `wp_options` VALUES("4651", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("4652", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("4653", "auto_update_core_major", "unset", "yes");
INSERT INTO `wp_options` VALUES("4820", "https_detection_errors", "a:1:{s:23:\"ssl_verification_failed\";a:1:{i:0;s:35:\"تأیید SSL ناموفق بود.\";}}", "off");
INSERT INTO `wp_options` VALUES("4840", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `wp_options` VALUES("4880", "wd_page_css_files_theme_version", "8.2.7.1", "yes");
INSERT INTO `wp_options` VALUES("5560", "woocommerce_inbox_variant_assignment", "11", "yes");
INSERT INTO `wp_options` VALUES("5566", "wc_remote_inbox_notifications_wca_updated", "", "off");
INSERT INTO `wp_options` VALUES("5700", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `wp_options` VALUES("5701", "woocommerce_analytics_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("5702", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:19:\"mj.masoud@yahoo.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:19:\"mj.masoud@yahoo.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "on");
INSERT INTO `wp_options` VALUES("5707", "woocommerce_task_list_hidden_lists", "a:1:{i:0;s:5:\"setup\";}", "yes");
INSERT INTO `wp_options` VALUES("5736", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5747", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("5783", "woocommerce_refund_returns_page_id", "471", "yes");
INSERT INTO `wp_options` VALUES("5957", "wd_wishlist_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("5992", "widget_wd-mailchimp-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6015", "elementor_controls_usage", "a:1:{s:7:\"wp-page\";a:4:{s:6:\"column\";a:2:{s:5:\"count\";i:37;s:8:\"controls\";a:2:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:37;}}s:8:\"advanced\";a:1:{s:19:\"_section_responsive\";a:2:{s:11:\"hide_tablet\";i:2;s:11:\"hide_mobile\";i:2;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:25;s:8:\"controls\";a:3:{s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:3:{s:6:\"margin\";i:3;s:7:\"padding\";i:10;s:14:\"padding_mobile\";i:2;}}s:6:\"layout\";a:2:{s:14:\"section_layout\";a:4:{s:3:\"gap\";i:7;s:15:\"stretch_section\";i:1;s:13:\"content_width\";i:1;s:16:\"content_position\";i:2;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:8;}}s:5:\"style\";a:2:{s:18:\"section_background\";a:3:{s:21:\"background_background\";i:4;s:16:\"background_color\";i:4;s:16:\"background_image\";i:1;}s:14:\"section_border\";a:3:{s:13:\"border_border\";i:1;s:12:\"border_width\";i:1;s:12:\"border_color\";i:1;}}}}s:9:\"accordion\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_title\";a:1:{s:4:\"tabs\";i:1;}}s:5:\"style\";a:1:{s:25:\"section_toggle_style_icon\";a:1:{s:10:\"icon_align\";i:1;}}}}s:5:\"image\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:13:\"section_image\";a:3:{s:5:\"image\";i:2;s:10:\"image_size\";i:2;s:5:\"align\";i:2;}}}}}}", "no");
INSERT INTO `wp_options` VALUES("6061", "theme_mods_twentytwentyone", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:16;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1637177449;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:6:\"text-3\";i:1;s:6:\"text-4\";i:2;s:6:\"text-5\";i:3;s:6:\"text-6\";i:4;s:6:\"text-8\";}s:9:\"sidebar-1\";a:8:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";i:6;s:26:\"woocommerce_price_filter-3\";i:7;s:32:\"woocommerce_product_categories-2\";}}}}", "off");
INSERT INTO `wp_options` VALUES("6466", "duplicator_settings", "a:19:{s:7:\"version\";s:8:\"1.5.13.1\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:24;s:14:\"usage_tracking\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("6467", "duplicator_version_plugin", "1.5.13.1", "yes");
INSERT INTO `wp_options` VALUES("6514", "wd_has_translation_files", "yes", "yes");
INSERT INTO `wp_options` VALUES("6695", "woocommerce_attribute_lookup_direct_updates", "no", "yes");
INSERT INTO `wp_options` VALUES("6805", "woocommerce_task_list_tracked_completed_tasks", "a:5:{i:0;s:13:\"store_details\";i:1;s:8:\"products\";i:2;s:8:\"payments\";i:3;s:8:\"purchase\";i:4;s:14:\"store_creation\";}", "yes");
INSERT INTO `wp_options` VALUES("6806", "woocommerce_task_list_completed_lists", "a:2:{i:0;s:8:\"extended\";i:1;s:19:\"extended_two_column\";}", "yes");
INSERT INTO `wp_options` VALUES("6807", "elementor_scheme_color", "a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}", "yes");
INSERT INTO `wp_options` VALUES("6808", "elementor_scheme_typography", "a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}", "yes");
INSERT INTO `wp_options` VALUES("6809", "elementor_scheme_color-picker", "a:8:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";}", "yes");
INSERT INTO `wp_options` VALUES("6823", "woodmart-generated-wpbcss-file", "", "yes");
INSERT INTO `wp_options` VALUES("6824", "xts-options-presets", "", "yes");
INSERT INTO `wp_options` VALUES("6825", "woodmart_setup_status", "", "yes");
INSERT INTO `wp_options` VALUES("6826", "wd_import_theme_version", "", "yes");
INSERT INTO `wp_options` VALUES("6834", "revslider-update-check", "1756613281", "yes");
INSERT INTO `wp_options` VALUES("6835", "revslider_update_info", "O:8:\"stdClass\":0:{}", "yes");
INSERT INTO `wp_options` VALUES("6838", "elementor_notice", "", "yes");
INSERT INTO `wp_options` VALUES("6839", "elementor_google_maps_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("6840", "elementor_font_display", "auto", "yes");
INSERT INTO `wp_options` VALUES("6843", "elementor_experiment-e_font_icon_svg", "default", "yes");
INSERT INTO `wp_options` VALUES("6844", "elementor_experiment-e_import_export", "default", "yes");
INSERT INTO `wp_options` VALUES("6845", "elementor_experiment-additional_custom_breakpoints", "default", "yes");
INSERT INTO `wp_options` VALUES("6846", "elementor_experiment-e_hidden_wordpress_widgets", "default", "yes");
INSERT INTO `wp_options` VALUES("6847", "elementor_experiment-favorite-widgets", "default", "yes");
INSERT INTO `wp_options` VALUES("6849", "elementor_experiment-a11y_improvements", "default", "yes");
INSERT INTO `wp_options` VALUES("6850", "elementor_experiment-landing-pages", "default", "yes");
INSERT INTO `wp_options` VALUES("6851", "elementor_experiment-elements-color-picker", "default", "yes");
INSERT INTO `wp_options` VALUES("6852", "elementor_experiment-admin-top-bar", "default", "yes");
INSERT INTO `wp_options` VALUES("6943", "wd_layouts_conditions", "a:1:{s:14:\"single_product\";a:1:{i:514;a:1:{i:0;a:3:{s:20:\"condition_comparison\";s:7:\"include\";s:14:\"condition_type\";s:3:\"all\";s:15:\"condition_query\";s:0:\"\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("7614", "elementor_events_db_version", "1.0.0", "no");
INSERT INTO `wp_options` VALUES("7656", "xts_successfully_installed_patches", "a:5:{s:5:\"6.3.3\";a:2:{i:361980;b:1;i:362454;b:1;}s:5:\"6.4.0\";a:2:{i:368396;b:1;i:367802;b:1;}s:5:\"7.2.4\";a:12:{i:471828;b:1;i:471689;b:1;i:471502;b:1;i:470773;b:1;i:469828;b:1;i:467966;b:1;i:467638;b:1;i:470343;b:1;i:470239;b:1;i:466539;b:1;i:469953;b:1;i:470222;b:1;}s:5:\"7.2.5\";a:5:{i:485763;b:1;i:485918;b:1;i:485893;b:1;i:485861;b:1;i:485766;b:1;}s:5:\"7.3.2\";a:6:{i:501741;b:1;i:501786;b:1;i:502795;b:1;i:502941;b:1;i:503072;b:1;i:503096;b:1;}}", "yes");
INSERT INTO `wp_options` VALUES("7802", "woocommerce_admin_version", "3.3.2", "yes");
INSERT INTO `wp_options` VALUES("8081", "woocommerce_task_list_reminder_bar_hidden", "yes", "yes");
INSERT INTO `wp_options` VALUES("8292", "_elementor_editor_upgrade_notice_dismissed", "1755894288", "yes");
INSERT INTO `wp_options` VALUES("8413", "wc_downloads_approved_directories_mode", "disabled", "yes");
INSERT INTO `wp_options` VALUES("8744", "duplicator_exe_safe_mode", "", "yes");
INSERT INTO `wp_options` VALUES("8831", "xts_backups_auto", "a:5:{i:1690991962;a:5:{s:5:\"title\";s:21:\"بکاپ خودکار\";s:4:\"date\";s:19:\"2023-08-02 15:59:22\";s:4:\"auto\";b:1;s:7:\"options\";a:618:{s:11:\"insta_token\";s:0:\"\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:5:\"after\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"1\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"0\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:1:\"0\";s:23:\"stretch_product_desktop\";s:1:\"0\";s:22:\"stretch_product_tablet\";s:1:\"0\";s:22:\"stretch_product_mobile\";s:1:\"0\";s:25:\"product_title_lines_limit\";s:3:\"two\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"0\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"1\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:23:\"grid_stock_progress_bar\";s:1:\"1\";s:14:\"shop_countdown\";s:1:\"1\";s:22:\"categories_under_title\";s:1:\"0\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"0\";s:15:\"shop_categories\";s:1:\"0\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"4\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"30\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:2:{i:0;s:1:\"3\";i:1;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:1:\"8\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:7:\"9,24,36\";s:15:\"shop_pagination\";s:8:\"more-btn\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"233\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_content\";s:2:\"35\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_246188\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:171:\"<h4 style=\"text-align: center\">Are you over 18?</h4>\r\n<p style=\"text-align: center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:134:\"<h4 style=\"text-align: center\">Access forbidden</h4>\r\n<p style=\"text-align: center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:4:\"text\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:0:\"\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"p